﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Net.Sockets;
using System.Web;
using System.IO;
using System.Xml;
using System.Threading;

namespace NicoLib {
	abstract public class Basic {
		private string UserAgent;
		private CookieContainer cc;

		public Basic() {
			UserAgent = "";
			this.cc = new CookieContainer();
		}

		public Basic(CookieContainer cc) {
			UserAgent = "";
			this.cc = cc;
		}

		protected string HttpPost(string url) {
			return HttpPost(url , "" , "");
		}

		protected string HttpPost(string url , string value , params string[] valitem) {
			//urlエンコード
			for ( int i = 0; i < valitem.Count(); i++ ) valitem[i] = HttpUtility.UrlEncode(valitem[i]);
			string valuedata = string.Format(value , valitem);

			// WebRequest作成
			byte[] data = Encoding.ASCII.GetBytes(valuedata);
			HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
			req.ContentType = "application/x-www-form-urlencoded";
			req.UserAgent = UserAgent;
			req.ContentLength = data.Length;
			req.Method = "Post";
			req.CookieContainer = cc;

			// WebRequestに対してPOST
			try {
				Stream reqStream = req.GetRequestStream();
				reqStream.Write(data , 0 , data.Length);
				reqStream.Close();
			}
			catch ( WebException ex ) {
				if ( ex.Status == WebExceptionStatus.NameResolutionFailure ) {
					Console.WriteLine("ネットワーク接続エラー: ネットワークに繋がっていない可能性があります");
					return null;
				} else {
					Console.WriteLine(ex);
					return null;
				}
			}

			// Responseを受け取る    
			WebResponse res = req.GetResponse();
			Stream resStream = res.GetResponseStream();
			StreamReader sr = new StreamReader(resStream , Encoding.UTF8);
			string result = sr.ReadToEnd();
			resStream.Close();

			return result;
		}
	}

	static public class Convenience {
		public static string RemoveTag(string article) {
			char[] chars = article.ToCharArray();
			bool isTag = false;
			StringBuilder result = new StringBuilder();

			for ( int i = 0; i < chars.Length; i++ ) {
				if ( chars[i] == '<' )
					isTag = true;
				else if ( chars[i] == '>' )
					isTag = false;
				else if ( !isTag )
					result.Append(chars[i]);
			}

			return result.ToString();
		}
	}
}
