package jalert;

import nicolib.api.NicoApiException;
import nicolib.api.alert.StreamInfo;
import nicolib.comment.AlertChat;
import nicolib.comment.AlertReceiverHandler;
import nicolib.comment.AlertReceiver;
import nicolib.comment.ConnectionHandler;
import nicolib.comment.ThreadHeader;

public class AlertTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		try {
			
			AlertReceiver receiver = new AlertReceiver();
			receiver.setHandler(new ConnectionHandler() {
				@Override
				public void connectServer(ThreadHeader thread, String originalText) {
					System.out.println("接続完了");
				}
				
				@Override
				public void disconnectServer() {
					// TODO 自動生成されたメソッド・スタブ
					
				}
			});
			
			receiver.setHandler(new AlertReceiverHandler() {
				@Override
				public void receiveStreamInfo(StreamInfo info, AlertChat chat) {
					if(info != null){
						System.out.println(info.getTitle());
					} else {
						System.err.println(chat.getLiveId() + "のstreamInfo取得に失敗しました");
					}
				}
				
				@Override
				public void receiveAlertChat(AlertChat chat, String text) {
					System.out.print(String.format("no:%d %s %s ", chat.getNo(), chat.getCommunityId(), chat.getLiveId()));			
				}
			});
			
			receiver.connectServer(true);
			
		} catch (NicoApiException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} 
		

	}

}
