package jwhois;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

import nicolib.api.NicoApiException;
import nicolib.cookie.UserSession;
import nicolib.cookie.UserSession.Browser;

import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.GroupLayout;
import org.dyno.visual.swing.layouts.Leading;

//VS4E -- DO NOT REMOVE THIS LINE!
public class LoginDialog extends JDialog {
	private boolean isDirectLoginMode = true;
	private boolean result;
	
	private static final long serialVersionUID = 1L;
	private JRadioButton jRadioButton0;
	private JLabel jLabel1;
	private JLabel jLabel0;
	private JPasswordField jPasswordField0;
	private JTextField jTextField0;
	private JPanel jPanel0;
	private JRadioButton jRadioButton1;
	private JRadioButton jRadioButton2;
	private JPanel jPanel1;
	private JButton jButton0;
	private ButtonGroup buttonGroup1;

	public LoginDialog() {
		initComponents();
	}

	public LoginDialog(Frame parent) {
		super(parent);
		initComponents();
	}

	public LoginDialog(Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
	}

	public LoginDialog(Frame parent, String title) {
		super(parent, title);
		initComponents();
	}

	public LoginDialog(Frame parent, String title, boolean modal) {
		super(parent, title, modal);
		initComponents();
	}

	public LoginDialog(Frame parent, String title, boolean modal,
			GraphicsConfiguration arg) {
		super(parent, title, modal, arg);
		initComponents();
	}

	public LoginDialog(Dialog parent) {
		super(parent);
		initComponents();
	}

	public LoginDialog(Dialog parent, boolean modal) {
		super(parent, modal);
		initComponents();
	}

	public LoginDialog(Dialog parent, String title) {
		super(parent, title);
		initComponents();
	}

	public LoginDialog(Dialog parent, String title, boolean modal) {
		super(parent, title, modal);
		initComponents();
	}

	public LoginDialog(Dialog parent, String title, boolean modal,
			GraphicsConfiguration arg) {
		super(parent, title, modal, arg);
		initComponents();
	}

	public LoginDialog(Window parent) {
		super(parent);
		initComponents();
	}

	public LoginDialog(Window parent, ModalityType modalityType) {
		super(parent, modalityType);
		initComponents();
	}

	public LoginDialog(Window parent, String title) {
		super(parent, title);
		initComponents();
	}

	public LoginDialog(Window parent, String title, ModalityType modalityType) {
		super(parent, title, modalityType);
		initComponents();
	}

	public LoginDialog(Window parent, String title, ModalityType modalityType,
			GraphicsConfiguration arg) {
		super(parent, title, modalityType, arg);
		initComponents();
	}

	private void initComponents() {
		setTitle("Login");
		setFont(new Font("Dialog", Font.PLAIN, 12));
		setBackground(Color.white);
		setForeground(Color.black);
		setLayout(new GroupLayout());
		add(getJRadioButton0(), new Constraints(new Leading(11, 10, 10), new Leading(8, 8, 8)));
		add(getJPanel0(), new Constraints(new Leading(19, 294, 10, 10), new Leading(31, 68, 10, 10)));
		add(getJRadioButton1(), new Constraints(new Leading(10, 8, 8), new Leading(104, 10, 10)));
		add(getJPanel1(), new Constraints(new Leading(19, 294, 12, 12), new Leading(127, 53, 10, 10)));
		add(getJButton0(), new Constraints(new Leading(250, 10, 10), new Leading(189, 10, 10)));
		addWindowListener(new WindowAdapter() {
	
			public void windowOpened(WindowEvent event) {
				windowWindowOpened(event);
			}
		});
		initButtonGroup1();
		setSize(320, 222);
	}

	private void initButtonGroup1() {
		buttonGroup1 = new ButtonGroup();
		buttonGroup1.add(getJRadioButton1());
		buttonGroup1.add(getJRadioButton0());
	}

	private JButton getJButton0() {
		if (jButton0 == null) {
			jButton0 = new JButton();
			jButton0.setText("Login");
			jButton0.addActionListener(new ActionListener() {
	
				public void actionPerformed(ActionEvent event) {
					jButton0ActionActionPerformed(event);
				}
			});
		}
		return jButton0;
	}

	private JPanel getJPanel1() {
		if (jPanel1 == null) {
			jPanel1 = new JPanel();
			jPanel1.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED, null, null));
			jPanel1.setEnabled(false);
			jPanel1.setLayout(new GroupLayout());
			jPanel1.add(getJRadioButton2(), new Constraints(new Leading(6, 10, 10), new Leading(10, 10, 10)));
		}
		return jPanel1;
	}

	private JRadioButton getJRadioButton2() {
		if (jRadioButton2 == null) {
			jRadioButton2 = new JRadioButton();
			jRadioButton2.setSelected(true);
			jRadioButton2.setText("Firefox");
			jRadioButton2.setEnabled(false);
		}
		return jRadioButton2;
	}

	private JRadioButton getJRadioButton1() {
		if (jRadioButton1 == null) {
			jRadioButton1 = new JRadioButton();
			jRadioButton1.setText("Share");
			jRadioButton1.addActionListener(new ActionListener() {
	
				public void actionPerformed(ActionEvent event) {
					jRadioButton1ActionActionPerformed(event);
				}
			});
		}
		return jRadioButton1;
	}

	private JPanel getJPanel0() {
		if (jPanel0 == null) {
			jPanel0 = new JPanel();
			jPanel0.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED, null, null));
			jPanel0.setLayout(new GroupLayout());
			jPanel0.add(getJLabel1(), new Constraints(new Leading(6, 12, 12), new Leading(38, 12, 12)));
			jPanel0.add(getJLabel0(), new Constraints(new Leading(9, 10, 10), new Leading(7, 19, 12, 12)));
			jPanel0.add(getJPasswordField0(), new Constraints(new Leading(67, 214, 12, 12), new Leading(36, 12, 12)));
			jPanel0.add(getJTextField0(), new Constraints(new Leading(67, 214, 12, 12), new Leading(8, 12, 12)));
		}
		return jPanel0;
	}

	private JTextField getJTextField0() {
		if (jTextField0 == null) {
			jTextField0 = new JTextField();
		}
		return jTextField0;
	}

	private JPasswordField getJPasswordField0() {
		if (jPasswordField0 == null) {
			jPasswordField0 = new JPasswordField();
			jPasswordField0.setEchoChar('*');
		}
		return jPasswordField0;
	}

	private JLabel getJLabel0() {
		if (jLabel0 == null) {
			jLabel0 = new JLabel();
			jLabel0.setText("Mail");
		}
		return jLabel0;
	}

	private JLabel getJLabel1() {
		if (jLabel1 == null) {
			jLabel1 = new JLabel();
			jLabel1.setText("Password");
		}
		return jLabel1;
	}

	private JRadioButton getJRadioButton0() {
		if (jRadioButton0 == null) {
			jRadioButton0 = new JRadioButton();
			jRadioButton0.setSelected(true);
			jRadioButton0.setText("Login");
			jRadioButton0.addActionListener(new ActionListener() {
	
				public void actionPerformed(ActionEvent event) {
					jRadioButton0ActionActionPerformed(event);
				}
			});
		}
		return jRadioButton0;
	}

	private void jRadioButton0ActionActionPerformed(ActionEvent event) {
		isDirectLoginMode = jRadioButton0.isSelected();
		setItemsEnable();
	}

	private void jRadioButton1ActionActionPerformed(ActionEvent event) {
		isDirectLoginMode = !jRadioButton1.isSelected();
		setItemsEnable();
	}

	private void setItemsEnable(){
		jTextField0.setEnabled(isDirectLoginMode);
		jPasswordField0.setEnabled(isDirectLoginMode);
		jRadioButton2.setEnabled(!isDirectLoginMode);
	}

	private void jButton0ActionActionPerformed(ActionEvent event) {
		try{
			if(isDirectLoginMode){
				
				result = UserSession.login(jTextField0.getText(), new String(jPasswordField0.getPassword()));
				
			}else{
				
				result = UserSession.shareCookie(Browser.FireFox);
				
			}
		}catch(NicoApiException e){
			JOptionPane.showMessageDialog(this, "ログインにエラーが発生しました\n" + e, "失敗", JOptionPane.ERROR_MESSAGE);
			result = false;
		}
		
		if(result){
			dispose();
		}else{
			JOptionPane.showMessageDialog(this, "ログイン失敗");
		}
	}
	
	public boolean getResult(){
		return result;
	}

	private void windowWindowOpened(WindowEvent event) {
		jRadioButton0.setSelected(true);
	}
	
}
