package nicolib.comment;

/**
 * コメントサーバーへの接続・切断状況の通知を受け取るためのインターフェース
 * @author hal
 *
 */
public interface CommentHandler {
	
	/**
	 * サーバーとの通信が開始された時に呼び出されます
	 * @param thread
	 */
	public void connectServer(ThreadHeader thread);
	
	/**
	 * サーバーとの通信が終了したときに呼び出されます
	 */
	public void disconnectServer();
}
