package nicolib.comment;

/**
 * 生放送のコメントとコメントの送信結果を受け取るためのインターフェース
 * @author hal
 *
 */
public interface LiveHandler extends CommentHandler {
	
	/**
	 * コメントサーバーからコメントを受け取ったときに呼び出されます。
	 * @param chat
	 */
	public void receiveChat(Chat chat);
	
	/**
	 * コメントの送信結果を受け取ったときに呼び出されます。
	 * @param chatResult
	 */
	public void receiveChatResult(ChatResult chatResult);
}
