package nicolib.cookie;

import java.io.Serializable;

import nicolib.NicolibException;
import nicolib.api.Common;
import nicolib.api.NicoApiException;
import nicolib.util.Http;
import nicolib.util.Logger;

/**
 * ニコニコ動画のログイン情報を管理するクラス
 * @author hal
 *
 */
public class UserSession implements Serializable{

	private static final long serialVersionUID = 1L;
	
	/**
	 * アカウント情報を利用してログインします
	 * @param mail
	 * @param password
	 * @return ログインで来たか
	 * @throws NicoApiException
	 */
	public static boolean login(String mail, String password) 
		throws NicoApiException
	{
		
		return Common.login(mail, password);
		
	}
	
	/**
	 * 指定したブラウザからニコニコ用のクッキーを取得して共有します
	 * @param browser
	 * @return ブラウザから取得で来たか
	 */
	public static boolean shareCookie(Browser browser)
	{
		String session = null;
		
		try{
		
			switch(browser){
			case FireFox:
				session = FirefoxCookie.GetUserSession();
				break;
			}
			
			if(session != null){
				Http.setUserSession(session);
				
				return true;
			}
		}catch(NicolibException e){
			Logger.writeException(e);
		}
		
		return false;
	}
	
	
	public enum Browser{
		InternetExplorer,
		Opera,
		FireFox,
		Chrome,
		Safari,
		Library,
		Error
	}
}
