package namaComment;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;

/**
 * コレは何のためのクラス？
 * @author もめんと
 *
 * コメントサーバ接続に必要な材料をAPIから取得するクラスです。
 * @author Talisker
 *
 * APIとメソッドは１：１な感じ？目的によって複数のAPIを呼ぶ感じ？
 * @author もめんと
 *
 * TODO この生成された型コメントのテンプレートを変更するには次へジャンプ:
 * ウィンドウ - 設定 - Java - コード・スタイル - コード・テンプレート
 */
public class CommentSeeds extends NicoSuper{
	private class PlayerStatus {
		boolean status;
		public class ServerInformation {
			public String thread;
			public String address;
			public int port;
		}
		ServerInformation si = new ServerInformation();
	}

	private static final String SEEDS_URL = "http://live.nicovideo.jp/api/getplayerstatus?v=";
	protected String url = null;
	protected String thread = null;
	protected int port = 0;

	private PlayerStatus ps;

	public CommentSeeds(String mail, String pass) throws IOException{
		super(mail, pass);
	}
	public CommentSeeds(String user_session){
		super(user_session);
	}

	//接続して、必要項目をセットするだけ。
	public void openConnection(String lvNum) throws Exception{
		// lvのチェック

		//
        URL api = new URL(SEEDS_URL + lvNum);
        HttpURLConnection http = (HttpURLConnection)api.openConnection();

        http.setRequestMethod("GET");
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        http.setRequestProperty("Cookie", SESSION_KEYNAME + "=" + this.user_session);

        // TODO 受信して解析
        BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
        StringBuffer xml = new StringBuffer();
        while (in.ready()) {
        	xml.append(in.readLine());
        	xml.append("\n");
        }
        System.out.println(xml);

        StringBuffer StringBuffer1 = new StringBuffer(xml);
        ByteArrayInputStream Bis1 = new
        ByteArrayInputStream(StringBuffer1.toString().getBytes("UTF-8"));

        this.ps = this.parse(Bis1);

        //debug
        System.out.println(ps.status);
        System.out.println(ps.si.address);
        System.out.println(ps.si.port);
        System.out.println(ps.si.thread);

		//user_sessionとlv000000を使い、SEEDS_URLにアクセス。
		//返ってくるXMLデータを分解する。
		//投げる例外は、XMLのstatusがfailの時(user_sessionが根源)、パース失敗時等小分けると良いかも。
		this.thread = ps.si.thread;
		this.url = ps.si.address;
		this.port = ps.si.port;
	}

	/**
	 * GetPlayerStatusをパースするメソッド
	 *
	 * とりあえず必要なコメントサーバ情報のみ解析。
	 * TODO エラー処理未実装
	 * @param is
	 * @return
	 */
	private PlayerStatus parse(InputStream is)
	{
		PlayerStatus ps = new PlayerStatus();
	    try {
	        // ドキュメントビルダーファクトリを生成
	        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
	        // ドキュメントビルダーを生成
	        DocumentBuilder builder = dbfactory.newDocumentBuilder();
	        // パースを実行してDocumentオブジェクトを取得
	        Document doc = builder.parse(is);

            // 準備
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();

//debug            System.out.println(doc.toString());

            // ノードXPATH一覧
            final String XStatus = "/getplayerstatus/@status";
            final String XAddress = "/getplayerstatus/ms/addr";
            final String XPort = "/getplayerstatus/ms/port";
            final String XThread = "/getplayerstatus/ms/thread";

        	// TODO 要エラー処理
            String status = xpath.evaluate(XStatus, doc);
	        ps.status = status.equals("ok");

	        if (ps.status) {
	        	// TODO 要エラー処理
                String address = xpath.evaluate(XAddress, doc);
                String port = xpath.evaluate(XPort, doc);
                String thread = xpath.evaluate(XThread, doc);
    	        ps.si.address = address;
    	        ps.si.port = Integer.parseInt(port);
    	        ps.si.thread = thread;
            }

	      } catch (Exception e) {
	        e.printStackTrace();
	      }
	      return ps;
	}
		//thread,url,portのgetter3発用意。
}
