<?php
/**
 * NicoCommentClient.class.php
 * 
 * @author poochin
 * @package nicolib
 * @version $Id:$
 * @copyright Copyright (c) 2009-2010 poochin.
 */

define ('NICO_CLIENT_SUCCESS', 0);
define ('NICO_CLIENT_EMPTY', 1);

abstract class NicoCommentClient
{
    /* public variables */
    // none.
    
    /* private variables */
    // none.
    
    /* protected variables */
    protected $_client_type;    // Set ID of NicoNico Service
    protected $_fp;             // File Handle
    protected $_addr;           // Server address
    protected $_port;           // Server port
    protected $_thread;
    
    protected $_stream_raw;     // thread-chat datas
    protected $_stream_lines;        // stream array;
    
    /* abstract puclic functions */
    // none.
    
    /* abstract private functions */
    // none.
    
    /* abstract protected functions */
    // none.
    
    /* public functions */
    public function __construct()
    {
        $this->_fp = null;
    }
    
    public function __destruct()
    { }
    
    public function initClient($addr, $port, $thread)
    {
        $this->_addr = $addr;
        $this->_port = $port;
        $this->_thread = $thread;
        
        $this->_fp = fsockopen($this->_addr, $this->_port);
        
        $post_data =  '<thread thread="'.($this->_thread).'" res_from="-5" version="20061206"/>'."\0";
        fwrite($this->_fp, $post_data);
    }
    
    public function aliveSocket()
    {
        if ($this->_fp == null) {
            return false;
        }
        if (feof($this->_fp)) {
            return false;
        }
        return true;
    }
    
    /* private functions */
    // none.
    
    /* protected functions */
    protected function getStream()
    {
        $str = freadPossible($this->_fp);
        
        if (empty($str)) {
            return NICO_CLIENT_EMPTY;
        }
        
        $this->_stream_raw .= preg_replace("/(\n|\r|\\0)/", "", $str);
        
        $xml_string = preg_replace("/(?=<[^\/])/", "\n", $str);
        
        $lines = explode("(\n|\\0)", $xml_string);
        foreach ($lines as $line) {
            if (!empty ($line)) {
                $this->_stream_lines[] = $line;
            }
        }
        return NICO_CLIENT_SUCCESS;
    }
}
