<?php
/**
 * NicoCommentClient.class.php
 * 
 * @author poochin
 * @package nicolib
 * @version $Id:$
 * @copyright Copyright (c) 2009-2010 poochin.
 */


class NicoLiveComment extends NicoCommentClient 
{
    /* public variables */
    // none.
    
    /* private variables */
    private $_getplayerstatus_raw;  // getplayerstatus
    
    private $_lv_id;        // LiveID = lv12345, if type is live
    private $_owner_id;
    private $_start_time;   // Stream Start time
    
    private $_chats_num = 0;    // last comment number
    private $_chats;        // chat datas
    
    /* protected variables */
    // none.
    
    /* abstract public functions */
    // none.
    
    /* abstract private functions */
    // none.
    
    /* abstract protected functions */
    // none.
    
    /* public functions */
    public function __construct()
    { }
    
    public function set_getplayerstatus($getplayerstatus)
    {
        $this->_getplayerstatus_raw = $getplayerstatus;
        
        $xml = simplexml_load_string($getplayerstatus);
        $attributes  = $xml->attributes();
        
        if ((string)$attributes->status == 'fail') {
            return;
        }
        
        $this->_addr = (string)$xml->ms->addr;
        $this->_port = (string)$xml->ms->port;        // 繋げるべきポート
        $this->_thread = (string)$xml->ms->thread;    // 自分が利用するスレッド
        $this->_owner_id = (string)$xml->stream->owner_id;
                
        self::initClient($this->_addr, $this->_port, $this->_thread);
    }
    
    public function getComments()
    {
        $result = self::getStream();
        
        if ($result == NICO_CLIENT_EMPTY) {
            return array();
        }
        
        self::recalcChats();
        
        /**
         * <thread/> のみを受信した場合、chats は無い
         */
        if (empty($this->_chats)) {
            return array();
        }
        
        $last_num = $this->_chats_num;
        $this->_chats_num = count($this->_chats);
        
        return array_slice($this->_chats, $last_num);
    }
    
    /* private functions */
    private function recalcChats()
    {
        $chats_raw = array_slice($this->_stream_lines, $this->_chats_num+1);
        
        foreach ($chats_raw as $chat_raw) {
            $xml = simplexml_load_string($chat_raw);
            $attributes = $xml->attributes();
            
            $chat = array(
                'date' => (string)$attributes->date,
                'no' => (string)$attributes->no,
                'premium' => (string)$attributes->premium,
                'thread' => (string)$attributes->thread,
                'user_id' => (string)$attributes->user_id,
                'vpos' => (string)$attributes->vpos,
                'anonymity' => @(string)$attributes->anonymity,
                'chat' => (string)$xml,
            );
            
            $this->_chats[] = $chat;
            
            if ($chat['user_id'] == $this->_owner_id && $chat['chat'] == '/disconnect') {
                self::close();
            }
        }
    }
    
    /* protected functions */
    // none.
}
