var timestamp = 0;
var rowid = -1;

$(document).ready(function(){
	GetNewMessages();
});
  
function GetNewMessages()
{
	$.ajax({
		type: "GET",
		url: "./api.php",
        timeout : 10000,
		data: {timestamp: timestamp, rowid: rowid},
		error:GetNewMessages_Error, 
		success: GetNewMessages_Success
	});
}

var GetNewMessages_Error = function (text, textStatus)
{
	if (textStatus == 'error') {
		GetNewMessages();
	}
}

var GetNewMessages_Success = function(text)
{
	if (text.length != 0) {
		ParseAndInsert(text);
	}
	GetNewMessages();
}

function ParseAndInsert(text)
{
	var messages = text.split("\n");
	for (var i = 0; i < messages.length; i++) {
		var sp = messages[i].split("<>");
		var uhash = sp[1];
		var message = sp[2];
		var d = new Date();
		
		d.setTime(parseInt(sp[3]) * 1000);
		var strDate = d.getFullYear() + '年' + (d.getMonth()+1) + '月' + d.getDay() + '日' +
						d.getHours() + '時' + d.getMinutes() + '分' + d.getSeconds() + '秒';
		
		var dt = "<dt><b>" + sp[0] + "</b> : [@" + uhash + "] - " + strDate + "</dt>\n";
		var dd = "<dd>" + message + "</dd>\n";
		
		$("#messages").prepend(dd);
		$("#messages").prepend(dt);
		
		rowid = sp[0];
		timestamp = sp[3];
	}
}


function PostMessage()
{
	var message = document.getElementById('post').value;
	$.post("./api.php", {message: message}, PostMessage_Success);
}

function PostMessage_Success(text)
{
	document.getElementById('post').value = "";
}
