<?php
/**
 * NicoAlertSocket.class.php
 * 
 * @author poochin
 * @package nicolib
 * @version $Id:$
 * @copyright Copyright (c) 2009-2010 poochin.
 */


class NicoAlertSocket extends NicoCommentClient 
{
    /* public variables */
    // none.
    
    /* private variables */
    private $_getalertstatus_raw;  // getplayerstatus
    
    private $_chats_num = 0;    // last comment number
    private $_chats;        // chat datas
    
    /* protected variables */
    // none.
    
    /* abstract public functions */
    // none.
    
    /* abstract private functions */
    // none.
    
    /* abstract protected functions */
    // none.
    
    /* public functions */
    public function __construct()
    { }
    
    public function set_getalertstatus($getalertstatus)
    {
        $this->_getalertstatus_raw = $getalertstatus;
        
        $xml = simplexml_load_string($getalertstatus);
        $attributes  = $xml->attributes();
        
        if ((string)$attributes->status == 'fail') {
            return;
        }
        
        $this->_addr = (string)$xml->ms->addr;
        $this->_port = (string)$xml->ms->port;        // 繋げるべきポート
        $this->_thread = (string)$xml->ms->thread;    // 自分が利用するスレッド
                
        self::initClient($this->_addr, $this->_port, $this->_thread);
    }
    
    public function getLives()
    {
        $result = self::getStream();
        
        if ($result == NICO_CLIENT_EMPTY) {
            return array();
        }
        
        self::recalcChats();
        
        /**
         * <thread/> のみを受信した場合、chats は無い
         */
        if (empty($this->_chats)) {
            return array();
        }
        
        $last_num = $this->_chats_num;
        $this->_chats_num = count($this->_chats);
        
        return array_slice($this->_chats, $last_num);
    }
    
    /* private functions */
    private function recalcChats()
    {
        $chats_raw = array_slice($this->_stream_lines, $this->_chats_num+1);
        
        foreach ($chats_raw as $chat_raw) {
            $xml = simplexml_load_string($chat_raw);
            $attributes = $xml->attributes();
            
            list($lv_num, $com_id, $owner_id) = explode(',', (string)$xml);

            $chat = array(
                'date' => (string)$attributes->date,
                'no' => (string)$attributes->no,
                'premium' => (string)$attributes->premium,
                'thread' => (string)$attributes->thread,
                'owner_id' => (string)$owner_id,
                'vpos' => (string)$attributes->vpos,
                'lv_num' => (string)$lv_num,
                'lv_id' => (string)('lv'.$lv_num),
                'community_id' => (string)$com_id,
            );
            
            $this->_chats[] = $chat;
        }
    }
    
    /* protected functions */
    // none.
}
