<?php
/**
 * Comment.class.php
 * 
 * @author KT
 * @package nicolib
 * @version $Id:$
 * @copyright Copyright (c) 2009-2010 KT.
 */
class Comment {
  private $_mailAddress;
  private $_password;
  private $_lvId;
  private $_loginUrl   = 'https://secure.nicovideo.jp/secure/login?site=niconico'; 
  private $_statusUrl  = 'http://live.nicovideo.jp/api/getplayerstatus?v=lv'; 
  private $_cookiePath = 'cookie.tmp';
  
  /**
   * コンストラクタ
   */
  public function __construct($mailAddress, $password, $lvId)
  {
    $this->_mailAddress = $mailAddress;
    $this->_password = $password;
    $this->_lvId = $lvId;
    
    $this->getComment($this->getLiveInfo());
    
  }

  /**
   * getLiveInfo.
   */
  private function getLiveInfo()
  {
    $xmlLoadFlag = 2;
    
    while ($xmlLoadFlag) {
      $xml = $this->getPlayerStatus($this->_lvId);
      $sxml = simplexml_load_string($xml);
      
      if ($sxml === false) {
        echo 'Error while parsing the document.';
        echo $xml;
        exit;
      }
      
      $code = $sxml->xpath('//code');
      
      if ($code != null) {
        if ((string)$code[0] == "notlogin") {
          $this->login();
          $xmlLoadFlag--;
          
        } else if ((string)$code[0] == "closed") {
          echo 'Live Closed';
          return null;
          
        } else {
          echo 'Error on server';
          echo $xml;
          
          return null;
        }
        
      } else {
        $xmlLoadFlag = 0;
      }
    }
    //var_dump($sxml);
    return $sxml;
  }

  /**
   * Login.
   */
    private function login()
    {
        $postData = array('mail' => $this->_mailAddress, 'password' => $this->_password);

        $ch = curl_init($this->_loginUrl);
        curl_setopt($ch, CURLOPT_HEADER, TRUE);
        curl_setopt($ch, CURLOPT_NOBODY, TRUE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_COOKIEJAR, $fp);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        $output = curl_exec($ch);

        $location = '';
        $lines = split("\n", $output);
        foreach ($lines as $line) {
            if (preg_match('/^location:\s+(.*)/i', $line, $match)) {
                $location = $match[1];
            }
        }

        curl_setopt($ch, CURLOPT_URL, $location);
        curl_setopt($ch, CURLOPT_HEADER, TRUE);
        curl_setopt($ch, CURLOPT_NOBODY, TRUE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_COOKIEJAR, $fp);
        $output = curl_exec($ch);
        curl_close($ch);

        $authflag = 0;
        $lines = split("\n", $output);
        foreach ($lines as $line) {
            if (preg_match('/^x-niconico-authflag:\s+(.*)/i', $line, $match)) {
                $authflag = $match[1];
            }
        }

        return $authflag;
    }

  /**
   * getPlayerStatus.
   */
  public function getPlayerStatus()
  {
    $url = $this->_statusUrl . $this->_lvId;
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_SSLVERSION, 3);
    curl_setopt($ch, CURLOPT_HEADER, 0); 
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);  
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
    curl_setopt($ch, CURLOPT_VERBOSE, 1); 
    curl_setopt($ch, CURLOPT_COOKIEJAR, $this->_cookiePath);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $this->_cookiePath);
    curl_setopt($ch, CURLOPT_POST, 1);
    
    $data = curl_exec($ch);
    curl_close($ch); 
    
    return $data;
  }
  
  /**
   * getComment.
   */
  function getComment($sxml)
  {
    $thread = (string)$sxml->ms->thread;
    $addr   = (string)$sxml->ms->addr;
    $port   = (string)$sxml->ms->port;
    
    #var_dump($sxml->ms);
    #print $addr.':'.$port;
    
    $filename = 'tmp/nicolib_lv';
    
    $fp = @fsockopen ($addr, $port, $errno, $errstr, 3);
    
    if (!$fp) {
      echo 'Could not connect.';
      if ($errno && $errstr) {
        echo ' [' . $errno .':' . $errstr . "]\n";
      }
    } else {
      stream_set_timeout($fp, 3);
      
      $request = '<thread thread="' . $thread . '" version="20061206" res_from="-200" />';
      
      fputs ($fp, $request . "\0");
      
      $str = '';
      
      //for ($i=0;$i<3;$i++){
      //while(true){
        
        while (false !== ($char = fgetc($fp)) ){
          $str .= $char;
          echo $char;
        }
        
        $handle = fopen($filename . $this->_lvId . '.txt', 'a');
        
        if ($handle !== false) {
          fwrite($handle, $str);
          fclose($handle);
        }
        
        //sleep(3);
        
      //}
      
      fclose ($fp);
      
    }
    
    return true;
  }
  
}
