﻿//-------------------------------------------------------------------------
// Main Form
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: WorkerAutoExtend.cs 698 2010-07-05 13:11:28Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.ComponentModel;
using System.Threading;
using System.Windows.Forms;

namespace NicoLive
{
    partial class Form1
    {
        //-------------------------------------------------------------------------
        // 自動無料延長用ワーカー
        //-------------------------------------------------------------------------
        private void AutoExtendWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            int wait = 1000 * 2;
            bool push_extend;
            bool extend_wait = false;

            using (AutoExtend ax = new AutoExtend())
            {
                while (true)
                {
                    push_extend = false;

                    if (mNico == null) return;

                    //if (!mNico.IsLogin) continue;

                    // ウェイト
                    if (this.WindowState == FormWindowState.Minimized)
                    {
                        Thread.Sleep(wait);
                        continue;
                    }

                    if (this.Bounds.Width < 50 || this.Bounds.Height < 50)
                    {
                        //Thread.Sleep(wait);
                        continue;
                    }

                    // 延長が完了したらしばらく休憩
                    if (extend_wait)
                    {
                        Thread.Sleep(1000 * 60 * 5);
                        extend_wait = false;
                        continue;
                    }

                    mIsExtend = false;

                    UInt32 time = mLiveInfo.Time;
                    UInt32 btime = mLiveInfo.StartTime;

                    if (btime < time)
                    {
                        UInt32 lim = 30 * 60;        // 30分
                        UInt32 sub = time - btime;  // 経過時間

                        //
                        if (sub > lim)
                        {
                            UInt32 mod = sub / lim;
                            sub = sub - mod * lim;
                        }

                        // 自動延長
                        if (mAutoExtendBtn.Checked && sub >= 25 * 60)  // 25分
                        {
                            int r = ax.CheckExtend(this.Bounds, this.Location.X, this.Location.Y);
                            switch (r)
                            {
                                // 購入ボタンクリック
                                case 1:
                                    mPushExtend = true;
                                    break;
                                // OKボタンクリック
                                case 2:
                                    if (mPushExtend)
                                    {
                                        this.SendComment(mMsg.GetMessage("延長完了"), true);
                                        mPushExtend = false;
                                        extend_wait = true;
                                        mIsExtend = true;
                                    }
                                    break;
                            }
                            if (r != 0)
                                push_extend = true;
                        }
                    }

                    if (Properties.Settings.Default.use_fme)
                    {
                        if (!mStartFME && mNico.IsLogin)
                        {
                            int r = ax.AutoFME(this.Bounds, this.Location.X, this.Location.Y);
                            if (r == 1)
                            {
                                FMLE_Exec();
                                mStartFME = true;
                            }
                        }
                    }
                    else
                    {
                        if (!push_extend && !mPushExtend)
                        {
                            // 自動配信開始
                            if (Properties.Settings.Default.auto_connect)
                            {
                                int r = ax.AutoStart(this.Bounds, this.Location.X, this.Location.Y);
                                switch (r)
                                {
                                    // 配信開始
                                    case 1:
                                        mPushStart = true;
                                        break;
                                    // OK
                                    case 2:
                                        if (mPushStart)
                                            mBouyomi.Talk(mMsg.GetMessage("配信を開始しました"));
                                        mPushStart = false;
                                        this.mLastChatTime = DateTime.Now;
                                        break;
                                }

                            }
                        }
                    }

                    // ウェイト
                    Thread.Sleep(wait);
                }
            }
        }
    }
}
//-------------------------------------------------------------------------
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: WorkerAutoExtend.cs 698 2010-07-05 13:11:28Z kintoki $
//-------------------------------------------------------------------------
