//-------------------------------------------------------------------------
// 雑多な関数管理クラス
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: Utils.cs 746 2010-08-21 15:42:13Z kintoki $
//-------------------------------------------------------------------------
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Drawing;
using System;
using System.IO;

//-------------------------------------------------------------------------
// クラス実装
//-------------------------------------------------------------------------
namespace NicoLive
{
	public class Utils
	{
        // コメントカラム
        private enum CommentColumn : int
        {
            COLUMN_NUMBER = 0,			// 番号
            COLUMN_ID,					// ＩＤ
            COLUMN_HANDLE,				// コテハン
            COLUMN_COMMENT,				// コメント
        }

        //-------------------------------------------------------------------------
        // 文字コード変換
        //-------------------------------------------------------------------------
        public static string ConvertEncoding(string _src
                                      , System.Text.Encoding _srcEncoding
                                      , System.Text.Encoding _destEncoding)
        {
            byte[] srcBytes = _srcEncoding.GetBytes(_src);
            return _destEncoding.GetString(srcBytes);
        }
        public static string ToBase64(string iStr)
        {
            byte[] byteData = System.Text.Encoding.UTF8.GetBytes(iStr);
            return System.Convert.ToBase64String(byteData);
        }
        public static string FromBase64(string iStr)
        {
            byte[] byteData = System.Convert.FromBase64String(iStr);
            return System.Text.Encoding.UTF8.GetString(byteData);
        }
        //-------------------------------------------------------------------------
        // テキスト内のURLを開く
        //-------------------------------------------------------------------------
        public static void OpenURL(string iText)
        {
            string text = Regex.Replace(
                iText,
               @"(http|https):\/\/[\w\-_]+(\.[\w\-_]+)+([\w\-\.,@?^=%&amp;:/~\+#]*[\w\-\@?^=%&amp;/~\+#])",
               delegate(Match match)
               {
                   System.Diagnostics.Process.Start(match.ToString());
                   return match.ToString();
               });
        }

        //-------------------------------------------------------------------------
        // コメント追加
        //-------------------------------------------------------------------------
        public static void AddComment(ref DataGridView iView, Comment iCmt)
        {
            iView.Rows.Insert(0, iView.Rows);
            iView.Rows[0].Cells[(int)CommentColumn.COLUMN_NUMBER].Value  = iCmt.No;
            iView.Rows[0].Cells[(int)CommentColumn.COLUMN_ID].Value      = iCmt.Uid;
            iView.Rows[0].Cells[(int)CommentColumn.COLUMN_HANDLE].Value  = iCmt.Handle;
            iView.Rows[0].Cells[(int)CommentColumn.COLUMN_COMMENT].Value = iCmt.Text;

            if (iCmt.Premium.Equals("3"))
            {
                iView.Rows[0].Cells[(int)CommentColumn.COLUMN_COMMENT].Style.ForeColor = Properties.Settings.Default.owner_color;
            }
            else if (iCmt.IsNG)
            {
                iView.Rows[0].Cells[(int)CommentColumn.COLUMN_COMMENT].Style.ForeColor = Properties.Settings.Default.ng_color;
            }
            else if (iCmt.Mail.Contains("docomo"))
            {
                iView.Rows[0].Cells[(int)CommentColumn.COLUMN_COMMENT].Style.ForeColor = Properties.Settings.Default.mobile_color;
            }

            int max_item = Properties.Settings.Default.comment_max;
            if (iView.Rows.Count > max_item)
            {
                iView.Rows.RemoveAt(max_item);
            }
        }

		//-------------------------------------------------------------------------
		// リスト中のニックネームを変更
		//-------------------------------------------------------------------------
        public static void SetNickname(ref DataGridView iView, string iID, string iName)
		{
			// 既存アイテムのIDをコテハンに書き換え
            int cnt = iView.Rows.Count;
            for (int i = 0; i < cnt; i++)
            {
                DataGridViewRow item = iView.Rows[i];
                if (item != null)
                {
                    string id = item.Cells[(int)CommentColumn.COLUMN_ID].Value.ToString();
                    if (id.Equals(iID))
                    {
                        item.Cells[(int)CommentColumn.COLUMN_HANDLE].Value = iName;
                    }
                }
            }
		}

		//-------------------------------------------------------------------------
		// コメント用フォントの設定
		//-------------------------------------------------------------------------
        public static void SetCommentFont(ref DataGridView iView)
		{
            iView.Font = new Font("MS P Gothic",
                                  Properties.Settings.Default.font_size,
                                  FontStyle.Bold);
		
		}

        //-------------------------------------------------------------------------
        // 順番待ちが残り２桁になったらTweet
        //-------------------------------------------------------------------------
        public static void TweetWait(int iWaitCnt)
        {
            if (!Properties.Settings.Default.tweet_wait) return;

            if (iWaitCnt <= 1)
                return;

            MessageSettings msgSet = MessageSettings.Instance;

            string msg = String.Format(msgSet.GetMessage("枠取り順番待ち、残り{0}人"), iWaitCnt);

            using (Twitter tw = new Twitter())
            {
                tw.Post(msg, "#nicolive");
            }
        }

        //-------------------------------------------------------------------------
        // ログ書き出し
        //-------------------------------------------------------------------------
        public static void WriteLog(string iTitle, string iStr)
        {
            using (StreamWriter writer = new StreamWriter("error_log.txt", true))
            {
                writer.WriteLine("【" + iTitle + "】");
                writer.WriteLine(iStr);
                writer.Flush();
                writer.Close();
            }
        }
	}
}

//-------------------------------------------------------------------------
// 雑多な関数管理クラス
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
//-------------------------------------------------------------------------
