﻿//-------------------------------------------------------------------------
// Main Form
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: Timer.cs 706 2010-07-07 06:03:05Z kintoki $
//-------------------------------------------------------------------------
using System;

namespace NicoLive
{
    partial class Form1
    {
        //-------------------------------------------------------------------------
        // タイマー
        //-------------------------------------------------------------------------
        private void UITimer_Tick(object sender, EventArgs e)
        {
            Properties.Settings.Default.last_lv = this.mLiveID.Text;

            // フォントを設定しておく
            if (this.mCommentList.Font.Size != Properties.Settings.Default.font_size)
            {
                Utils.SetCommentFont(ref mCommentList);
            }

            // 色設定
            if (mCommentList.RowsDefaultCellStyle.BackColor != Properties.Settings.Default.back_color)
            {
                mCommentList.RowsDefaultCellStyle.BackColor = Properties.Settings.Default.back_color;
                mCommentList.BackgroundColor = Properties.Settings.Default.back_color;
            }

            if (mCommentList.RowsDefaultCellStyle.ForeColor != Properties.Settings.Default.text_color)
            {
                mCommentList.RowsDefaultCellStyle.ForeColor = Properties.Settings.Default.text_color;
            }

            // ログイン状態更新
            UpdateLogin();

            // ユニークユーザー数更新
            UpdateUniq();

            // アクティブ数更新
            UpdateActive();

            // 外部コメントウィンド
            this.Invoke((Action)delegate()
            {
                mCommentForm.ActiveCnt = mActiveCnt.Text;
                mCommentForm.TotalCnt = mTotalCnt.Text;
                mCommentForm.UniqCnt = mUniqCnt.Text;
                mCommentForm.UpLink = mUpLink.Text;
                mCommentForm.Battery = mBattery.Text;
                mCommentForm.CpuInfo = mCpuInfo.Text;
            });

            // コメントサーバーとの接続キープ用
            if (mNico != null && mNico.IsLogin && !mDisconnect && !mNico.WakutoriMode)
            {
                TimeSpan ts = DateTime.Now - this.mLastChatTime;
                if (ts.Minutes > KEEP_ALIVE_TIME)
                {
                    SendComment("/keepalive", true);
                    mLastChatTime = DateTime.Now;
                }
            }
        }

        //-------------------------------------------------------------------------
        // ハード情報更新タイマー
        //-------------------------------------------------------------------------
        private void HardInfoTimer_Tick(object sender, EventArgs e)
        {
            // ハードウェア情報更新
            UpdateHardInfo();

            // ネットワーク情報更新
            UpdateNetworkInfo();

            // ガベージ・コレクション
            mNextGC++;
            if (mNextGC > 60 * 3)
            {
                Console.WriteLine("GC PRE :" + GC.GetTotalMemory(false));
                GC.Collect();
                Console.WriteLine("GC POST:" + GC.GetTotalMemory(false));
                mNextGC = 0;
            }
        }
    }
}
//-------------------------------------------------------------------------
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: Timer.cs 706 2010-07-07 06:03:05Z kintoki $
//-------------------------------------------------------------------------
