﻿//-------------------------------------------------------------------------
// 外部コメントウィンド
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: CommentForm.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.ComponentModel;
using System.Windows.Forms;
using System.Drawing;

//-------------------------------------------------------------------------
// クラス実装
//-------------------------------------------------------------------------
namespace NicoLive
{
    public partial class CommentForm : Form
    {
        #region 変数
        private Form1 mOwner = null;
        private UIStatus mUIStatus;
        #endregion

        #region 列挙列
        // コメントカラム
        private enum CommentColumn
        {
            COLUMN_NUMBER = 0,			// 番号
            COLUMN_ID,					// ＩＤ
            COLUMN_HANDLE,				// コテハン
            COLUMN_COMMENT,				// コメント
        }
        #endregion

        //-------------------------------------------------------------------------
        // 来場者数
        //-------------------------------------------------------------------------
        public string TotalCnt
        {
            set { mTotalCnt.Text = value; }
        }
        //-------------------------------------------------------------------------
        // アクティブ数
        //-------------------------------------------------------------------------
        public string ActiveCnt
        {
            set { mActiveCnt.Text = value; }
        }

        //-------------------------------------------------------------------------
        // トータル数
        //-------------------------------------------------------------------------
        public string UniqCnt
        {
            set { mUniqCnt.Text = value; }
        }

        //-------------------------------------------------------------------------
        // CPU
        //-------------------------------------------------------------------------
        public string CpuInfo
        {
            set { 
                mCpuInfo.Text = value;
                float val;
                float.TryParse(value, out val);
                mCpuInfo.ForeColor = (val > 90) ? Color.Red : Color.Black;
            }
        }
        //-------------------------------------------------------------------------
        // Battery
        //-------------------------------------------------------------------------
        public string Battery
        {
            set {
                mBattery.Text = value;
                float val;
                float.TryParse(value, out val);
                mBattery.ForeColor = (val < 10) ? Color.Red : Color.Black;
            }
        }
        //-------------------------------------------------------------------------
        // UpLink
        //-------------------------------------------------------------------------
        public string UpLink
        {
            set { mUpLink.Text = value; }
        }
        //-------------------------------------------------------------------------
        // コンストラクタ
        //-------------------------------------------------------------------------
        public CommentForm(Form1 iOwner)
        {
            mOwner = iOwner;

            InitializeComponent();

            this.mCommentList.Columns[0].Width = Properties.Settings.Default.column_width_ext_0;
            this.mCommentList.Columns[1].Width = Properties.Settings.Default.column_width_ext_1;
            this.mCommentList.Columns[2].Width = Properties.Settings.Default.column_width_ext_2;
            this.mCommentList.Columns[3].Width = Properties.Settings.Default.column_width_ext_3;

            this.mCommentList.BackgroundColor = Properties.Settings.Default.back_color;
            this.mCommentList.RowsDefaultCellStyle.ForeColor = Properties.Settings.Default.text_color;

            // フォントを設定しておく
            ResetCommentFont();

            mUIStatus = UIStatus.Instance;
        }

        private void CommentForm_Load(object sender, EventArgs e)
        {
            // ウィンドステート復帰
            this.Top = Properties.Settings.Default.cw_pos.Y;
            this.Left = Properties.Settings.Default.cw_pos.X;
            this.Width = Properties.Settings.Default.cw_size.Width;
            this.Height = Properties.Settings.Default.cw_size.Height;

            this.WindowState = Properties.Settings.Default.cw_state;
            //Console.WriteLine("Load:{0} {1}",Properties.Settings.Default.cw_pos.Y, Properties.Settings.Default.cw_pos.X);
            mCommentList.SortCompare += new DataGridViewSortCompareEventHandler(this.SortComparer);

            mCommentList.Columns["NO"].Selected = true;
            mCommentList.Sort(mCommentList.Columns["NO"], Properties.Settings.Default.cw_sort_mode);
        }


        //-------------------------------------------------------------------------
        // コメント追加
        //-------------------------------------------------------------------------
        public void AddComment( Comment iCmt)
        {
            // フォントを設定しておく
            if (this.mCommentList.Font.Size != Properties.Settings.Default.font_size)
                ResetCommentFont();

            Utils.AddComment(ref mCommentList, iCmt);
        }
        //-------------------------------------------------------------------------
        // フォント設定
        //-------------------------------------------------------------------------
        private void ResetCommentFont()
        {
            Utils.SetCommentFont(ref mCommentList);
        }
        //-------------------------------------------------------------------------
        // コメントクリア
        //-------------------------------------------------------------------------
        public void Clear()
        {
            this.mCommentList.Rows.Clear();
        }
        //-------------------------------------------------------------------------
        // コメントクリア
        //-------------------------------------------------------------------------
        private void OnClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                SaveProp();
                Hide();
            }
        }
        //-------------------------------------------------------------------------
        // ニックネーム変更
        //-------------------------------------------------------------------------
        public void SetNickname(string iID, string iName)
        {
            Utils.SetNickname(ref mCommentList, iID, iName);
        }

        #region イベントハンドラ
        //-------------------------------------------------------------------------
        // コメントのコピー
        //-------------------------------------------------------------------------
        private void CopyComment_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                string cmt = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_COMMENT].Value.ToString();
                Clipboard.SetDataObject(cmt, true);
            }
        }
        //-------------------------------------------------------------------------
        // コメントリストのコンテクストメニュー表示開始時
        //-------------------------------------------------------------------------
        private void mCmtCxtMenu_Opening(object sender, CancelEventArgs e)
        {
            this.mCopyComment.Enabled = (this.mCommentList.SelectedRows.Count > 0);
            this.mCopyID.Enabled = (this.mCommentList.SelectedRows.Count > 0);
            this.mRename.Enabled = (this.mCommentList.SelectedRows.Count > 0);
            this.mOpenURL.Enabled = (this.mCommentList.SelectedRows.Count > 0);
            this.AddNG.Enabled = (this.mCommentList.SelectedRows.Count > 0);

            int r;
            if (this.mCommentList.SelectedRows.Count > 0 &&
                int.TryParse(mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_ID].Value.ToString(), out r))
            {
                this.mShowUserPage.Enabled = true;
            }
            else
            {
                this.mShowUserPage.Enabled = false;
            }
        }
        //-------------------------------------------------------------------------
        // IDのコピー
        //-------------------------------------------------------------------------
        private void CopyID_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                string id = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_ID].Value.ToString();
                Clipboard.SetDataObject(id, true);
            }
        }

        //-------------------------------------------------------------------------
        // URLを開く
        //-------------------------------------------------------------------------
        private void OpenURL_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                string msg = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_COMMENT].Value.ToString();

                if (msg.Length == 0) return;

                Utils.OpenURL(msg);
            }
        }

        //-------------------------------------------------------------------------
        // ユーザーページを開く
        //-------------------------------------------------------------------------
        private void ShowUserPage_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                string id = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_ID].Value.ToString();
                string uri = "http://www.nicovideo.jp/user/" + id;
                System.Diagnostics.Process.Start(uri);
            }
        }

        //-------------------------------------------------------------------------
        // コテハンリネーム
        //-------------------------------------------------------------------------
        private void Rename_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                Rename rm = new Rename();
                rm.MyOwner = mOwner;
                rm.ID = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_ID].Value.ToString();
                rm.Show();
            }
        }


        private void AddNG_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                Nico nico = Nico.Instance;
                LiveInfo info = LiveInfo.Instance;
                string uid = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_ID].Value.ToString();
                if (uid.Length <= 0) return;

                if (MessageBox.Show("「"+uid + "」をＮＧに追加しますか？", "豆ライブ", MessageBoxButtons.OKCancel) == System.Windows.Forms.DialogResult.OK)
                {
                    if (nico.IsLogin)
                    {
                        nico.AddNG(info.ID, uid);
                    }
                }
            }
        }
        #endregion

        //-------------------------------------------------------------------------
        // ニックネーム変更
        //-------------------------------------------------------------------------
        private void UITimer_Tick(object sender, EventArgs e)
        {
            // 色設定
            if (mCommentList.RowsDefaultCellStyle.BackColor != Properties.Settings.Default.back_color)
            {
                mCommentList.RowsDefaultCellStyle.BackColor = Properties.Settings.Default.back_color;
                mCommentList.BackgroundColor = Properties.Settings.Default.back_color;
            }

            if (mCommentList.RowsDefaultCellStyle.ForeColor != Properties.Settings.Default.text_color)
            {
                mCommentList.RowsDefaultCellStyle.ForeColor = Properties.Settings.Default.text_color;
            }

            LiveInfo info = LiveInfo.Instance;
            if (info.Time > 0)
            {
                int sub = Utils.CalcTime();
                
                
                int min = sub / 60;
                int sec = sub - min * 60;
				bool minus = false;
                if (sec < 0){
					minus = true;
					sec *= -1;
				}
                string time_label = String.Format("{0:d2}:{1:d2}", min, sec);
				if( minus && min >= 0 )
					time_label = "-"+time_label;

                this.Text = "コメント 【" + time_label + "】";
            }else
                this.Text = "コメント ";

            mUIStatus.UpdateActive(ref mActiveCnt);
            mUIStatus.UpdateVisitor(ref mTotalCnt);
            mUIStatus.UpdateUniq(ref mUniqCnt);

            UIStatus.HardInfo hinfo = mUIStatus.SetHardInfo(ref mPerfCnt, ref mCpuInfo, ref mBattery);
            
            if (hinfo == UIStatus.HardInfo.HARD_INFO_BAT_LOW)
            {
                Nico nico = Nico.Instance;
                MessageSettings msg = MessageSettings.Instance;
                
                string str = String.Format(msg.GetMessage("バッテリー残量が{0}%以下になりました"), Properties.Settings.Default.rest_batt);
                if (nico.IsLogin)
                {
                    nico.SendOwnerComment(info.ID, str, info.Nickname, info.Token);
                }
            }
            mUIStatus.SetNetworkInfo(ref mUpLink);
        }

       
        public void SaveProp()
        {
            Properties.Settings.Default.column_width_ext_0 = this.mCommentList.Columns[0].Width;
            Properties.Settings.Default.column_width_ext_1 = this.mCommentList.Columns[1].Width;
            Properties.Settings.Default.column_width_ext_2 = this.mCommentList.Columns[2].Width;
            Properties.Settings.Default.column_width_ext_3 = this.mCommentList.Columns[3].Width;

            // ウィンドステート保存
            if (this.WindowState == FormWindowState.Normal)
            {
                Size size = new Size(this.Width, this.Height);
                Properties.Settings.Default.cw_size = size;
                Point pos = new Point(this.Left, this.Top);
                Properties.Settings.Default.cw_pos = pos;
                //Console.WriteLine("Save:{0} {1}", Properties.Settings.Default.cw_pos.Y, Properties.Settings.Default.cw_pos.X);
            }
            Properties.Settings.Default.cw_state = this.WindowState;
            Properties.Settings.Default.Save();
        }

        public void AddNickname(string iID, string iName)
        {
            // 既存アイテムのIDをコテハンに書き換え
            int cnt = this.mCommentList.Rows.Count;
            for (int i = 0; i < cnt; i++)
            {
                DataGridViewRow item = this.mCommentList.Rows[i];
                if (item != null)
                {
                    string id = item.Cells[(int)CommentColumn.COLUMN_ID].Value.ToString();
                    if (id.Equals(iID))
                    {
                        item.Cells[(int)CommentColumn.COLUMN_HANDLE].Value = iName;
                    }
                }
            }
        }
        public void SetLoginLabel(string iText, Color iCol)
        {
            this.mLoginLabel.Text = iText;
            this.mLoginLabel.ForeColor = iCol;
        }

        private void SortComparer(object sender,
                                        DataGridViewSortCompareEventArgs e)
        {
            switch( e.Column.Name){
                case "NO":
                    string str1 = (e.CellValue1 == null ? "" : e.CellValue1.ToString());
                    string str2 = (e.CellValue2 == null ? "" : e.CellValue2.ToString());

                    int val1, val2;
                    int.TryParse(str1, out val1);
                    int.TryParse(str2, out val2);

                    e.SortResult = val1 - val2;
                    e.Handled = true;
                    if( mCommentList.SortOrder == SortOrder.Ascending )
                        Properties.Settings.Default.cw_sort_mode = ListSortDirection.Ascending;
                    else
                        Properties.Settings.Default.cw_sort_mode = ListSortDirection.Descending;
                    break;
                case "COMMENT":
                case "HANDLE":
                    str1 = (e.CellValue1 == null ? "" : e.CellValue1.ToString());
                    str2 = (e.CellValue2 == null ? "" : e.CellValue2.ToString());

                    e.SortResult = str1.Length - str2.Length;
                    e.Handled = true;
                    break;
                default:
                    e.Handled = false;
                    break;
            }
        }

    }
}
//-------------------------------------------------------------------------
// 外部コメントウィンド
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: CommentForm.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------
