﻿//-------------------------------------------------------------------------
// Main Form
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: UpdateStatus.cs 770 2010-09-11 14:19:23Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
using System.Collections.Generic;

namespace NicoLive
{
    partial class Form1
    {
        //-------------------------------------------------------------------------
        // 状態チェック
        //-------------------------------------------------------------------------
        private void UpdateStatus()
        {
            //------------------ 接続要求 -----------------------
            if ( CheckStatus(STATUS_FLAGS.NEED_CONNECT) )
            {
                if (mLiveInfo.Token.Length > 0)
                {
                        if (mNico.LiveStart(LiveID, mLiveInfo.Token))
                        {
                            DelStatus(STATUS_FLAGS.NEED_CONNECT);
                            FlashSetUrl(mLiveInfo.Url + "?" + mLiveInfo.Ticket);
                            FlashSetPublish(mLiveInfo.ID);
                            FlashCall("enable");

                            if (Properties.Settings.Default.auto_connect)
                            {
                                this.Invoke((Action)delegate()
                                {
                                    if (mBroType.SelectedIndex == 1)
                                    {
                                        EnableFME(true);
                                        FMLE_Exec();
                                        FlashAppendLog("FME配信を開始しました");
                                    }
                                    else
                                    {
                                        AddStatus(STATUS_FLAGS.PUBLISH_START);
                                    }
                                });
                            }
                        }
                    
                }
            }
            // ------------------ 配信開始------------------------
            int sub = (int)(mLiveInfo.EndTime - mLiveInfo.Time);
            if (CheckStatus(STATUS_FLAGS.OWN_LIVE) && !CheckStatus(STATUS_FLAGS.DISCONNECT))
            {
                if (sub <= 0)
                {
                    mNico.SendOwnerComment(LiveID, "/disconnect", "", mLiveInfo.Token);
                    mNico.LiveStop(LiveID, mLiveInfo.Token);
                    FlashCall("stop");
                }
            }

            // ------------------ 配信開始------------------------
            sub = (int)(mLiveInfo.Time - mLiveInfo.BaseTime);
            if (CheckStatus(STATUS_FLAGS.PUBLISH_START) && sub > 5)
            {
                FlashCall("start");
                DelStatus(STATUS_FLAGS.PUBLISH_START);
            }

            // ------------------- 残り時間読み上げ -------------------
            if (CheckStatus(STATUS_FLAGS.TALK_LIMIT))
            {
                if (!CheckStatus(STATUS_FLAGS.TALK_LIMIT_END))
                {
                    string msg = String.Format(mMsg.GetMessage("のこり{0}ふんくらいです"),
                                                Properties.Settings.Default.rest_time);
                    this.mBouyomi.Talk(msg);
                    AddStatus(STATUS_FLAGS.TALK_LIMIT_END);
                }
                DelStatus(STATUS_FLAGS.TALK_LIMIT);
            }

            //------------------ Twitter開始メッセージポスト ---------------
            if (CheckStatus(STATUS_FLAGS.OWN_LIVE) &&
                CheckStatus(STATUS_FLAGS.TW_START_POST)  &&
                Properties.Settings.Default.tw_start_enable
            ){
                TwitterPoster(true);
                DelStatus(STATUS_FLAGS.TW_START_POST);
            }

            //--------------------- アイテム購入 -----------------------
            if (CheckStatus(STATUS_FLAGS.BUY_ITEM))
            {
                if (mNico.Purchase(mLiveInfo.ID, mLiveInfo.Token, mSaleList[mBuyItemIdx]))
                {
                    string str = mBuyItemName + "を購入しました";
                    mBouyomi.Talk(str);
                    FlashAppendLog(str);
                    DelStatus(STATUS_FLAGS.BUY_ITEM);
                }
            }

            //--------------------- 無料延長処理 -----------------------
            if (mLiveInfo.ID != null && !CheckStatus(STATUS_FLAGS.IS_EXTEND))
            {
                if (CheckStatus(STATUS_FLAGS.OWN_LIVE) &&
                    CheckStatus(STATUS_FLAGS.NEED_FREE_EXTEND_1 ) )
                {
                
                    List<SaleList> list = new List<SaleList>();
                    mNico.GetSaleList(mLiveInfo.ID, ref list);

                    // 無料延長探し
                    foreach( SaleList sale in list )
                    {
                        if( sale.mItem != null && sale.mItem.Equals("freeextend") )
                        {
                            mFreeExtendItem = sale;

                            AddStatus( STATUS_FLAGS.NEED_FREE_EXTEND_2);
                            DelStatus( STATUS_FLAGS.NEED_FREE_EXTEND_1);
                        }
                    }
                }

                if (CheckStatus(STATUS_FLAGS.OWN_LIVE) &&
                    CheckStatus(STATUS_FLAGS.NEED_FREE_EXTEND_2 ) )
                {
                    if(mFreeExtendItem.mItem != null && mFreeExtendItem.mItem.Equals("freeextend"))
                    {
                        if( mNico.Purchase( mLiveInfo.ID,mLiveInfo.Token,mFreeExtendItem) )
                        {
                            DelStatus( STATUS_FLAGS.NEED_FREE_EXTEND_2);
                            
                            this.SendComment(mMsg.GetMessage("延長完了"), true);
                            DelStatus(STATUS_FLAGS.PUSH_EXT_AUTO);
                            AddStatus(STATUS_FLAGS.IS_EXTEND);
                            FlashAppendLog("延長完了");
                        }
                    }
                }
            }

            if (!mPlayerLoaded)
            {
                this.Invoke((Action)delegate()
                {
                    GetPlayer();
                });
            }
            
            /*
            LiveInfo info = LiveInfo.Instance;
            string url = info.Url + "?" + info.Ticket;
            string lv = info.ID;
            Debug.WriteLine(url);
            Debug.WriteLine(lv);
            */
        }

        //-------------------------------------------------------------------------
        // SaleList更新
        //-------------------------------------------------------------------------
        private void UpdateSaleList()
        {
            if (CheckStatus(STATUS_FLAGS.EXTEND_ITEM_LOCK)) return;

            if (mNico != null &&
                mNico.IsLogin &&
                !mNico.WakutoriMode &&
                CheckStatus(STATUS_FLAGS.OWN_LIVE))
            {
                if (mNico.GetSaleList(LiveID, ref mSaleList))
                {
                    try
                    {
                        this.Invoke((Action)delegate()
                        {
                            if (mSaleListMenu.Items.Count != mSaleList.Count)
                            {
                                mSaleListMenu.Items.Clear();
                                foreach (SaleList sale in mSaleList)
                                {
                                    mSaleListMenu.Items.Add(sale.mLabel);
                                }
                            }
                            mSaleListMenu.SelectedIndex = 0;
                            mBuyBtn.Enabled = true;
                        });
                    }
                    catch (Exception e)
                    {
                        Debug.WriteLine(e.Message);
                    }
                }
            }
            else
            {
                if (mSaleListMenu.Items.Count > 0)
                {
                    try
                    {
                        this.Invoke((Action)delegate()
                        {
                            mSaleListMenu.Items.Clear();
                            mBuyBtn.Enabled = false;
                        });
                    }
                    catch (Exception e)
                    {
                        Debug.WriteLine(e.Message);
                    }
                }
            }
        }

        //-------------------------------------------------------------------------
        // 放送情報更新
        //-------------------------------------------------------------------------
        private void UpdateMovieInfo()
        {
            if (mNico != null && mNico.IsLogin && !mNico.WakutoriMode )
            {
                string id="";
                try
                {
                    this.Invoke((Action)delegate()
                    {
                        id = LiveID;
                    });
                }
                catch (Exception )
                {

                }

                if (id.Length <= 2) return;

                InfoErr ret = mLiveInfo.GetInfo(id);
                if (ret == InfoErr.ERR_NO_ERR)
                {
#if DEBUG
                    try
                    {
                        this.Invoke((Action)delegate()
                        {
                            this.Text = "豆ライブ" + "　[GC:" + GC.GetTotalMemory(false) + "]";
                        });
                    }
                    catch (Exception )
                    {

                    }
#else
                    // タイトル設定
                    try
                    {
                        this.Invoke((Action)delegate()
                        {
                            if (mLiveInfo.Title.Length > 0)
                                this.Text = "豆ライブ" + "　【" + mLiveInfo.Title + "】";
                            else
                                this.Text = "豆ライブ";
                        });
                    }
                    catch (Exception)
                    {

                    }
#endif
                    UInt32 time = mLiveInfo.Time;
                    UInt32 btime = mLiveInfo.StartTime;

                    int sub = Utils.CalcTime();

                    int min = sub / 60;
                    int sec = sub - min * 60;
					bool minus = false;
                    if (sec < 0){
					   	sec *= -1;
						minus = true;
					}
                    string time_label = String.Format("{0:d2}:{1:d2}", min, sec);
					if( minus && min >= 0 )
						time_label = "-"+time_label;

                    FlashSetTime(time_label);

                    if (btime < time)
                    {   
                        FlashSetEndTime((int)mLiveInfo.EndTime);

                        if (mAutoExtendBtn.Checked && min　<= 4 &&
                            !CheckStatus(STATUS_FLAGS.NEED_FREE_EXTEND_0))  // 25分
                        {
                            AddStatus(STATUS_FLAGS.NEED_FREE_EXTEND_0);
                            AddStatus(STATUS_FLAGS.NEED_FREE_EXTEND_1);
                            FlashAppendLog("延長作業開始");
                        }

                        // 経過時間取得
                        if (Properties.Settings.Default.talk_3min)
                        {
                            // 残り3分通知
                            if (!CheckStatus(STATUS_FLAGS.IS_EXTEND))
                            {
                                if (sub < Properties.Settings.Default.rest_time * 60)
                                {
                                    AddStatus(STATUS_FLAGS.TALK_LIMIT);
                                }
                            }     
                        }

                        if (sub > 29 * 60)
                        {
                            DelStatus(STATUS_FLAGS.TALK_LIMIT_END);
                            DelStatus(STATUS_FLAGS.IS_EXTEND);
                            DelStatus(STATUS_FLAGS.NEED_FREE_EXTEND_0);
                        }
                    }

                    // 自分の配信かどうか
                    string token = mLiveInfo.Token;
                    if (token.Length != 0)
                    {
                        AddStatus(STATUS_FLAGS.OWN_LIVE);
                    }
                }/*
                else if (ret == InfoErr.ERR_NOT_LOGIN)
                {
                    if (!mDisconnect && mNico != null && mNico.IsLogin)
                    {
                        //Connect(false);
                    }
                }*/
            }

        }

        //-------------------------------------------------------------------------
        // ログイン状態更新
        //-------------------------------------------------------------------------
        private void UpdateLogin()
        {
            // ステータスを接続中に
            if (!this.mConnectBtn.Enabled)
            {
                this.mCommentForm.SetLoginLabel("接続中", Color.Black);
                return;
            }

            if (mNico != null)
            {
                this.mCommentForm.SetLoginLabel((mNico.IsLogin) ? "ログイン済" : "未ログイン", (mNico.IsLogin) ? Color.Red : Color.Black);
                // ログアウト通知
                bool show_err = false;

                if (CheckStatus(STATUS_FLAGS.PREV_LOGIN) && !mNico.IsLogin)
                    show_err = true;

                if (mNico.IsLogin)
                    AddStatus(STATUS_FLAGS.PREV_LOGIN);
                else
                    DelStatus(STATUS_FLAGS.PREV_LOGIN);

                if (show_err)
                {
                    string msg = "ログアウトしました";

                    if (this.mBouyomiBtn.Checked)
                    {
                        this.mBouyomi.Talk(msg);
                    }

                    if (mNico.IsLogin)
                        AddStatus(STATUS_FLAGS.PREV_LOGIN);
                    else
                        DelStatus(STATUS_FLAGS.PREV_LOGIN);
                  
                    MessageBox.Show(msg, "豆ライブ");
                }
            }
            else
            {
                this.mCommentForm.SetLoginLabel("未ログイン", Color.Black);
                DelStatus(STATUS_FLAGS.PREV_LOGIN);
            }
        }
    }
}
//-------------------------------------------------------------------------
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: UpdateStatus.cs 770 2010-09-11 14:19:23Z kintoki $
//-------------------------------------------------------------------------
