package jp.sourceforge.nicoro;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;

import jp.gr.java_conf.shiseissi.commonlib.ThreadUtil;

public class NicoScriptView extends View {
    private static final int STATE_JUMP_MESSAGE = 1;

    private int mState;

    private String mJumpMessage;

    private Paint mPaint;
    private Matrix mMatrix;

    public NicoScriptView(Context context) {
        super(context);
    }
    public NicoScriptView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }
    public NicoScriptView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        switch (mState) {
            case STATE_JUMP_MESSAGE:
                canvas.drawColor(Color.WHITE);
                MessageChatController.setPlayerMatrixToCanvas(canvas,
                        getWidth(), getHeight(), mMatrix);

                mPaint.setColor(MessageChat.COLOR_BLACK);
                mPaint.setTextSize(MessageChat.FONTSIZE_PX_MEDIUM);
                mPaint.setAntiAlias(true);
                float messageWidth = mPaint.measureText(mJumpMessage);

                // TODO 複数行にまたがるテキストの場合
                float x = ((float) PlayerConstants.REAL_PLAYER_WIDTH_PX_4_3
                        - messageWidth) / 2.0f;
                float y = (PlayerConstants.REAL_PLAYER_HEIGHT_PX_4_3
                        - MessageChat.LINEHEIGHT_PX_MEDIUM) / 2.0f;
                y -= mPaint.ascent();
                canvas.drawText(mJumpMessage, x, y, mPaint);
                break;
        }
    }

    public void startJumpMessage(String jumpMessage) {
        mState = STATE_JUMP_MESSAGE;
        mJumpMessage = jumpMessage;
        if (mPaint == null) {
            mPaint = new Paint();
        }
        if (mMatrix == null) {
            mMatrix = new Matrix();
        }
        if (ThreadUtil.isInMainThread(getContext())) {
            setVisibility(View.VISIBLE);
            invalidate();
        } else {
            Handler handler = getHandler();
            if (handler != null) {
                handler.post(new Runnable() {
                    @Override
                    public void run() {
                        setVisibility(View.VISIBLE);
                        invalidate();
                        Handler handler = getHandler();
                        if (handler != null) {
                            handler.postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    setVisibility(View.GONE);
                                }
                            }, MessageChatController.JUMP_MESSAGE_TIME_MS);
                        }
                    }
                });
            }
        }
    }
}
