package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptForbidCommentTest extends TestCase {
    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠コメント禁止", chat);
        assertEquals(NicoScriptForbidComment.class, ns.getClass());

        NicoScriptForbidComment script = (NicoScriptForbidComment) ns;
        assertEquals(NicoScript.UNDEFINED_DEFAULT_TIME, chat.getTime());
        FakeMessageChatController fake = new FakeMessageChatController();
        assertFalse(fake.calledForbidComment);
        assertFalse(fake.calledAllowComment);

        script.onDraw(fake);
        assertTrue(fake.calledForbidComment);
        assertFalse(fake.calledAllowComment);

        script.onPrepareRemove(fake);
        assertTrue(fake.calledAllowComment);
    }

    public void testSetTime() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠コメント禁止", chat);
        assertEquals(NicoScriptForbidComment.class, ns.getClass());

        assertEquals(90, chat.getTime());
    }

}
