package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.Log.LOG_TAG;

public class GRADIENT {
	public byte spreadMode;		// UB[2]
	public byte interpolationMode;	// UB[2]
	public byte numGradients;		// UB[4]
	public GRADRECORD[] gradientRecords;	// 最大15個

    public int read(byte[] bufferArray, int offset, int tagType) {
    	GRADIENT gradient = this;

		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("readGRADIENT: offset=")
					.append(offset).toString());
		}

		byte b = bufferArray[offset];
		gradient.spreadMode = (byte) ((b >> 6) & 0x03);
		gradient.interpolationMode = (byte) ((b >> 4) & 0x03);
		gradient.numGradients = (byte) (b & 0x0f);
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, Log.buf()
    				.append("SpreadMode=").append(gradient.spreadMode)
    				.append(" InterpolationMode=").append(gradient.interpolationMode)
    				.append(" NumGradients=").append(gradient.numGradients).toString());
    	}
    	int offsetNext = offset + 1;
    	gradient.gradientRecords = new GRADRECORD[gradient.numGradients];
    	for (int i = 0; i < gradient.numGradients; ++i) {
    		GRADRECORD gradRecord = new GRADRECORD();
    		offsetNext = gradRecord.read(bufferArray, offsetNext, tagType);
    		gradient.gradientRecords[i] = gradRecord;
    	}

		return offsetNext;
    }

}
