package jp.sourceforge.nicoro;

import android.test.AndroidTestCase;

public class MessageChatControllerTest extends AndroidTestCase {
    public void testIsNgShareLevel() {
        MessageChatController controller = new MessageChatController();

        MessageChat chat10000 = new MessageChat(null, 0, 0, 0L, "", -10000);
        MessageChat chat9999 = new MessageChat(null, 0, 0, 0L, "", -9999);
        MessageChat chat4800 = new MessageChat(null, 0, 0, 0L, "", -4800);
        MessageChat chat4799 = new MessageChat(null, 0, 0, 0L, "", -4799);
        MessageChat chat1000 = new MessageChat(null, 0, 0, 0L, "", -1000);
        MessageChat chat999 = new MessageChat(null, 0, 0, 0L, "", -999);
        MessageChat chat0 = new MessageChat(null, 0, 0, 0L, "", 0);

        assertFalse(controller.isNg(chat10000));
        assertFalse(controller.isNg(chat9999));
        assertFalse(controller.isNg(chat4800));
        assertFalse(controller.isNg(chat4799));
        assertFalse(controller.isNg(chat1000));
        assertFalse(controller.isNg(chat999));
        assertFalse(controller.isNg(chat0));

        controller.setNgShareLevel(MessageChatController.NG_SHARE_LEVEL_NONE);
        assertFalse(controller.isNg(chat10000));
        assertFalse(controller.isNg(chat9999));
        assertFalse(controller.isNg(chat4800));
        assertFalse(controller.isNg(chat4799));
        assertFalse(controller.isNg(chat1000));
        assertFalse(controller.isNg(chat999));
        assertFalse(controller.isNg(chat0));

        controller.setNgShareLevel(MessageChatController.NG_SHARE_LEVEL_LIGHT);
        assertTrue(controller.isNg(chat10000));
        assertFalse(controller.isNg(chat9999));
        assertFalse(controller.isNg(chat4800));
        assertFalse(controller.isNg(chat4799));
        assertFalse(controller.isNg(chat1000));
        assertFalse(controller.isNg(chat999));
        assertFalse(controller.isNg(chat0));

        controller.setNgShareLevel(MessageChatController.NG_SHARE_LEVEL_MIDDLE);
        assertTrue(controller.isNg(chat10000));
        assertTrue(controller.isNg(chat9999));
        assertTrue(controller.isNg(chat4800));
        assertFalse(controller.isNg(chat4799));
        assertFalse(controller.isNg(chat1000));
        assertFalse(controller.isNg(chat999));
        assertFalse(controller.isNg(chat0));

        controller.setNgShareLevel(MessageChatController.NG_SHARE_LEVEL_HIGH);
        assertTrue(controller.isNg(chat10000));
        assertTrue(controller.isNg(chat9999));
        assertTrue(controller.isNg(chat4800));
        assertTrue(controller.isNg(chat4799));
        assertTrue(controller.isNg(chat1000));
        assertFalse(controller.isNg(chat999));
        assertFalse(controller.isNg(chat0));
    }
}
