package jp.sourceforge.nicoro;

import java.util.concurrent.CountDownLatch;

import junit.framework.AssertionFailedError;

public abstract class TestThread extends Thread {
    private CountDownLatch mLatch;
    private Throwable mThrowable;

    public TestThread() {
    }
    public TestThread(CountDownLatch latch) {
        mLatch = latch;
    }

    @Override
    final public void run() {
        try {
            runImpl();
        } catch (Throwable e) {
            mThrowable = e;
        }
        if (mLatch != null) {
            mLatch.countDown();
        }
    }

    abstract protected void runImpl() throws Exception;

    public Throwable getThrowable() {
        return mThrowable;
    }

    public void throwIfFailed() throws AssertionFailedError {
        if (mThrowable != null) {
            AssertionFailedError e = new AssertionFailedError();
            e.initCause(mThrowable);
            throw e;
        }
    }
}
