package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptScoreTest extends TestCase {

    // TODO 後で追加実装すべきテストあると思われ


    public void testCallback() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠スコア キーワード", chat);
        assertEquals(NicoScriptScore.class, ns.getClass());

        NicoScriptScore script = (NicoScriptScore) ns;
        assertEquals(NicoScript.UNDEFINED_DEFAULT_TIME, chat.getTime());
        assertNull(script.getLabel());

        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptScore);
        assertFalse(fake.calledAddCommandScore);
        assertFalse(fake.calledRemoveCommandScore);

        script.onDraw(fake);
        assertEquals(script, fake.scriptScore);
        assertTrue(fake.calledAddCommandScore);
        assertFalse(fake.calledRemoveCommandScore);

        script.onPrepareRemove(fake);
        assertEquals(script, fake.scriptScore);
        assertTrue(fake.calledRemoveCommandScore);

    }


    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠スコア キー", chat);
        assertEquals(NicoScriptScore.class, ns.getClass());

        NicoScriptScore script = (NicoScriptScore) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertNull(script.getLabel());

        assertFalse(script.match("キ"));
        assertTrue(script.match("キー"));
        assertTrue(script.match("キーです"));

        assertEquals(10, script.getScore());
    }

    public void testIsSaveLocal() {
        MessageChatFork chat = new MessageChatFork("@90 local", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠スコア：得点 キー", chat);
        assertEquals(NicoScriptScore.class, ns.getClass());

        NicoScriptScore script = (NicoScriptScore) ns;
        assertTrue(script.isSaveLocal());
    }

    public void testOption1() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠スコア：得点 あいうえお 11 部分一致", chat);
        assertEquals(NicoScriptScore.class, ns.getClass());

        NicoScriptScore script = (NicoScriptScore) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertEquals("得点", script.getLabel());

        assertFalse(script.match("あいうえ"));
        assertTrue(script.match("あいうえお"));
        assertTrue(script.match("あいうえおかきくけこ"));

        assertEquals(11, script.getScore());
    }

    public void testOption2() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠スコア：得点 あいうえお 11 完全一致", chat);
        assertEquals(NicoScriptScore.class, ns.getClass());

        NicoScriptScore script = (NicoScriptScore) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertEquals("得点", script.getLabel());

        assertFalse(script.match("あいうえ"));
        assertTrue(script.match("あいうえお"));
        assertFalse(script.match("あいうえおかきくけこ"));

        assertEquals(11, script.getScore());
    }

}
