package jp.sourceforge.nicoro;

import android.os.Bundle;

/**
 * {@link android.app.Activity}や{@link android.support.v4.app.Fragment}の
 * 状態管理サポートを行う<br>
 * 各メソッドを手動で呼ばないと機能しないので注意
 */
public class StateManager {
    private boolean mWasRestored = false;
    private boolean mIsStarting = false;
    private boolean mIsResuming = false;
    private boolean mWasSavedInstanceState = false;
    private boolean mWasDestroyed = false;
    private boolean mWasRestarted = false;
    private boolean mWasCreated = false;

    public void onCreate(Bundle savedInstanceState) {
        mWasRestored = (savedInstanceState != null);
        mIsStarting = false;
        mIsResuming = false;
        mWasSavedInstanceState = false;
        mWasDestroyed = false;
        mWasRestarted = false;
        mWasCreated = true;
    }

    public void onStart() {
        mIsStarting = true;
        mWasSavedInstanceState = false;
    }

    public void onRestart() {
        mWasRestarted = true;
        mWasSavedInstanceState = false;
    }

    public void onResume() {
        mIsResuming = true;
        mWasSavedInstanceState = false;
    }

    public void onPause() {
        mIsResuming = false;
    }

    public void onStop() {
        mIsStarting = false;
        mWasSavedInstanceState = true;
    }

    public void onSaveInstanceState() {
        mWasSavedInstanceState = true;
    }

    public void onDestroy() {
        mWasDestroyed = true;
    }

    public boolean wasRestored() {
        return mWasRestored;
    }
    public boolean isStarting() {
        return mIsStarting;
    }
    public boolean isResuming() {
        return mIsResuming;
    }
    public boolean wasSavedInstanceState() {
        return mWasSavedInstanceState;
    }
    public boolean wasDestroyed() {
        return mWasDestroyed;
    }
    public boolean wasRestarted() {
        return mWasRestarted;
    }
    public boolean wasCreated() {
        return mWasCreated;
    }
}
