package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptBallTest extends TestCase {

    // TODO 後で追加実装すべきテストあり

    public void testCallback() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠玉", chat);
        assertEquals(NicoScriptBall.class, ns.getClass());

        NicoScriptBall script = (NicoScriptBall) ns;
        assertEquals(NicoScript.UNDEFINED_DEFAULT_TIME, chat.getTime());
        assertNull(script.getLabel());

        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptBall);
        assertFalse(fake.calledAddCommandBall);
        assertFalse(fake.calledRemoveCommandBall);

        script.onDraw(fake);
        assertEquals(script, fake.scriptBall);
        assertTrue(fake.calledAddCommandBall);
        assertFalse(fake.calledRemoveCommandBall);

        script.onPrepareRemove(fake);
        assertEquals(script, fake.scriptBall);
        assertTrue(fake.calledRemoveCommandBall);

    }

    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠玉", chat);
        assertEquals(NicoScriptBall.class, ns.getClass());

        NicoScriptBall script = (NicoScriptBall) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertNull(script.getLabel());

        assertTrue(script.match("上"));
        assertTrue(script.match("下"));
        assertTrue(script.match("左"));
        assertTrue(script.match("右"));
        assertTrue(script.match("次は上"));
        assertTrue(script.match("次は下"));
        assertTrue(script.match("次は左"));
        assertTrue(script.match("次は右"));
    }

    public void testIsSaveLocal() {
        MessageChatFork chat = new MessageChatFork("@90 local", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠玉", chat);
        assertEquals(NicoScriptBall.class, ns.getClass());

        NicoScriptBall script = (NicoScriptBall) ns;
        assertTrue(script.isSaveLocal());
    }

    public void testOption1() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠玉：野球 up、down、left、right 50%,50%,50%,50% 部分一致", chat);
        assertEquals(NicoScriptBall.class, ns.getClass());

        NicoScriptBall script = (NicoScriptBall) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertEquals("野球", script.getLabel());

        assertTrue(script.match("up"));
        assertTrue(script.match("down"));
        assertTrue(script.match("left"));
        assertTrue(script.match("right"));
        assertTrue(script.match("次はup"));
        assertTrue(script.match("次はdown"));
        assertTrue(script.match("次はleft"));
        assertTrue(script.match("次はright"));
    }

    public void testOption2() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠玉：野球 up、down、left、right 50%,50%,50%,50% 完全一致", chat);
        assertEquals(NicoScriptBall.class, ns.getClass());

        NicoScriptBall script = (NicoScriptBall) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertEquals("野球", script.getLabel());

        assertTrue(script.match("up"));
        assertTrue(script.match("down"));
        assertTrue(script.match("left"));
        assertTrue(script.match("right"));
        assertFalse(script.match("次はup"));
        assertFalse(script.match("次はdown"));
        assertFalse(script.match("次はleft"));
        assertFalse(script.match("次はright"));
    }
}
