package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptWindowTest extends TestCase {

    // TODO 後で追加実装すべきテストあり

    public void testCallback() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠窓", chat);
        assertEquals(NicoScriptWindow.class, ns.getClass());

        NicoScriptWindow script = (NicoScriptWindow) ns;
        assertEquals(NicoScript.UNDEFINED_DEFAULT_TIME, chat.getTime());
        assertNull(script.getLabel());

        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptWindow);
        assertFalse(fake.calledAddCommandWindow);
        assertFalse(fake.calledRemoveCommandWindow);

        script.onDraw(fake);
        assertEquals(script, fake.scriptWindow);
        assertTrue(fake.calledAddCommandWindow);
        assertFalse(fake.calledRemoveCommandWindow);

        script.onPrepareRemove(fake);
        assertEquals(script, fake.scriptWindow);
        assertTrue(fake.calledRemoveCommandWindow);

    }

    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠窓", chat);
        assertEquals(NicoScriptWindow.class, ns.getClass());

        NicoScriptWindow script = (NicoScriptWindow) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());
        assertEquals(NicoScriptWindow.WINDOW_SIZE_NORMAL, script.getWindowSize());

        assertNull(script.getLabel());

        assertTrue(script.match("上"));
        assertTrue(script.match("下"));
        assertTrue(script.match("左"));
        assertTrue(script.match("右"));
        assertTrue(script.match("次は上"));
        assertTrue(script.match("次は下"));
        assertTrue(script.match("次は左"));
        assertTrue(script.match("次は右"));
    }

    public void testIsSaveLocal() {
        MessageChatFork chat = new MessageChatFork("@90 local", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠窓", chat);
        assertEquals(NicoScriptWindow.class, ns.getClass());

        NicoScriptWindow script = (NicoScriptWindow) ns;
        assertTrue(script.isSaveLocal());
    }

    public void testOption1() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠窓：ウインドウ up、down、left、right 50%,50%,50%,50% 部分一致", chat);
        assertEquals(NicoScriptWindow.class, ns.getClass());

        NicoScriptWindow script = (NicoScriptWindow) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());
        assertEquals(NicoScriptWindow.WINDOW_SIZE_NORMAL, script.getWindowSize());

        assertEquals("ウインドウ", script.getLabel());

        assertTrue(script.match("up"));
        assertTrue(script.match("down"));
        assertTrue(script.match("left"));
        assertTrue(script.match("right"));
        assertTrue(script.match("次はup"));
        assertTrue(script.match("次はdown"));
        assertTrue(script.match("次はleft"));
        assertTrue(script.match("次はright"));
    }

    public void testOption2() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠窓：ウインドウ up、down、left、right 50%,50%,50%,50% 完全一致", chat);
        assertEquals(NicoScriptWindow.class, ns.getClass());

        NicoScriptWindow script = (NicoScriptWindow) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());
        assertEquals(NicoScriptWindow.WINDOW_SIZE_NORMAL, script.getWindowSize());

        assertEquals("ウインドウ", script.getLabel());

        assertTrue(script.match("up"));
        assertTrue(script.match("down"));
        assertTrue(script.match("left"));
        assertTrue(script.match("right"));
        assertFalse(script.match("次はup"));
        assertFalse(script.match("次はdown"));
        assertFalse(script.match("次はleft"));
        assertFalse(script.match("次はright"));
    }

    public void testSmall() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠小窓：ちいさい", chat);
        assertEquals(NicoScriptWindow.class, ns.getClass());

        NicoScriptWindow script = (NicoScriptWindow) ns;
        assertFalse(script.isSaveLocal());
        assertEquals(NicoScriptWindow.WINDOW_SIZE_SMALL, script.getWindowSize());

        assertEquals("ちいさい", script.getLabel());
    }

    public void testBig() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠大窓：おおきい", chat);
        assertEquals(NicoScriptWindow.class, ns.getClass());

        NicoScriptWindow script = (NicoScriptWindow) ns;
        assertFalse(script.isSaveLocal());
        assertEquals(NicoScriptWindow.WINDOW_SIZE_BIG, script.getWindowSize());

        assertEquals("おおきい", script.getLabel());
    }
}
