package jp.sourceforge.nicoro;

import android.app.Dialog;
import android.os.Bundle;

import jp.gr.java_conf.shiseissi.commonlib.DialogFragmentEx;

public class CloseDialogFragment extends DialogFragmentEx {
    private static final String KEY_TITLE = "mTitle";
    private static final String KEY_MESSAGE = "mMessage";
    private static final String KEY_TRY_FINISH_ACTIVITY = "mTryFinishActivity";
    private static final String KEY_IS_ERROR = "mIsError";

    private String mTitle;
    private String mMessage;
    private boolean mTryFinishActivity;
    private boolean mIsError;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Bundle args = getArguments();
        if (args == null && savedInstanceState != null) {
            args = savedInstanceState.getBundle(Util.KEY_ARGUMENTS);
            setArguments(args);
        }
        mTitle = args.getString(KEY_TITLE);
        mMessage = args.getString(KEY_MESSAGE);
        mTryFinishActivity = args.getBoolean(KEY_TRY_FINISH_ACTIVITY);
        mIsError = args.getBoolean(KEY_IS_ERROR);
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        String title;
        if (mIsError) {
            title = getString(R.string.error);
        } else {
            title = mTitle;
        }
        return Util.createCloseDialog(getActivity(),
                title, mMessage, mTryFinishActivity);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBundle(Util.KEY_ARGUMENTS, getArguments());
    }

    public static CloseDialogFragment createDialog(String title, String message,
            boolean tryFinishActivity) {
        Bundle args = new Bundle(4);
        args.putString(KEY_TITLE, title);
        args.putString(KEY_MESSAGE, message);
        args.putBoolean(KEY_TRY_FINISH_ACTIVITY, tryFinishActivity);
        args.putBoolean(KEY_IS_ERROR, false);
        CloseDialogFragment dialog = new CloseDialogFragment();
        dialog.setArguments(args);
        return dialog;
    }
    public static CloseDialogFragment createErrorDialog(String message,
            boolean tryFinishActivity) {
        Bundle args = new Bundle(4);
        args.putString(KEY_TITLE, null);
        args.putString(KEY_MESSAGE, message);
        args.putBoolean(KEY_TRY_FINISH_ACTIVITY, tryFinishActivity);
        args.putBoolean(KEY_IS_ERROR, true);
        CloseDialogFragment dialog = new CloseDialogFragment();
        dialog.setArguments(args);
        return dialog;
    }
}
