package jp.gr.java_conf.shiseissi.commonlib;

import android.app.Activity;
import android.content.Context;
import android.graphics.Paint;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.os.Environment;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.List;
//import java.io.IOException;

/**
 *
 * @author shisei
 */
public class APILevelWrapper4 extends APILevelWrapper {
    private static final File EXTERNAL_STORAGE_DIRECTORY =
        Environment.getExternalStorageDirectory();
    private static final File EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY =
        new File(new File(EXTERNAL_STORAGE_DIRECTORY, "Android"), "data");

    private static SoftReference<File> mExternalFilesDir = new SoftReference<File>(null);

    private static final Object mSync = new Object();

    protected APILevelWrapper4() {
    }

    @Override
    public File getExternalFilesDir(Context context, String type) {
        return getExternalFilesDirImpl(context, type);
    }

    @SuppressWarnings("deprecation")
    @Override
    public void setPluginsEnabled(WebSettings webSettings, boolean flag) {
        webSettings.setPluginsEnabled(flag);
    }

    @Override
    public void setDomStorageEnabled(WebSettings webSettings, boolean flag) {
        // 空実装
    }

    @Override
    public Object getActionBar(Activity activity) {
        return null;
    }

    @Override
    public void setDisplayHomeAsUpEnabled_ActionBar(Object actionBar,
            boolean showHomeAsUp) {
        // 空実装
    }

    @Override
    public void setCustomView_ActionBar(Object actionBar, int resId) {
        // 空実装
    }

    @Override
    public void show_ActionBar(Object actionBar) {
        // 空実装
    }

    @Override
    public void hide_ActionBar(Object actionBar) {
        // 空実装
    }

    @Override
    public boolean isShowing_ActionBar(Object actionBar) {
        // 空実装
        return false;
    }

    @Override
    public <T extends View> T getCustomView_ActionBar(Object actionBar) {
        // 空実装
        return null;
    }

    @Override
    public int getHeight_ActionBar(Object actionBar) {
        // 空実装
        return 0;
    }

    @Override
    public void setSystemUiVisibility(View view, int visibility) {
        // 空実装
    }

    @Override
    public <Params> AsyncTask<Params, ?, ?> executeOnSerialExecutor(AsyncTask<Params, ?, ?> task,
            Params... params) {
        return task.execute(params);
    }

    @Override
    public <Params> AsyncTask<Params, ?, ?> executeOnThreadPoolExecutor(
            AsyncTask<Params, ?, ?> task, Params... params) {
        return task.execute(params);
    }

    @Override
    public void setDisplayOrientation(Camera camera, int degrees) {
        // 4ではCameraに対しては無視
    }

    @Override
    public void setPreviewSize(Camera.Parameters params,
            int width, int height) {
        setPreviewSizeImpl(params, width, height);
    }

    @Override
    public void getCameraInfo(int cameraId, CameraInfo cameraInfo) {
        getCameraInfoImpl(cameraId, cameraInfo);
    }

    @Override
    public List<Camera.Size> getSupportedPreviewSizes(Camera.Parameters params) {
        return null;
    }

    @Override
    public List<Integer> getSupportedPreviewFormats(Camera.Parameters params) {
        return null;
    }

    @Override
    public void emulateShiftHeld(WebView webView) {
        emulateShiftHeldImpl(webView);
    }

    @Override
    public void invalidateOptionsMenu(Activity activity) {
        // 空実装
    }

    @Override
    public void setLayerType(View view, int layerType, Paint paint) {
        // 空実装
    }

    static File getExternalFilesDirImpl(Context context, String type) {
        synchronized (mSync) {
            File externalFilesDir = mExternalFilesDir.get();
            if (externalFilesDir == null) {
                externalFilesDir = new File(new File(
                        EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY,
                        context.getPackageName()), "files");
                mExternalFilesDir = new SoftReference<File>(externalFilesDir);
            }
            if (!EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY.exists()) {
                if (!EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY.mkdirs()) {
                    Log.w(LOG_TAG, Log.buf().append("Unable to create ")
                            .append(EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY));
                    return null;
                }
            }
            if (!externalFilesDir.exists()) {
//                try {
//                    new File(EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY, ".nomedia").createNewFile();
//                } catch (IOException e) {
//                    Log.w(LOG_TAG, "Unable to create "
//                            + EXTERNAL_STORAGE_ANDROID_DATA_DIRECTORY
//                            + "/.nomedia");
//                }
                if (!externalFilesDir.mkdirs()) {
                    Log.w(LOG_TAG, Log.buf().append("Unable to create ")
                            .append(externalFilesDir));
                    return null;
                }
            }
            if (type == null) {
                return externalFilesDir;
            }
            File dir = new File(externalFilesDir, type);
            if (!dir.exists()) {
                if (!dir.mkdirs()) {
                    Log.w(LOG_TAG, Log.buf().append("Unable to create ")
                            .append(dir));
                    return null;
                }
            }
            return dir;
        }
    }

    static void setPreviewSizeImpl(Camera.Parameters params,
            int width, int height) {
        if (width >= height) {
            params.setPreviewSize(width, height);
            params.set("orientation", "landscape");
        } else {
            params.setPreviewSize(height, width);
            params.set("orientation", "portrait");
        }
    }

    static void getCameraInfoImpl(int cameraId, CameraInfo cameraInfo) {
        cameraInfo.facing = 0;
        cameraInfo.orientation = 90;
    }

    @SuppressWarnings("deprecation")
    static void emulateShiftHeldImpl(WebView webView) {
        KeyEvent shiftPressEvent = new KeyEvent(0, 0,
                KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_SHIFT_LEFT, 0, 0);
        shiftPressEvent.dispatch(webView);
    }
}
