package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChat;
import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;

public class NicoScriptGyaku extends NicoScript {
    protected static final String COMMAND = "逆";
    
    /**
     * 逆の対象：全て＝全
     */
    private static final int TARGET_SUBE = 0;
    /**
     * 逆の対象：コメントのみ＝コメ
     */
    private static final int TARGET_COMME = 1;
    /**
     * 投稿者コメントのみ＝投コメ
     */
    private static final int TARGET_TOUCOMME = 2;
    
    private int mTarget;
    
    public NicoScriptGyaku(MessageChatFork chat, String[] commands) {
        super(chat);
        if (chat.getTime() < 0) {
            chat.setTime(30); // デフォルト値
        }
        if (commands.length < 2) {
            mTarget = TARGET_SUBE;
        } else {
            String target = commands[1];
            assert target != null;
            if (target.startsWith("全")) {
                mTarget = TARGET_SUBE;
            } else if (target.startsWith("コメ")) {
                mTarget = TARGET_COMME;
            } else if (target.startsWith("投コメ")) {
                mTarget = TARGET_TOUCOMME;
            } else {
                mTarget = TARGET_SUBE;
            }
        }
    }
    
    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.clearCommandGyaku(this);
    }
    @Override
    public void onDraw(MessageChatController controller) {
        controller.setCommandGyaku(this);
    }

    public int getDir(boolean isFork) {
        switch (mTarget) {
            case TARGET_SUBE:
                return MessageChat.DIR_GYAKU;
            case TARGET_COMME:
                if (isFork) {
                    return MessageChat.DIR_NORMAL;
                } else {
                    return MessageChat.DIR_GYAKU;
                }
            case TARGET_TOUCOMME:
                if (isFork) {
                    return MessageChat.DIR_GYAKU;
                } else {
                    return MessageChat.DIR_NORMAL;
                }
            default:
                assert false : "unexpected target=" + mTarget;
                return MessageChat.DIR_NORMAL;
        }
    }
}
