package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicReference;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicLineFormatter;

import android.os.Handler;

public abstract class HttpXmlLoader extends XmlLoader {
//	private static final boolean DEBUG_LOGV = Release.IS_DEBUG & true;
	private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

//	private HttpUriRequest mHttpRequest = null;
    private AtomicReference<InputStream> mInDownload =
        new AtomicReference<InputStream>();
    private DefaultHttpClient mHttpClient;

	protected HttpXmlLoader() {
	    super();
	}
	protected HttpXmlLoader(Handler handler) {
	    super(handler);
	}

	protected abstract HttpUriRequest createRequest();

	@Override
	public void run() {
		DefaultHttpClient httpClient = Util.createHttpClient();
		mHttpClient = httpClient;
		httpClient.getCookieStore().clear();
		InputStream inDownload = null;
		HttpEntity entityInput = null;

		try {
			HttpUriRequest httpRequest = createRequest();
//			mHttpRequest = httpRequest;
			HttpResponse httpResponse = httpClient.execute(
					httpRequest
					);
			if (DEBUG_LOGD) {
				Log.d(LOG_TAG, "XmlLoader HTTP response>");
                Log.d(LOG_TAG, BasicLineFormatter.formatStatusLine(httpResponse.getStatusLine(), null));
				Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
			}

			int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
			if (httpStatusCode == HttpStatus.SC_OK) {
				entityInput = httpResponse.getEntity();
				inDownload = entityInput.getContent();
				mInDownload.set(inDownload);

				boolean result = readAndCreateData(inDownload);

				if (result) {
					dispatchOnFinished();
				} else {
					dispatchOnOccurredError(getXmlParseErrorString());
				}
			} else {
				// エラー
				String errorMessage = "HTTP Status Code: " + httpStatusCode;
				dispatchOnOccurredError(errorMessage);
			}

		} catch (UnsupportedEncodingException e) {
			String errorMessage = e.toString();
			dispatchOnOccurredError(errorMessage);
			Log.d(LOG_TAG, errorMessage, e);
		} catch (ClientProtocolException e) {
			String errorMessage = e.toString();
			dispatchOnOccurredError(errorMessage);
			Log.d(LOG_TAG, errorMessage, e);
		} catch (IOException e) {
			String errorMessage = e.toString();
			dispatchOnOccurredError(errorMessage);
			Log.d(LOG_TAG, errorMessage, e);
		} finally {
//            mHttpRequest = null;
            if (entityInput != null) {
                try {
                    entityInput.consumeContent();
                } catch (IOException e) {
                    Log.e(LOG_TAG, e.toString(), e);
                }
            }
            mHttpClient.getConnectionManager().shutdown();
            // 同時にcloseすると不具合出る可能性があるので一回のみに
			if (inDownload != null && mInDownload.getAndSet(null) != null) {
				try {
					inDownload.close();
				} catch (IOException e) {
					Log.d(LOG_TAG, e.toString(), e);
				}
			}
		}

	}

	@Override
	protected void shutdownNetwork() {
	    if (mHttpClient != null) {
	        mHttpClient.getConnectionManager().shutdown();
	    }
//        HttpUriRequest httpRequest = mHttpRequest;
//        if (httpRequest != null && !httpRequest.isAborted()) {
//            httpRequest.abort();
//        }
//	    InputStream inDownload = mInDownload.getAndSet(null);
//	    if (inDownload != null) {
//	        try {
//                inDownload.close();
//            } catch (IOException e) {
//                Log.d(LOG_TAG, e.toString(), e);
//            }
//	    }
	}

	protected abstract String getXmlParseErrorString();
}
