package jp.sourceforge.nicoro;

import jp.sourceforge.nicoro.IVideoCacheServiceCallback;

interface IVideoCacheService {
	int getContentLength(String videoNumber, boolean isLow);
	int getProgress(String videoNumber, boolean isLow);
	/**
	 * 指定動画番号のキャッシュ実行を停止させる<BR>
	 * 場合によっては数秒以上の時間がかかるおそれがある
	 * @param videoNumber
	 */
	void stopCache(String videoNumber);
	int getCacheState(String videoNumber, boolean isLow);
	void addStartCache(String videoNumber, boolean forceLow,
		String cookieUserSession);
	int getWaitRequestSize();
	void clearNotification(String videoNumber);

	void addListener(IVideoCacheServiceCallback callback);
	void removeListener(IVideoCacheServiceCallback callback);
}
