package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.preference.PreferenceManager;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.ProgressBar;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.nicoro.StaticRes.string;

public class WebBrowserFragment extends Fragment
implements ListMenuFragmentStarter {
    private static final boolean DEBUG_LOGV = Release.IS_DEBUG & false;
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

    public static final String DOMAIN_NICO_JP = "www.nicovideo.jp";
    public static final String DOMAIN_NICO_TW = "tw.nicovideo.jp";
    public static final String DOMAIN_NICO_ES = "es.nicovideo.jp";
    public static final String DOMAIN_NICO_DE = "de.nicovideo.jp";
    public static final String DOMAIN_NICO_NINE = "nine.nicovideo.jp";

    public static final String PATTERN_VIDEO_URL =
        "http://(?:www|tw|es|de|nine|sp)\\.nicovideo\\.jp/watch/([a-z0-9]+)";
    private static final String PATTERN_GET_USERID_FROM_USERSESSION =
        "user_session=user_session_([^_]+)_";
    private static final String PATTERN_IS_NOT_HTML =
        "(\\.jpg|\\.jpeg|\\.JPG|\\.JPEG|\\.png|\\.PNG|\\.gif|\\.GIF|\\.js|\\.JS|\\.css|\\.CSS)$";
    private static final String PATTERN_JIKKYO_URL =
        "http://jk\\.nicovideo\\.jp/watch/([a-z0-9]+)";
    private static final String PATTERN_JIKKYO_APP =
        "^nicojk:(.+)";
    private static final String PATTERN_LIVE_URL =
        "http://(?:sp\\.)?live\\.nicovideo\\.jp/watch/([a-z0-9]+)";
    private static final String PATTERN_GET_TITLE =
        "^(.+)(?:\\s*-\\s*)?ニコニコ生放送\\s*$";

    private static final int MSG_ID_RUN_CACHING = 0;
    private static final int MSG_ID_FINISHED_CACHE = 1;
    private static final int MSG_ID_UPDATE_TITLE_URL = 2;
    private static final int MSG_ID_STARTED_CACHE = 3;
    private static final int MSG_ID_ACTION_START_PLAY = 4;
    private static final int MSG_ID_ACTION_START_CACHE = 5;
    private static final int MSG_ID_ACTION_RELATED_VIDEO = 6;
    private static final int MSG_ID_ACTION_DELETE_CACHE = 7;
    private static final int MSG_ID_ACTION_START_JIKKYO = 8;
    private static final int MSG_ID_ACTION_START_LIVE = 9;
    private static final int MSG_ID_GO_BACK_WEBVIEW = 10;
    private static final int MSG_ID_FLASH_SET_POS = 11;
    private static final int MSG_ID_FLASH_MATCH_FULL = 12;
    private static final int MSG_ID_UPDATE_OPTIONS_MENU = 13;
    private static final int MSG_ID_ACTION_ADD_MYLIST = 14;

    private static final int WEBVIEW_POOL_MIN_SIZE = 5;

    private class NicoroWebChromeClient extends WebChromeClient {
        @Override
        public void onProgressChanged(WebView view, int newProgress) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("WebChromeClient#onProgressChanged: newProgress=")
                        .append(newProgress).toString());
            }
            super.onProgressChanged(view, newProgress);
//            NicoroWebBrowser.this.setProgress(newProgress * 100);
            mProgressLoadPage.setProgress(newProgress);
            if (newProgress < 100) {
                mProgressLoadPage.setVisibility(View.VISIBLE);
            } else {
                mProgressLoadPage.setVisibility(View.GONE);
            }

            // TODO newProgressが適当
            if (newProgress > 30 && mJsObj.urlRss == null) {
//                assert view == mWebView;
                view.loadUrl(mResJsFindRss);
            }

            if (!mWasJsCalled && newProgress > 70) {
                if (mWithoutFlash) {
                    view.loadUrl(mResJsReplaceFlvplayerContainer);
                    view.loadUrl(mResJsReplacePlayerbox);
                }
                view.loadUrl(mResJsGetStreamDescription);
                view.loadUrl(mJsMarginBottom);
                mWasJsCalled = true;
            }
        }
        @Override
        public void onReceivedTitle(WebView view, String title) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("WebChromeClient#onReceivedTitle: title=")
                        .append(title)
                        .toString());
            }
            mHandler.sendEmptyMessage(MSG_ID_UPDATE_TITLE_URL);
        }
        @Override
        public boolean onCreateWindow(WebView view, boolean dialog,
                boolean userGesture, Message resultMsg) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("WebChromeClient#onCreateWindow: dialog=")
                        .append(dialog).append(" userGesture=")
                        .append(userGesture).append(" resultMsg=")
                        .append(resultMsg)
                        .toString());
            }
            assert view == mWebView;
            ViewGroup parent = (ViewGroup) view.getParent();
            if (parent == null) {
                assert false;
                return false;
            }
            LayoutInflater inflater = getActivity().getLayoutInflater();
            WebView newWebView = Util.inflate(inflater,
                    R.layout.nicoro_webbrowser_webview,
                    parent, false);
            initializeWebView(newWebView);
            Util.replaceView(view, newWebView);

            mWebView = newWebView;
            mWebViewPool.addLast(view);

            ((WebView.WebViewTransport) resultMsg.obj).setWebView(newWebView);
            resultMsg.sendToTarget();
            return true;
        }
        @Override
        public void onCloseWindow(WebView window) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("WebChromeClient#onCloseWindow: window=")
                        .append(window)
                        .toString());
            }
            assert window == mWebView;
            if (mWebViewPool.isEmpty()) {
                // TODO ここでActivity終わらせてしまって良いかどうか
                getActivity().finish();
            } else {
                assert window.getParent() != null;
                WebView lastWebView = mWebViewPool.removeLast();
                Util.replaceView(window, lastWebView);
                mWebView = lastWebView;
                String url = lastWebView.getUrl();
                updateLastUrl(url);
                window.destroy();
                onChangePage(lastWebView, url);
            }
        }
        @Override
        public void onRequestFocus(WebView view) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("onRequestFocus#onCloseWindow: view=")
                        .append(view)
                        .toString());
            }
//            onChangePage(view, view.getUrl());
        }
    }
    private class NicoroWebViewClient extends WebViewClient {
        @Override
        public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("WebViewClient#doUpdateVisitedHistory: url=")
                        .append(url).append(" isReload=").append(isReload)
                        .toString());
            }
            if (!isReload) {
                if (url.equals("http://jk.nicovideo.jp/")) {
                    // ヒント表示
                    Util.showInfoToast(mContext,
                            R.string.toast_explain_launch_jikkyo);
                }
            }
        }

        @Override
        public void onLoadResource(WebView view, String url) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("WebViewClient#onLoadResource: url=")
                        .append(url)
                        .toString());
            }
            onChangePage(view, url);
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("WebViewClient#onPageStarted: url=")
                        .append(url).append(" favicon=").append(favicon)
                        .toString());
            }
//            onChangePage(view, url);

//            // 念のため前のをキャンセル
//            mHandler.removeMessages(MSG_ID_UPDATE_TITLE_URL);
//            mHandler.sendEmptyMessageDelayed(MSG_ID_UPDATE_TITLE_URL,
//                    1000L);

//            boolean wasLogout;
//            if (url.equals("https://secure.nicovideo.jp/secure/logout")) {
//                // ログアウト
//                mCookieUserSession = null;
//                mUserId = null;
////                  CookieManager cookieManager = mCookieManager;
////                  cookieManager.removeExpiredCookie();
////                  cookieManager.setCookie("nicovideo.jp", "user_session=");
//                wasLogout = true;
//            } else {
//                wasLogout = false;
//            }
//
//            if (!wasLogout) {
//                if (mCookieUserSession == null && url.indexOf("nicovideo.jp") >= 0) {
//                    updateCookieUserSession();
//                }
//            }

            mJsObj.urlRss = null;
            mJsObj.streamDescription = null;
            mWasJsCalled = false;

            // XXX 若干遅らせてメニュー更新
            mHandler.sendEmptyMessageDelayed(MSG_ID_UPDATE_OPTIONS_MENU, 1000L);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("WebViewClient#onPageFinished: url=")
                        .append(url)
                        .toString());
            }
//            // 念のためもう一度実行
//            mHandler.removeMessages(MSG_ID_UPDATE_TITLE_URL);
//            mHandler.sendEmptyMessage(MSG_ID_UPDATE_TITLE_URL);

            if (mWithoutFlash) {
                view.loadUrl(mResJsReplaceFlvplayerContainer);
                view.loadUrl(mResJsReplacePlayerbox);
            }
            if (mJsObj.streamDescription == null) {
                view.loadUrl(mResJsGetStreamDescription);
            }
            view.loadUrl(mJsMarginBottom);
            mWasJsCalled = true;
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("WebViewClient#shouldOverrideUrlLoading: url=")
                        .append(url)
                        .toString());
            }
            Matcher matcherJikkyoApp = mMatcherJikkyoApp.get().reset(url);
            if (matcherJikkyoApp.find()) {
                // 実況アプリ起動ボタン
                startJikkyo(matcherJikkyoApp.group(1));
                return true;
            }
            if (!mMatcherIsNicovideo.get().reset(url).find()
                    && !mMatcherIsNicoseiga.get().reset(url).find()) {
                // 外部サイトへのリンクの場合はIntent投げる
                Intent intent = new Intent(Intent.ACTION_VIEW,
                        Uri.parse(url))
                    .addCategory(Intent.CATEGORY_BROWSABLE)
                    .setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
                startActivity(intent);
                return true;
            }

            return false;
        }
    }

    Context mContext;

    private WebView mWebView;
    private Button mButtonAction;
//  private VariableLabelView mLabelStatus1;
//  private VariableLabelView mLabelStatus2;
//  private VariableLabelView mLabelTitleUrl;
    private ProgressBar mProgressLoadPage;

    private ProgressDialog mProgressDialogStartPlay;

    private CookieSyncManager mCookieSyncManager;
    private CookieManager mCookieManager;

    private LinkedList<WebView> mWebViewPool = new LinkedList<WebView>();
    @SuppressWarnings("unused")
    private WatchCache mWatchCache = new WatchCache(new Runnable() {
        @Override
        public void run() {
            if (mWebViewPool.size() > WEBVIEW_POOL_MIN_SIZE) {
                try {
                    WebView oldWebView = mWebViewPool.removeFirst();
                    oldWebView.destroy();
                } catch (NoSuchElementException e) {
                    if (DEBUG_LOGD) {
                        Log.d(LOG_TAG, e.toString(), e);
                    }
                }
            }
        }
    });

    /** 動画視聴向けCookie */
    private String mCookieNicoHistory;

    // 設定
    private SharedPreferences mSharedPreferences;
    private SharedPreferences.OnSharedPreferenceChangeListener mSharedPreferencesChangeListener;
    /** 認証向けCookie */
    private String mCookieUserSession;
    private String mCookieUserSpSession;
    private String mLastUrl;
    private String mUserAgent;

    private String mUserId;

    private String mStartUrl;

    private String mVideoNumber;
    private String mJikkyoNumber;
    private String mLiveNumber;

    private StateManager mStateManager = new StateManager();

    private boolean mWithoutFlash;
    private boolean mShowActionButton;

    private ThumbInfoCacher mThumbInfoCacher;

    private MatcherThreadLocal mMatcherVideoUrl =
        new MatcherThreadLocal(PATTERN_VIDEO_URL);
    private MatcherThreadLocal mMatcherGetUserID =
        new MatcherThreadLocal(PATTERN_GET_USERID_FROM_USERSESSION);
    private MatcherThreadLocal mMatcherIsNotHtml =
        new MatcherThreadLocal(PATTERN_IS_NOT_HTML);
    private MatcherThreadLocal mMatcherJikkyoApp =
        new MatcherThreadLocal(PATTERN_JIKKYO_APP);
    private MatcherThreadLocal mMatcherJikkyoUrl =
        new MatcherThreadLocal(PATTERN_JIKKYO_URL);
    private MatcherThreadLocal mMatcherIsNicovideo =
        new MatcherThreadLocal(NicoroAPIManager.PATTERN_NICOVIDEO_URL);
    private MatcherThreadLocal mMatcherIsNicoseiga =
        new MatcherThreadLocal(NicoroAPIManager.PATTERN_NICOSEIGA_URL);
    private MatcherThreadLocal mMatcherLiveUrl =
        new MatcherThreadLocal(PATTERN_LIVE_URL);

    private DecimalFormat mDecimalFormatMB;

    private CallbackMessage<Bundle, Void> mListMenuStarter;

    private JsObj mJsObj = new JsObj();

    private boolean mWasJsCalled;

    private Locale mCurrentLocale;
    // リソースのキャッシュ
    private String mResStringStatusLowShort;
    private String mResStringStatusHighShort;
    private String mResStringStatusHighLowShort;
//  private String mResStringStatus1NotLogin;
    private String mResStringStatus1CompletedCache;
    private String mResStringStatus1RunningCache;
    private String mResStringStatus1WaitingCache;
    private String mResStringStatus1NoneCache;
    private String mResStringStatus2RunningCache;
    private String mResStringStatus2WaitingCache;
    private String mResStringStatus2StartingCache;
    private String mResStringProgressStartPlay;

    private String mResStringPrefKeyBrowserZoomControls;
    private String mResStringPrefKeyWithoutFlash;
    private String mResStringPrefKeyShowActionButton;

    private String mResJsFindRss;
    private String mResJsReplaceFlvplayerContainer;
    private String mResJsReplacePlayerbox;
    private String mResJsGetStreamDescription;
    private String mResJsGetOffsetFlvplayerContainer;

    private String mJsMarginBottom;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            if (mStateManager.wasDestroyed()) {
                return;
            }

            WebView webView = mWebView;
            switch (msg.what) {
            case MSG_ID_STARTED_CACHE:
                if (mWithoutFlash) {
                    // キャッシュ開始
//                  updateStatus1();
//                  updateStatus2((String) msg.obj);
                    if (webView != null) {
                        webView.loadUrl(mResJsReplaceFlvplayerContainer);
                    }
                }
                break;
            case MSG_ID_RUN_CACHING:
                if (mWithoutFlash) {
                    // キャッシュ実行中
//                  updateStatus2((String) msg.obj);
                }
                break;
            case MSG_ID_FINISHED_CACHE:
                if (mWithoutFlash) {
                    // キャッシュ完了
//                  updateStatus1();
//                  updateStatus2("");
                    if (webView != null) {
                        webView.loadUrl(mResJsReplaceFlvplayerContainer);
                    }
                }
                break;
            case MSG_ID_UPDATE_TITLE_URL:
                if (webView != null) {
//                    // ページのタイトルとURL表示を更新
//                  String title = webView.getTitle();
//                    if (title == null) {
//                        mHandler.sendEmptyMessageDelayed(MSG_ID_UPDATE_TITLE_URL,
//                                1000L);
//                    } else {
//                        String newText = title + " : " + webView.getUrl();
//                        if (!newText.equals(mLabelTitleUrl.getText())) {
//                            mLabelTitleUrl.setText(newText);
//                        }
//                    }

                    // ブックマーク表示の更新
                    BookmarksFragment bookmarks = Util.findFragmentByTag(
                            getFragmentManager(), string.tag_bookmarks_fragment);
                    if (bookmarks != null) {
                        String title = webView.getTitle();
                        String url = webView.getUrl();
                        if (!TextUtils.isEmpty(title) && !TextUtils.isEmpty(url)) {
                            bookmarks.setAddBookmark(url, title);
                        }
                    }
                }
                break;
            case MSG_ID_ACTION_START_PLAY:
                if (mWithoutFlash) {
                    startPlay(msg.arg1 != 0);
                }
                break;
            case MSG_ID_ACTION_START_CACHE:
                if (mWithoutFlash) {
                    startCache(msg.arg1 != 0);
                }
                break;
            case MSG_ID_ACTION_RELATED_VIDEO:
                assert mVideoNumber != null;
//                relatedVideo();
                showListMenu(webView, R.id.radio_related_video);
                break;
            case MSG_ID_ACTION_DELETE_CACHE:
                assert mVideoNumber != null;
                deleteCache();
                break;
            case MSG_ID_ACTION_ADD_MYLIST:
                assert mVideoNumber != null;
                addMylist();
                break;
            case MSG_ID_ACTION_START_JIKKYO:
                assert mJikkyoNumber != null;
                startJikkyo(mJikkyoNumber);
                break;
            case MSG_ID_ACTION_START_LIVE:
                if (mWithoutFlash) {
                    assert mLiveNumber != null;
                    startLive(mLiveNumber);
                }
                break;
            case MSG_ID_GO_BACK_WEBVIEW:
                goBackWebView();
                break;
            case MSG_ID_FLASH_SET_POS: {
                Rect r = (Rect) msg.obj;
                if (webView != null) {
                    float scale = webView.getScale();
                    webView.scrollTo((int) (r.left * scale), (int) (r.top * scale));
                }
            } break;
            case MSG_ID_FLASH_MATCH_FULL: {
                Rect r = (Rect) msg.obj;
                if (webView != null) {
                    int widthView = webView.getWidth();
                    int heightView = webView.getHeight();
                    int widthFlash = r.width();
                    int heightFlash = r.height();
                    float scale;
                    int widthScaleFlash;
                    int heightScaleFlash;
                    while (true) {
                        scale = webView.getScale();
                        widthScaleFlash = (int) (widthFlash * scale);
                        heightScaleFlash = (int) (heightFlash * scale);
                        if (widthScaleFlash * 1.25f < widthView
                                && heightScaleFlash * 1.25f < heightView) {
                            if (!webView.zoomIn()) {
                                break;
                            }
                        } else if (widthScaleFlash > widthView
                                && heightScaleFlash > heightView) {
                            if (!webView.zoomOut()) {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                    scale = webView.getScale();
                    int x = (int) (r.left * scale);
                    int y;
                    heightScaleFlash = (int) (heightFlash * scale);
                    if (heightScaleFlash <= heightView) {
                        y = (int) (r.top * scale);
                    } else {
                        y = (int) ((r.top + (heightScaleFlash - heightView) / 2) * scale);
                    }
                    webView.scrollTo(x, y);
                }
            } break;
            case MSG_ID_UPDATE_OPTIONS_MENU:
                updateOptionsMenu();
                break;
            default:
                assert false : msg.what;
                break;
            }
        }
    };

    private IVideoCacheService mVideoCacheService;
    private final ServiceConnection mVideoCacheServiceConnection = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, Log.buf().append("onServiceConnected")
                        .append(name.toString()).append(' ')
                        .append(service.toString()).toString());
            }
            mVideoCacheService = IVideoCacheService.Stub.asInterface(service);

            try {
                mVideoCacheService.addListener(mVideoCacheServiceCallback);
            } catch (RemoteException e) {
                Log.e(LOG_TAG, e.toString(), e);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, Log.buf().append("onServiceDisconnected")
                        .append(name.toString()).toString());
            }
            try {
                mVideoCacheService.removeListener(mVideoCacheServiceCallback);
            } catch (RemoteException e) {
                Log.e(LOG_TAG, e.toString(), e);
            }

            mVideoCacheService = null;

//            Intent intent = new Intent(IVideoCacheService.class.getName());
//            mContext.stopService(intent);
        }

    };
    private IVideoCacheServiceCallback mVideoCacheServiceCallback =
        new IVideoCacheServiceCallback.Stub() {
            private AtomicReference<StringBuffer> mStringBuffer =
                new AtomicReference<StringBuffer>(new StringBuffer(64));

            @Override
            public void onNotifyProgress(String videoNumber, boolean isLow,
                    int seekOffsetWrite, int contentLength)
                    throws RemoteException {
                if (DEBUG_LOGV) {
                    Log.v(LOG_TAG, Log.buf()
                            .append("onNotifyProgress() videoNumber=").append(videoNumber)
                            .append(" isLow=").append(isLow)
                            .append(" seekOffsetWrite=").append(seekOffsetWrite)
                            .append(" contentLength=").append(contentLength)
                            .toString());
                }
                if (!mWithoutFlash) {
                    return;
                }
                // このコールバックは複数スレッドから同時に呼ばれることはない設計
                StringBuffer message = mStringBuffer.getAndSet(null);
                assert message != null;
                message.setLength(0);

                message.append(videoNumber);
                if (isLow) {
                    message.append(mResStringStatusLowShort);
                }
                message.append(mResStringStatus2RunningCache).append(": ");
                getRunCachingProgressMessage(message,
                        seekOffsetWrite, contentLength);
                addWaitingCacheMessage(message);
                mHandler.obtainMessage(MSG_ID_RUN_CACHING,
                        message.toString()).sendToTarget();

                StringBuffer temp = mStringBuffer.getAndSet(message);
                assert temp == null;
            }
            @Override
            public void onStart(String videoNumber, boolean isLow)
            throws RemoteException {
                if (!mWithoutFlash) {
                    return;
                }
                StringBuilder message = new StringBuilder(32);
                message.append(videoNumber);
                if (isLow) {
                    message.append(mResStringStatusLowShort);
                }
                message.append(mResStringStatus2StartingCache);
                addWaitingCacheMessage(message);
                mHandler.obtainMessage(MSG_ID_STARTED_CACHE,
                        message.toString()).sendToTarget();
            }
            @Override
            public void onFinished(String videoNumber, boolean isLow)
            throws RemoteException {
                if (!mWithoutFlash) {
                    return;
                }
                mHandler.sendEmptyMessage(MSG_ID_FINISHED_CACHE);
            }
            @Override
            public void onAllFinished() throws RemoteException {
//              unbindService(mVideoCacheServiceConnection);
            }

            StringBuffer addWaitingCacheMessage(StringBuffer message)
            throws RemoteException {
                int waitRequestSize = mVideoCacheService.getWaitRequestSize();
                if (waitRequestSize > 0) {
                    message.append(" （")
                        .append(mResStringStatus2WaitingCache)
                        .append(":")
                        .append(waitRequestSize)
                        .append("）");
                }
                return message;
            }
            StringBuilder addWaitingCacheMessage(StringBuilder message)
            throws RemoteException {
                int waitRequestSize = mVideoCacheService.getWaitRequestSize();
                if (waitRequestSize > 0) {
                    message.append(" （")
                        .append(mResStringStatus2WaitingCache)
                        .append(":")
                        .append(waitRequestSize)
                        .append("）");
                }
                return message;
            }
    };

//  private AsyncCheckCookieUserSession mAsyncCheckCookieUserSession = null;
//  private class AsyncCheckCookieUserSession extends AsyncTask<Void, Void, Boolean> {
//      private HttpUriRequest mHttpRequest;
//
//      @Override
//      protected void onPreExecute() {
//          mHttpRequest =
//              NicoroAPIManager.createRequestIsCookieUserSessionValid(
//                      mCookieUserSession, mUserAgent);
//      }
//
//      @Override
//      protected Boolean doInBackground(Void... params) {
//          return NicoroAPIManager.checkIsCookieUserSessionValid(mHttpRequest);
//      }
//
//      @Override
//      protected void onPostExecute(Boolean result) {
//          reflectIsCookieUserSessionValid(result);
//          updateStatus1();
//
//          mAsyncCheckCookieUserSession = null;
//      }
//
//      public void stop() {
//          if (mHttpRequest != null && !mHttpRequest.isAborted()) {
//              mHttpRequest.abort();
//          }
//      }
//  }

    private AsyncStartPlay mAsyncStartPlay = null;
    private class AsyncStartPlay extends AsyncTask<Void, Void, Intent> {
        private HttpUriRequest mHttpRequestNicoHistory;
        private HttpUriRequest mHttpRequestUserSession;
        private HttpPost mHttpRequestAuthorizeCookie;
        private NicoroAPIManager.VideoPlayerIntentCreator mIntentCreator;
        private boolean mForceLow;
        private String mUrl;
        private String mVideoNumber;
        private Exception mException;

        @Override
        protected void onPreExecute() {
            WebView webView = mWebView;
            if (webView == null) {
                if (DEBUG_LOGD) {
                    Log.d(LOG_TAG, "AsyncStartPlay: mWebView is null");
                }
                mException = new FailPreparePlayVideoException();
                return;
            }
//          String url = webView.getOriginalUrl();
            String url = webView.getUrl();
            if (url == null) {
                if (DEBUG_LOGD) {
                    Log.d(LOG_TAG, "AsyncStartPlay: mWebView.getUrl() is null");
                }
                mException = new FailPreparePlayVideoException();
                return;
            }
            mUrl = url;

//          updateCookieUserSession();
//          if (DEBUG_LOGD) {
//              Log.d(LOG_TAG, "mCookieUserSession: " + mCookieUserSession);
//          }

            String videoNumber = Util.getFirstMatch(
                    mMatcherVideoUrl.get().reset(url));
            if (videoNumber == null) {
                mException = new FailPreparePlayVideoException();
                return;
            }
            mVideoNumber = videoNumber;

            if (mForceLow) {
                createHttpRequestGetHistory(videoNumber);
            }
        }

        @Override
        protected Intent doInBackground(Void... params) {
            if (mException != null) {
                return null;
            }
            return doInBackgroundMain(false, mForceLow);
        }

        private Intent doInBackgroundMain(boolean neverRetry,
                boolean forceHistory) {
            DefaultHttpClient httpClient = Util.createHttpClient();
            try {
                if (forceHistory) {
                    // 視聴履歴Cookie取り直す
                    mCookieNicoHistory = NicoroAPIManager.getCookieNicoHistory(
                            httpClient, mHttpRequestNicoHistory);
                } else {
                    mCookieNicoHistory = Util.getCookieValueFromManager(
                            mUrl, "nicohistory");
                }
                if (DEBUG_LOGD) {
                    Log.d(LOG_TAG, "mCookieNicoHistory: " + mCookieNicoHistory);
                }

                if (mCookieUserSession == null
                        || mUserId == null
                        || mCookieNicoHistory == null) {
                    throw new FailPreparePlayVideoException(
                            mContext.getString(R.string.errormessage_cookie_fail));
                }

                // キャッシュ処理が動作していれば停止
                // 時間がかかる恐れがあるのでdoInBackground内で実行
                if (mVideoCacheService != null) {
                    try {
                        mVideoCacheService.stopCache(mVideoNumber);
                        mVideoCacheService.clearNotification(mVideoNumber);
                    } catch (RemoteException e) {
                        Log.e(LOG_TAG, e.toString(), e);
                    }
                }

//              mLastVideoNumber = videoNumber;
                mIntentCreator =
                    new NicoroAPIManager.VideoPlayerIntentCreator();
                Intent intent = mIntentCreator.create(
                        mContext,
                        mVideoNumber, mCookieUserSession, mCookieNicoHistory,
                        mUserId, mUserAgent, mForceLow);
                if (intent != null) {
                    intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
                }
                return intent;
            } catch (FailPreparePlayVideoException e) {
                if (DEBUG_LOGD) {
                    Log.d(LOG_TAG, e.toString(), e);
                }
                if (!neverRetry && shouldRetry()) {
                    return doInBackgroundMain(true, true);
                }
                mException = e;
            } catch (IOException e) {
                Log.d(LOG_TAG, e.toString(), e);
                mException = e;
            } finally {
                httpClient.getConnectionManager().shutdown();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Intent result) {
            assert mProgressDialogStartPlay != null;
            if (mProgressDialogStartPlay != null) {
                mProgressDialogStartPlay.dismiss();
            }
            if (mStateManager.wasDestroyed()) {
                if (DEBUG_LOGD) {
                    Log.d(LOG_TAG, "AsyncStartPlay#onPostExecute: WebBrowserFragment was destroyed");
                }
            } else {
                if (result == null) {
                    String message;
                    if (mException == null) {
                        assert false;
                        // 原因不明で再生失敗
                        message = mContext.getString(R.string.errormessage_play_fail_unknown);
                    } else if (mException instanceof FailPreparePlayVideoException) {
                        message = mException.getMessage();
                        if (message == null) {
                            // 原因不明で再生失敗
                            message = mContext.getString(R.string.errormessage_play_fail_unknown);
                        }
                    } else {
                        message = mException.toString();
                    }
                    Util.showErrorDialog(getActivity(),
                            message,
                            false);
                } else {
                    Intent intent = result;
                    if (!mForceLow && NicoroAPIManager.isGetflvUrlLow(
                            intent.getStringExtra(PlayerConstants.INTENT_NAME_VIDEO_URL))) {
                        // 優先指定していないが低画質モードになった
                        Util.showInfoToast(mContext, getString(
                                R.string.toast_transfer_low, mVideoNumber));
                    }
                    startActivity(intent);
                    pauseWebView();
                }
            }

            mAsyncStartPlay = null;
        }

        public AsyncStartPlay executeWrapper(boolean forceLow) {
            mForceLow = forceLow;
            return (AsyncStartPlay) execute();
        }

        public void stop() {
            if (mHttpRequestNicoHistory != null && !mHttpRequestNicoHistory.isAborted()) {
                mHttpRequestNicoHistory.abort();
            }
            if (mHttpRequestUserSession != null
                    && !mHttpRequestUserSession.isAborted()) {
                mHttpRequestUserSession.abort();
            }
            if (mHttpRequestAuthorizeCookie != null
                    && !mHttpRequestAuthorizeCookie.isAborted()) {
                mHttpRequestAuthorizeCookie.abort();
            }
            if (mIntentCreator != null) {
                mIntentCreator.abort();
            }
        }

        private void createHttpRequestGetHistory(String videoNumber) {
            mHttpRequestNicoHistory = NicoroAPIManager.createGetCookieNicoHistory(
                    videoNumber, mCookieUserSession,
                    mForceLow, mUserAgent);
        }

        private boolean shouldRetry() {
            mHttpRequestUserSession = NicoroAPIManager.createRequestIsCookieUserSessionValid(
                    mCookieUserSession, mUserAgent);
            if (NicoroAPIManager.checkIsCookieUserSessionValid(
                    mHttpRequestUserSession)) {
                // Cookieは有効→原因不明のエラー
                return false;
            }
            // 何らかの理由でログアウト状態→Cookie再取得を試みる
            String ma = NicoroConfig.getMA(mSharedPreferences);
            String pw = NicoroConfig.getPW(mSharedPreferences);
            if (ma == null || pw == null) {
                return false;
            }
            DefaultHttpClient httpClient = Util.createHttpClient();
            try {
                mHttpRequestAuthorizeCookie =
                    NicoroAPIManager.createRequestGetAuthorizeCookie(
                        ma, pw, mUserAgent);
                // TODO sp.live向けのCookieも取り直すべき
                NicoroAPIManager.AuthorizeCookie cookie = NicoroAPIManager.getAuthorizeCookie(
                        httpClient, mHttpRequestAuthorizeCookie);
                if (cookie == null) {
                    return false;
                }
                SharedPreferences.Editor editor = mSharedPreferences.edit();
                editor.putString(NicoroConfig.COOKIE_USER_SESSION,
                        cookie.cookie);
                editor.putInt(NicoroConfig.AUTHFLAG, cookie.authflag);
                editor.commit();
                // 念のためメンバ変数更新をUIスレッドで実行
                getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        updateCookieUserSession();
                    }
                });
            } catch (UnsupportedEncodingException e) {
                Log.e(LOG_TAG, e.toString(), e);
                return false;
            } catch (ClientProtocolException e) {
                Log.e(LOG_TAG, e.toString(), e);
                return false;
            } catch (IOException e) {
                Log.e(LOG_TAG, e.toString(), e);
                return false;
            } finally {
                httpClient.getConnectionManager().shutdown();
            }
            createHttpRequestGetHistory(mVideoNumber);
            return true;
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mStateManager.onCreate(savedInstanceState);

        mContext = getActivity().getApplicationContext();

        Resources res = getResources();
        mCurrentLocale = res.getConfiguration().locale;
        cacheResourceString();

        StringBuilder builder = new StringBuilder(256);
        builder.setLength(0);
        mResJsFindRss = Util.loadRawJs(builder, res,
                R.raw.find_rss).toString();

        builder.setLength(0);
        mResJsReplaceFlvplayerContainer = Util.loadRawJs(builder, res,
                R.raw.replace_flvplayer_container).toString();

        builder.setLength(0);
        mResJsReplacePlayerbox = Util.loadRawJs(builder, res,
                R.raw.replace_playerbox).toString();

        builder.setLength(0);
        mResJsGetStreamDescription = Util.loadRawJs(builder, res,
                R.raw.get_stream_description).toString();

        builder.setLength(0);
        mJsMarginBottom = builder.append("javascript: document.body.style.marginBottom = \"")
            .append(res.getDimensionPixelSize(R.dimen.button_video_control_height))
            .append("px\"").toString();

        builder.setLength(0);
        mResJsGetOffsetFlvplayerContainer = Util.loadRawJs(builder, res,
                R.raw.get_offset_flvplayer_container).toString();

//        getActivity().getWindow().requestFeature(Window.FEATURE_PROGRESS);

        // 例外対策兼ねて手動で作る
        CookieSyncManager cookieSyncManager =
            CookieSyncManager.createInstance(mContext);
        mCookieSyncManager = cookieSyncManager;

        CookieManager cookieManager = CookieManager.getInstance();
        mCookieManager = cookieManager;
        cookieManager.setAcceptCookie(true);
        cookieManager.removeExpiredCookie();
//      cookieManager.removeAllCookie();

        if (mSharedPreferences == null) {
            mSharedPreferences = PreferenceManager.getDefaultSharedPreferences(mContext);
        }
        mWithoutFlash = mSharedPreferences.getBoolean(mResStringPrefKeyWithoutFlash, true);
        mShowActionButton = mSharedPreferences.getBoolean(mResStringPrefKeyShowActionButton,
                res.getBoolean(R.bool.pref_default_show_action_button));

        mThumbInfoCacher = NicoroApplication.getInstance(getActivity()
                ).getThumbInfoCacher();

        // レイアウト崩れ対策
        setCookieNicovideo("nofix=1");
        // 実況アプリインストール済み状態に
        mCookieManager.setCookie("jk.nicovideo.jp", "jikkyo_installed=1");

        cookieSyncManager.sync();

        setHasOptionsMenu(true);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState) {
        return initializeView(inflater, container, savedInstanceState);
    }

    @Override
    public void onStart() {
        super.onStart();
        mStateManager.onStart();
    }

    @Override
    public void onResume() {
        super.onResume();
        mStateManager.onResume();

        mCookieSyncManager.startSync();

        updateCookieUserSession();
        mCookieSyncManager.sync();

        // Cookie更新後にURL設定
        WebView webView = mWebView;
        if (webView != null) {
            webView.resumeTimers();

            String urlWebView = webView.getUrl();
            if (urlWebView == null || !urlWebView.equals(mLastUrl)) {
                webView.loadUrl(mLastUrl);
            }
        }

        // URL読み込み済みでもWebViewのgetUrlがnullになることがある模様→WebViewでのイベント発生まで処理遅らせるべき？

//      updateStatus1();
//      updateStatus2("");
        if (webView != null && mWithoutFlash) {
            webView.loadUrl(mResJsReplaceFlvplayerContainer);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        mStateManager.onPause();

        mCookieSyncManager.stopSync();

        WebView webView = mWebView;
        if (webView != null) {
            String urlWebView = webView.getUrl();
            if (urlWebView != null) {
                updateLastUrl(urlWebView);
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        mStateManager.onStop();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        mStateManager.wasDestroyed();
        mSharedPreferences.unregisterOnSharedPreferenceChangeListener(mSharedPreferencesChangeListener);
        if (mVideoCacheService != null) {
            mContext.unbindService(mVideoCacheServiceConnection);
        }

//        if (mAsyncCheckCookieUserSession != null) {
//          mAsyncCheckCookieUserSession.cancel(false);
//          mAsyncCheckCookieUserSession.stop();
//        }
        if (mAsyncStartPlay != null) {
            mAsyncStartPlay.cancel(false);
            mAsyncStartPlay.stop();
        }
        WebView webView = mWebView;
        if (webView != null) {
            webView.destroy();
        }
        mWebView = null;
        for (WebView wv : mWebViewPool) {
            wv.destroy();
        }
        mWebViewPool.clear();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);

        if (!newConfig.locale.equals(mCurrentLocale)) {
            cacheResourceString();
        }
    }

//    @Override
//    public boolean onKeyDown(int keyCode, KeyEvent event) {
//        // 1.6向けなのでonKeyDownでback key監視
//        // onBackPressedの活用は、API5からのため駄目
//        if (keyCode == KeyEvent.KEYCODE_BACK) {
//            if (goBackWebView()) {
//                return true;
//            }
//        }
//        return super.onKeyDown(keyCode, event);
//    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        mStateManager.onSaveInstanceState();
        WebView webView = mWebView;
        if (webView != null) {
            webView.saveState(outState);
        }
    }

//    @Override
//    protected void onNewIntent(Intent intent) {
//        super.onNewIntent(intent);
//        String url = getUrlFromIntentActionView(intent);
//        if (url != null && !url.equals(mLastUrl)) {
//            updateLastUrl(url);
//            WebView webView = mWebView;
//            if (webView != null) {
//                webView.stopLoading();
//                webView.loadUrl(mLastUrl);
//            } else {
//                assert false;
//            }
//        }
//    }

    public void setStartUrl(String url) {
        // TODO 実装これだけで問題ないかどうか？
        // Fragment復帰時は使用しないはずなので、setArgumentsは使わない
        mStartUrl = url;
    }

    public void updateCurrentUrl(String url) {
        if (url != null && !url.equals(mLastUrl)) {
            updateLastUrl(url);
            WebView webView = mWebView;
            if (webView != null) {
                webView.stopLoading();
                webView.loadUrl(mLastUrl);
            } else {
                assert false;
            }
        }
    }

    private View initializeView(LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.nicoro_webbrowser, container, false);

        mButtonAction = Util.findViewById(v, R.id.button_action);
        mButtonAction.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
//              startAction();
//              openContextMenu(v);
                getActivity().openOptionsMenu();
            }
        });
        registerForContextMenu(mButtonAction);
        updateShowActionButton();

//      mLabelStatus1 = Util.findViewById(this, R.id.status1);
//      mLabelStatus2 = Util.findViewById(this, R.id.status2);
//        mLabelTitleUrl = Util.findViewById(this, R.id.web_title_url);

        mProgressLoadPage = Util.findViewById(v, R.id.progress);
        mProgressLoadPage.setVisibility(View.GONE);
        mProgressLoadPage.setMax(100);

        WebView webView = Util.findViewById(v, R.id.webview);
        mWebView = webView;
        initializeWebView(webView);

        WebBackForwardList backForwardList = null;
        if (savedInstanceState != null) {
            backForwardList = webView.restoreState(savedInstanceState);
        }

        String url = mStartUrl;
        if (url == null) {
            if (backForwardList != null) {
                url = backForwardList.getCurrentItem().getUrl();
            } else {
                url = "http://www.nicovideo.jp/";
                url = mSharedPreferences.getString(NicoroConfig.LAST_URL, url);
            }
        }
        // 過去バージョンの不具合対策
        if (!isInNicoVideoSite(url)) {
            url = "http://www.nicovideo.jp/";
        }
        updateLastUrl(url);

        mUserAgent = mSharedPreferences.getString(NicoroConfig.USER_AGENT,
                null);
        if (mUserAgent == null) {
            mUserAgent = webView.getSettings().getUserAgentString();
            SharedPreferences.Editor editor = mSharedPreferences.edit();
            editor.putString(NicoroConfig.USER_AGENT, mUserAgent);
            editor.commit();
        }

        mSharedPreferencesChangeListener = new SharedPreferences.OnSharedPreferenceChangeListener() {
            @Override
            public void onSharedPreferenceChanged(
                    SharedPreferences sharedPreferences, String key) {
                if (key.equals(mResStringPrefKeyBrowserZoomControls)) {
                    boolean zoomControl = sharedPreferences.getBoolean(key, true);
                    WebView webView = mWebView;
                    if (webView != null) {
                        webView.getSettings().setBuiltInZoomControls(zoomControl);
                    }
                } else if (key.equals(mResStringPrefKeyWithoutFlash)) {
                    boolean last = mWithoutFlash;
                    mWithoutFlash = sharedPreferences.getBoolean(key, true);
                    updateWithoutFlash();
                    if (last != mWithoutFlash && mWebView != null) {
                        mWebView.reload();
                    }
                } else if (key.equals(mResStringPrefKeyShowActionButton)) {
                    Resources res = mContext.getResources();
                    mShowActionButton = sharedPreferences.getBoolean(key,
                            res.getBoolean(R.bool.pref_default_show_action_button));
                    updateShowActionButton();
                }
            }
        };
        mSharedPreferences.registerOnSharedPreferenceChangeListener(mSharedPreferencesChangeListener);

        mDecimalFormatMB = Util.createRunCachingProgressMessageFormat();

//        webView.loadUrl(mLastUrl);

        return v;
    }

    private void initializeWebView(WebView webView) {
        assert mJsObj != null;
        initializeWebSettings(webView.getSettings());
        webView.setWebChromeClient(new NicoroWebChromeClient());
        webView.setWebViewClient(new NicoroWebViewClient());
        webView.addJavascriptInterface(mJsObj, "nicoro");
    }

    private void initializeWebSettings(WebSettings webSettings) {
        webSettings.setJavaScriptEnabled(true);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        webSettings.setSavePassword(true);
        webSettings.setUseWideViewPort(true);
//        webSettings.setLightTouchEnabled(true);
        // TODO 完全なマルチウインドウ対応は面倒そう
        webSettings.setSupportMultipleWindows(true);
        boolean zoomControl = mSharedPreferences.getBoolean(
                getString(R.string.pref_key_browser_zoom_controls), true);
        webSettings.setBuiltInZoomControls(zoomControl);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.FROYO) {
            APILevelUtil8.webSettingsSetPluginsEnabled(webSettings, !mWithoutFlash);
        } else {
            APILevelUtil4.webSettingsSetPluginsEnabled(webSettings, !mWithoutFlash);
        }
    }

//  private void downloadVideo(DefaultHttpClient httpClient, String url, String cookie, String filePath) throws ClientProtocolException, IOException {
//      HttpUriRequest httpRequest = new HttpGet(url);
//      httpRequest.addHeader("Cookie", cookie);
//      httpRequest.setHeader("User-Agent", mUserAgent);
//      HttpResponse httpResponse = httpClient.execute(
//              httpRequest
//              );
//      if (DEBUG_LOGD) {
//          Log.d(LOG_TAG, "downloadVideo httpResponse>>>");
//          Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
//          Log.d(LOG_TAG, "<<<httpResponse end");
//      }
//      if (httpResponse.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
//          HttpEntity httpEntity = httpResponse.getEntity();
//          InputStream inDownload = null;
//          FileOutputStream outDownload = null;
//          try {
//              inDownload = httpEntity.getContent();
//              outDownload = new FileOutputStream(filePath);
//              byte[] buffer = new byte[1024*8];
//              while (true) {
//                  int read = inDownload.read(buffer);
//                  if (read < 0) {
//                      break;
//                  }
//                  outDownload.write(buffer, 0, read);
//              }
//          } finally {
//              if (inDownload != null) {
//                  inDownload.close();
//              }
//              if (outDownload != null) {
//                  outDownload.close();
//              }
//          }
//      }
//      Log.d(LOG_TAG, "downloadVideo done.");
//  }

//  private void updateCookieUserSession() {
//      String cookieUserSession = Util.getCookieValueFromManager(
//              "nicovideo.jp", "user_session");
//      if (cookieUserSession == null || cookieUserSession.length() == 0) {
//          // 確実にログアウト状態
//          mCookieUserSession = null;
//          mUserId = null;
//      } else if (!cookieUserSession.equals(mCookieUserSession)) {
//          SharedPreferences.Editor editor = mSharedPreferences.edit();
//          editor.putString(NicoroConfig.COOKIE_USER_SESSION, cookieUserSession);
//          editor.commit();
//          mCookieUserSession = cookieUserSession;
//          mMatcherGetUserID = Util.getMatcher(mMatcherGetUserID,
//                  PATTERN_GET_USERID_FROM_USERSESSION,
//                  mCookieUserSession);
//          mUserId = Util.getFirstMatch(mMatcherGetUserID);
//      }
//  }

    private void onChangePage(WebView view, String url) {
        // 外部サイトなら特別処理省略
        if (!isInNicoVideoSite(url)) {
            return;
        }

        // 画像他なら特別処理省略
        if (mMatcherIsNotHtml.get().reset(url).find()) {
            return;
        }

        // ページ移動に備えて基本的にWebViewのcurrent URLで確認
        String urlCurrent = view.getUrl();
        if (urlCurrent == null) {
            urlCurrent = url;
        }

        String videoNumber = getVideoNumberFromUrl(urlCurrent);
        mVideoNumber = videoNumber;
        if (videoNumber != null) {
            ThumbInfo thumbInfo = mThumbInfoCacher.getThumbInfo(videoNumber);
            if (thumbInfo == null) {
                mThumbInfoCacher.loadThumbInfo(videoNumber, null);
            }

            RelatedVideoFragment relatedVideo = Util.findFragmentByTag(
                    getFragmentManager(), string.tag_related_video_fragment);
            if (relatedVideo != null && relatedVideo.isResumed()
                    && !relatedVideo.isHidden()) {
                relatedVideo.setVideoNumber(videoNumber);
            }
        }
        mJikkyoNumber = getJikkyoNumberFromUrl(urlCurrent);
//      updateStatus1();

//      if (DEBUG_LOG) {
//          CookieManager cookieManager = CookieManager.getInstance();
//          String cookie = cookieManager.getCookie(urlCurrent);
//          if (cookie != null) {
//              Log.d(LOG_TAG, "URL=" + url
//                      + " Cookie=" + cookie);
//          }
//      }

        if (mMatcherIsNicovideo.get().reset(urlCurrent).find()) {
            updateLastUrl(urlCurrent);
        }
    }

//  private void updateStatus1() {
//      StringBuilder builderStatus1 = mLabelStatus1.getTextBuilder();
//      builderStatus1.setLength(0);
//
//      if (mCookieUserSession == null) {
//          builderStatus1.append(mResStringStatus1NotLogin);
//      } else {
//          if (mWithoutFlash) {
//              String videoNumber = mVideoNumber;
//              if (videoNumber != null) {
//                  updateStatus1CacheState(builderStatus1, videoNumber);
//              } else if (mJikkyoNumber != null) {
//                  builderStatus1.append("ch: ").append(mJikkyoNumber);
//              }
//          }
//      }
//
//      mLabelStatus1.notifyUpdateText();
//  }

    private void updateStatus1CacheState(StringBuilder builderStatus1,
            String videoNumber) {
        builderStatus1.append(videoNumber).append(": ");
        boolean isFinishedCache =
            VideoLoader.isFinishedCache(videoNumber);
        boolean isSwf = videoNumber.startsWith("nm");
        boolean isFinishedCacheLow;
        if (isSwf) {
            // swfは低画質無し
            isFinishedCacheLow = false;
        } else {
            isFinishedCacheLow =
                VideoLoader.isFinishedCacheLow(videoNumber);
        }
        if (isFinishedCache && isFinishedCacheLow) {
            builderStatus1.append(mResStringStatus1CompletedCache)
                .append(mResStringStatusHighLowShort);
            return;
        }

        int cacheState = VideoCacheService.CACHE_STATE_INVALID;
        int cacheStateLow = VideoCacheService.CACHE_STATE_INVALID;
        if (mVideoCacheService != null) {
            try {
                if (!isFinishedCache) {
                    cacheState =
                        mVideoCacheService.getCacheState(
                                videoNumber, false);
                }
                if (!isSwf && !isFinishedCacheLow) {
                    cacheStateLow =
                        mVideoCacheService.getCacheState(
                                videoNumber, true);
                }
            } catch (RemoteException e) {
                Log.e(LOG_TAG, e.toString(), e);
            }
        }

        if (cacheState == VideoCacheService.CACHE_STATE_RUNNING) {
            builderStatus1.append(mResStringStatus1RunningCache);
            return;
        }
        if (cacheStateLow == VideoCacheService.CACHE_STATE_RUNNING) {
            builderStatus1.append(mResStringStatus1RunningCache)
                .append(mResStringStatusLowShort);
            return;
        }
        if (cacheState == VideoCacheService.CACHE_STATE_WAIT_START) {
            builderStatus1.append(mResStringStatus1WaitingCache);
            return;
        }
        if (cacheStateLow == VideoCacheService.CACHE_STATE_WAIT_START) {
            builderStatus1.append(mResStringStatus1WaitingCache)
                .append(mResStringStatusLowShort);
            return;
        }

        if (isSwf) {
            if (isFinishedCache) {
                builderStatus1.append(mResStringStatus1CompletedCache);
                return;
            }
        } else {
            // TODO: 低画質がそもそも存在しない動画のチェックがない
            if (isFinishedCache) {
                builderStatus1.append(mResStringStatus1CompletedCache)
                    .append(mResStringStatusHighShort);
                return;
            }
            if (isFinishedCacheLow) {
                builderStatus1.append(mResStringStatus1CompletedCache)
                    .append(mResStringStatusLowShort);
                return;
            }
        }

        builderStatus1.append(mResStringStatus1NoneCache);
        return;
    }

//  private void updateStatus2(String message) {
//      StringBuilder builderStatus2 = mLabelStatus2.getTextBuilder();
//      builderStatus2.setLength(0);
//
//      builderStatus2.append(message);
//
//      mLabelStatus2.notifyUpdateText();
//  }

    StringBuffer getRunCachingProgressMessage(StringBuffer buffer,
            int seekOffsetWrite, int contentLength) {
        return Util.getRunCachingProgressMessage(mDecimalFormatMB, buffer,
                seekOffsetWrite, contentLength);
    }

    private void cacheResourceString() {
        Resources r = getResources();
        mResStringStatusLowShort = r.getString(R.string.status_low_short);
        mResStringStatusHighShort = r.getString(R.string.status_high_short);
        mResStringStatusHighLowShort = r.getString(R.string.status_high_low_short);
//      mResStringStatus1NotLogin = r.getString(R.string.status1_not_login);
        mResStringStatus1CompletedCache = r.getString(R.string.status1_completed_cache);
        mResStringStatus1RunningCache = r.getString(R.string.status1_running_cache);
        mResStringStatus1WaitingCache = r.getString(R.string.status1_waiting_cache);
        mResStringStatus1NoneCache = r.getString(R.string.status1_none_cache);
        mResStringStatus2RunningCache = r.getString(R.string.status2_running_cache);
        mResStringStatus2WaitingCache = r.getString(R.string.status2_waiting_cache);
        mResStringStatus2StartingCache = r.getString(R.string.status2_starting_cache);
        mResStringProgressStartPlay = r.getString(R.string.progress_start_play);
        mResStringPrefKeyBrowserZoomControls = r.getString(R.string.pref_key_browser_zoom_controls);
        mResStringPrefKeyWithoutFlash = r.getString(R.string.pref_key_without_flash);
        mResStringPrefKeyShowActionButton = r.getString(R.string.pref_key_show_action_button);
    }

    /**
     * 全てのWebViewが止まるので、Player起動時のみ実行
     */
    void pauseWebView() {
        WebView webView = mWebView;
        if (webView != null) {
//            webView.stopLoading();
            webView.pauseTimers();
        }
    }

    private void startPlay(boolean forceLow) {
        mAsyncStartPlay = new AsyncStartPlay();
        mAsyncStartPlay.executeWrapper(forceLow);

        if (mProgressDialogStartPlay == null) {
            mProgressDialogStartPlay = Util.createProgressDialogLoading(
                    getActivity(), mResStringProgressStartPlay,
                    new DialogInterface.OnCancelListener() {
                        @Override
                        public void onCancel(DialogInterface dialog) {
                            if (mAsyncStartPlay != null) {
                                mAsyncStartPlay.cancel(false);
                                mAsyncStartPlay.stop();
                            }
                        }
                    });
        }
        mProgressDialogStartPlay.show();
    }
//  private void startPlay(boolean forceLow) {
//      try {
////            String url = mWebView.getOriginalUrl();
//          String url = mWebView.getUrl();
//          if (url == null) {
//              if (DEBUG_LOGD) {
//                  Log.d(LOG_TAG, "mClickListenerPlay: mWebView.getUrl() is null");
//              }
//              return;
//          }
//
////            updateCookieUserSession();
////            if (DEBUG_LOGD) {
////                Log.d(LOG_TAG, "mCookieUserSession: " + mCookieUserSession);
////            }
//
//          mMatcherVideoUrl = Util.getMatcher(mMatcherVideoUrl,
//                  PATTERN_VIDEO_URL,
//                  url);
//          String videoNumber = Util.getFirstMatch(mMatcherVideoUrl);
//          if (videoNumber == null) {
//              throw new FailPreparePlayVideoException();
//          }
//
//          if (forceLow) {
//              // 視聴履歴Cookie取り直す
//              mCookieNicoHistory = NicoroAPIManager.getCookieNicoHistory(
//                      Util.createHttpClient(),
//                      videoNumber, mCookieUserSession,
//                      forceLow, mUserAgent);
//          } else {
//              mCookieNicoHistory = Util.getCookieValueFromManager(
//                      url, "nicohistory");
//          }
//          if (DEBUG_LOGD) {
//              Log.d(LOG_TAG, "mCookieNicoHistory: " + mCookieNicoHistory);
//          }
//
//          if (mCookieUserSession == null
//                  || mUserId == null
//                  || mCookieNicoHistory == null) {
//              throw new FailPreparePlayVideoException();
//          }
//
////            mLastVideoNumber = videoNumber;
//          NicoroAPIManager.VideoPlayerIntentCreator intentCreator =
//              new NicoroAPIManager.VideoPlayerIntentCreator();
//          Intent intent = intentCreator.create(
//                  getApplicationContext(),
//                  videoNumber, mCookieUserSession, mCookieNicoHistory,
//                  mUserId, mUserAgent, forceLow);
////            Intent intent = NicoroAPIManager.createVideoPlayerIntent(
////                    getApplicationContext(),
////                    videoNumber, mCookieUserSession, mCookieNicoHistory,
////                    mUserId, mUserAgent, forceLow);
//          if (intent == null) {
//              throw new FailPreparePlayVideoException();
//          }
//          // キャッシュ処理が動作していれば停止
//          if (mVideoCacheService != null) {
//              try {
//                  mVideoCacheService.stopCache(videoNumber);
//              } catch (RemoteException e) {
//                  Log.e(LOG_TAG, e.getMessage(), e);
//              }
//          }
//          startActivityIfNeeded(intent, 0);
//      } catch (FailPreparePlayVideoException e) {
//          if (DEBUG_LOGD) {
//              Log.d(LOG_TAG, Log.buf().append("startPlay failed: mCookieUserSession=")
//                      .append(mCookieUserSession)
//                      .toString());
//          }
//          if (!NicoroAPIManager.checkIsCookieUserSessionValid(mCookieUserSession, mUserAgent)) {
//              // TODO: メールアドレス等保存するようにしたから、Cookieの自動再取得を試みるべき
//
//              // 何らかの理由でログアウト状態
//              Util.showErrorToast(getApplicationContext(), R.string.toast_play_fail_not_login);
//              // ログイン画面へ
//              loadLoginForm();
//          } else {
//              String extraMessage = e.getExtraMessage();
//              if (extraMessage == null) {
//                  // 原因不明で再生失敗
//                  extraMessage = getString(R.string.errormessage_play_fail_unknown);
//              }
//              Util.showErrorDialog(NicoroWebBrowser.this,
//                      extraMessage,
//                      false);
//          }
//      } catch (IOException e) {
//          Log.d(LOG_TAG, e.getMessage(), e);
//          Util.showErrorDialog(NicoroWebBrowser.this,
//                  e.getMessage(),
//                  false);
//      }
//  }

//  private void loadLoginForm() {
//      // ログイン画面へ
//      // TODO: ログイン後に元の動画のURLに移動しない
//      // TODO: というかこのメソッドもう使わないのでは？
//        WebView webView = mWebView;
//        if (webView != null) {
//            webView.loadUrl("https://secure.nicovideo.jp/secure/login_form");
//        }
//  }

    private void startCache(boolean forceLow) {
//      updateCookieUserSession();
//      if (DEBUG_LOGD) {
//          Log.d(LOG_TAG, "mCookieUserSession: " + mCookieUserSession);
//      }

        String videoNumber = mVideoNumber;
        if (mVideoCacheService == null) {
//          Intent intent = new Intent(getApplicationContext(), VideoCacheService.class);
            Intent intent = new Intent(IVideoCacheService.class.getName());
            ComponentName cn = mContext.startService(intent);
            if (DEBUG_LOGD) {
                if (cn != null) {
                    Log.d(LOG_TAG, Log.buf().append("IVideoCacheService starts already: ")
                            .append(cn.toString()).toString());
                }
            }

            intent = new Intent(IVideoCacheService.class.getName());
            intent.putExtra(PlayerConstants.INTENT_NAME_VIDEO_NUMBER,
                    videoNumber);
            intent.putExtra(VideoCacheService.INTENT_NAME_COOKIE_USER_SESSION,
                    mCookieUserSession);
            intent.putExtra(PlayerConstants.INTENT_NAME_FORCE_LOW,
                    forceLow);
            boolean bindResult = mContext.bindService(intent,
                    mVideoCacheServiceConnection, Context.BIND_AUTO_CREATE);
//          if (DEBUG_LOGD) {
//              Log.d(LOG_TAG, "bindResult=" + bindResult);
//          }
            if (bindResult) {
//              updateStatus1();
            } else {
                Util.showErrorToast(mContext, R.string.toast_cache_fail_bind);
            }
        } else {
            try {
                mVideoCacheService.addStartCache(videoNumber,
                        forceLow, mCookieUserSession);
//              updateStatus1();
            } catch (RemoteException e) {
                Log.e(LOG_TAG, e.toString(), e);
                Util.showErrorToast(mContext, R.string.toast_cache_fail_bind);
            }
        }
    }

    private void startJikkyo(String number) {
        try {
            // TODO Intentの引数に使わないパラメータがある
            Intent intent = NicoroAPIManager.createJikkyoPlayerIntent(
                    mContext,
                    number, mCookieUserSession, mCookieNicoHistory,
                    mUserId, mUserAgent)
                .addCategory(Intent.CATEGORY_BROWSABLE);
            startActivity(intent);
            pauseWebView();
        } catch (FailPreparePlayVideoException e) {
        }
    }

    private void startLive(final String number) {
        boolean warning = mSharedPreferences.getBoolean(
                mContext.getString(R.string.pref_key_warning_live_play), true);
        if (warning) {
            DialogInterface.OnClickListener onClickListener =
                new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    switch (which) {
                        case DialogInterface.BUTTON_POSITIVE:
//                            dialog.dismiss();
                            startLiveImpl(number);
                            break;
                        case DialogInterface.BUTTON_NEGATIVE:
//                            dialog.dismiss();
                            break;
                        default:
                            assert false : which;
                            break;
                    }
                }
            };
            DialogInterface.OnCancelListener onCancelListener =
                new DialogInterface.OnCancelListener() {
                @Override
                public void onCancel(DialogInterface dialog) {
//                    dialog.dismiss();
                }
            };
            Activity activity = getActivity();
            LayoutInflater inflater = Util.getInflaterForDialog(activity);
            // LayoutParams生成のためダミーのViewも使用
            View confirmPlayLive = inflater.inflate(
                    R.layout.confirm_play_live, new FrameLayout(activity), false);
            CheckBox dontShow = Util.findViewById(confirmPlayLive,
                    R.id.dont_show_this_dialog);
            dontShow.setChecked(!warning);
            dontShow.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                @Override
                public void onCheckedChanged(CompoundButton buttonView,
                        boolean isChecked) {
                    SharedPreferences.Editor editor = mSharedPreferences.edit();
                    editor.putBoolean(getString(R.string.pref_key_warning_live_play),
                            !isChecked);
                    editor.commit();
                }
            });
            new AlertDialog.Builder(activity)
                .setTitle(R.string.confirm)
                .setView(confirmPlayLive)
                .setCancelable(true)
                .setPositiveButton(android.R.string.yes, onClickListener)
                .setNegativeButton(android.R.string.cancel, onClickListener)
                .setOnCancelListener(onCancelListener)
                .show();
        } else {
            startLiveImpl(number);
        }
    }
    private void startLiveImpl(String number) {
        // TODO 生放送情報をAPIで取ると途中までしか取れないため、htmlのソース内から取得
        // →まだ完全に読み込み終わっていないときに実行したら取得できないかも
        WebView webView = mWebView;
        String title = null;
        if (webView != null) {
            title = webView.getTitle();
            Matcher matcher = Pattern.compile(PATTERN_GET_TITLE).matcher(title);
            if (matcher.find()) {
                title = matcher.group(1);
            }
        }
        String description = mJsObj.streamDescription;
        try {
            // TODO Intentの引数に使わないパラメータがある
            Intent intent = NicoroAPIManager.createLivePlayerIntent(
                    mContext,
                    number, mCookieUserSession,
                    title, description,
                    mCookieNicoHistory,
                    mUserId, mUserAgent)
                .addCategory(Intent.CATEGORY_BROWSABLE);
            startActivity(intent);
            pauseWebView();
        } catch (FailPreparePlayVideoException e) {
        }
    }

//    private void relatedVideo() {
//        String videoNumber = mVideoNumber;
//        Intent intent = new Intent(mContext,
//                RelatedVideoActivity.class);
//        intent.putExtra(RelatedVideoActivity.INTENT_EXTRA_VIDEO_NUMBER,
//                videoNumber);
//        startActivity(intent);
//    }

    private void deleteCache() {
        new AlertDialog.Builder(getActivity())
            .setMessage(R.string.confirm_delete_cache_one)
            .setCancelable(true)
            .setPositiveButton(android.R.string.yes,
                    new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    final String videoNumber = mVideoNumber;
                    if (videoNumber == null) {
                        assert false;
                        Util.showErrorToast(mContext,
                                R.string.toast_delete_cache_one_fail);
                    } else {
                        new AsyncTask<Void, Void, Void>() {
                            private ProgressDialog progressDialog;

                            @Override
                            protected void onPreExecute() {
                                progressDialog = Util.createProgressDialogLoading(
                                        getActivity(),
                                        R.string.progress_delete_cache_one, null);
                                progressDialog.show();
                            }
                            @Override
                            protected Void doInBackground(Void... params) {
                                // キャッシュ処理が動作していれば停止
                                if (mVideoCacheService != null) {
                                    try {
                                        mVideoCacheService.stopCache(videoNumber);
                                        mVideoCacheService.clearNotification(videoNumber);
                                    } catch (RemoteException e) {
                                        Log.e(LOG_TAG, e.toString(), e);
                                    }
                                }
                                VideoLoader.deleteCacheFile(videoNumber);
                                return null;
                            }
                            @Override
                            protected void onPostExecute(Void result) {
                                // XXX dismissでIllegalArgumentExceptionのエラーレポートが出たがどういうタイミングで起きるのか？
                                // →dismissする前にonDestory起きたとき？onCreateDialog使った方がいいか？
                                progressDialog.dismiss();
                                String toast = mContext.getString(R.string.toast_delete_cache_one,
                                        videoNumber);
                                Util.showInfoToast(mContext, toast);
                                // キャッシュ終了と同じ扱いで表示更新
                                mHandler.sendEmptyMessage(MSG_ID_FINISHED_CACHE);
                            }
                        }.execute();
                    }
                }
            })
            .setNegativeButton(android.R.string.no, null)
            .show();
    }

//    private void accessHistory() {
//        Intent intent = new Intent(getApplicationContext(),
//                AccessHistoryActivity.class);
//        startActivity(intent);
//    }

    private void addMylist() {
        try {
            WebView webView = mWebView;
            if (webView != null) {
                final String videoNumber = mVideoNumber;
                if (videoNumber != null) {
                    URL currentUrl = new URL(webView.getUrl());
                    String host = currentUrl.getHost();
                    if ("sp.nicovideo.jp".equals(host)) {
                        webView.loadUrl("javascript:window.startToAddMylist();");
                    } else {
                        StringBuilder builder = new StringBuilder(
                                "javascript:window.open(\"http://")
                            .append(host).append("/mylist_add/video/")
                            .append(videoNumber).append("\", \"_blank\");");
                        webView.loadUrl(builder.toString());
                    }
                }
            }
        } catch (MalformedURLException e) {
            Log.e(LOG_TAG, e.toString(), e);
        }
    }

    private void viewRss() {
        URL rss = getRssUrl();
        if (rss != null) {
            try {
                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setDataAndType(Uri.parse(rss.toExternalForm()),
                        "application/rss+xml");
                startActivity(intent);
                return;
            } catch (ActivityNotFoundException e) {
                Log.e(LOG_TAG, e.toString(), e);
            }
        }
        Util.showErrorToast(mContext,
                R.string.toast_rss_fail);
    }

    private void shareRss() {
        URL rss = getRssUrl();
        if (rss != null) {
            try {
                Intent intent = new Intent(Intent.ACTION_SEND);
                intent.putExtra(Intent.EXTRA_TEXT, rss.toExternalForm());
                intent.setType("text/plain");
                intent = Intent.createChooser(intent, null);
                startActivity(intent);
                return;
            } catch (ActivityNotFoundException e) {
                Log.e(LOG_TAG, e.toString(), e);
            }
        }
        Util.showErrorToast(mContext,
                R.string.toast_rss_fail);
    }

    private void shareUrl() {
        WebView webView = mWebView;
        String url = (webView == null ? null : webView.getUrl());
        if (url != null) {
            Intent intent = new Intent(Intent.ACTION_SEND);
            intent.putExtra(Intent.EXTRA_TEXT, url);
            intent.setType("text/plain");
            intent = Intent.createChooser(intent, null);
            startActivity(intent);
        }
    }

    private void showListMenu(WebView webView, Integer defaultListRadioId) {
//        // TODO Fragment対応のためIntentとは限らなくなる
//        Intent intent = new Intent(mContext, ListMenuActivity.class)
//            .setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
//        if (webView == null) {
//            Util.showErrorToast(mContext, R.string.toast_webview_not_ready);
//        } else {
//            intent.putExtra(ListMenuActivity.INTENT_EXTRA_BOOKMARKS_ADD_TITLE,
//                    webView.getTitle());
//            intent.putExtra(ListMenuActivity.INTENT_EXTRA_BOOKMARKS_ADD_URL,
//                    webView.getUrl());
//        }
//        String videoNumber = mVideoNumber;
//        if (videoNumber != null) {
//            intent.putExtra(ListMenuActivity.INTENT_EXTRA_VIDEO_NUMBER,
//                    videoNumber);
//        }
//        if (defaultListRadioId != null) {
//            intent.putExtra(ListMenuActivity.INTENT_EXTRA_DEFAULT_LIST_RADIO,
//                    defaultListRadioId.intValue());
//        }
//        startActivity(intent);

        if (mListMenuStarter != null) {
            Bundle bundle = new Bundle();
            if (webView == null) {
                Util.showErrorToast(mContext, R.string.toast_webview_not_ready);
            } else {
                bundle.putString(ListMenuActivity.INTENT_EXTRA_BOOKMARKS_ADD_TITLE,
                        webView.getTitle());
                bundle.putString(ListMenuActivity.INTENT_EXTRA_BOOKMARKS_ADD_URL,
                        webView.getUrl());
            }
            String videoNumber = mVideoNumber;
            if (videoNumber != null) {
                bundle.putString(ListMenuActivity.INTENT_EXTRA_VIDEO_NUMBER,
                        videoNumber);
            }
            if (defaultListRadioId != null) {
                bundle.putInt(ListMenuActivity.INTENT_EXTRA_DEFAULT_LIST_RADIO,
                        defaultListRadioId.intValue());
            }
            mListMenuStarter.sendMessageSuccess(bundle);
        }
    }

    private String getVideoNumberFromUrl(String url) {
        return getVideoNumberFromUrl(mMatcherVideoUrl.get(), url);
    }
    static String getVideoNumberFromUrl(Matcher matcher, String url) {
        matcher.reset(url);
        if (matcher.find()) {
            return matcher.group(1);
        } else {
            return null;
        }
    }
    static String getVideoNumberFromUrl(ReuseMatcher matcher, String url) {
        return matcher.reset(url).groupIfFind(1);
    }

    private String getJikkyoNumberFromUrl(String url) {
        Matcher matcher = mMatcherJikkyoUrl.get().reset(url);
        if (matcher.find()) {
            return matcher.group(1);
        } else {
            return null;
        }
    }

    private String getLiveNumberFromUrl(String url) {
        Matcher matcher = mMatcherLiveUrl.get().reset(url);
        if (matcher.find()) {
            return matcher.group(1);
        } else {
            return null;
        }
    }

//  private void showBookmark() {
//      Intent intent = new Intent(getApplicationContext(), Bookmarks.class);
//      WebView webView = mWebView;
//      if (webView != null) {
//          intent.putExtra(Bookmarks.INTENT_EXTRA_TITLE, webView.getTitle());
//          intent.putExtra(Bookmarks.INTENT_EXTRA_URL, webView.getUrl());
//      } else {
//          Util.showErrorToast(getApplicationContext(), R.string.toast_webview_not_ready);
//      }
//      startActivityIfNeeded(intent, 0);
//  }

//  private void reflectIsCookieUserSessionValid(boolean result) {
//        if (result) {
//          // 前回保存時のuser session Cookieを有効化
//          mMatcherGetUserID = Util.getMatcher(mMatcherGetUserID,
//                  PATTERN_GET_USERID_FROM_USERSESSION,
//                  mCookieUserSession);
//          mUserId = Util.getFirstMatch(mMatcherGetUserID);
////            mCookieManager.setCookie("nicovideo.jp", mCookieUserSession);
//        } else {
//          mCookieUserSession = null;
//          mUserId = null;
//          // FIXME CookieManagerでは特定のCookieを削除することはできない
//          // →WebViewDatabaseの実装を参考にdbファイル直接編集するしかない？
////            cookieManager.setCookie("nicovideo.jp", "user_session=");
//        }
//  }

    private void updateCookieUserSession() {
        mCookieUserSession = mSharedPreferences.getString(
                NicoroConfig.COOKIE_USER_SESSION, null);
        mCookieUserSpSession = mSharedPreferences.getString(
                NicoroConfig.COOKIE_USER_SP_SESSION, null);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("updateCookieUserSession: mCookieUserSession=")
                    .append(mCookieUserSession)
                    .append(" mCookieUserSpSession=").append(mCookieUserSpSession)
                    .toString());
        }
        setCookieNicovideo(mCookieUserSession);
        setCookieNicovideoSp(mCookieUserSpSession);
        if (mCookieUserSession != null) {
            mUserId = Util.getFirstMatch(
                    mMatcherGetUserID.get().reset(mCookieUserSession));
        }
    }

    private void setCookieNicovideo(String value) {
        // Android3.0は先頭に.が無いと認識せず、Android2.1は先頭に.があると認識しない
        mCookieManager.setCookie("nicovideo.jp", value);
        mCookieManager.setCookie(".nicovideo.jp", value);
        // 公式短縮URLにも設定しないとCookieがうまく引き継がれない模様
        mCookieManager.setCookie("nico.ms", value);
    }

    private void setCookieNicovideoSp(String value) {
        mCookieManager.setCookie("sp.live.nicovideo.jp", value);
        mCookieManager.setCookie(".sp.live.nicovideo.jp", value);
    }

    public boolean goBackWebView() {
        WebView webView = mWebView;
        if (webView == null) {
            return false;
        }
        if (webView.canGoBack()) {
            webView.goBack();
            return true;
        }
        WebView lastWebView;
        if (mWebViewPool.isEmpty()) {
            return false;
        }
        lastWebView = mWebViewPool.removeLast();
        Util.replaceView(webView, lastWebView);
        mWebView = lastWebView;
        String url = lastWebView.getUrl();
        updateLastUrl(url);
        webView.destroy();
        onChangePage(lastWebView, url);
        return true;
    }

    private void updateLastUrl(String url) {
        if (!TextUtils.equals(mLastUrl, url)) {
            SharedPreferences.Editor editor = mSharedPreferences.edit();
            editor.putString(NicoroConfig.LAST_URL, url);
            editor.commit();
            mLastUrl = url;
        }
    }

    public static boolean isInNicoVideoSite(String url) {
        try {
            URL urlParse = new URL(url);
            String host = urlParse.getHost();
            String path = urlParse.getPath();
            if (host.equals("nico.ms")) {
                return true;
//            } else if (host.indexOf("nicoseiga.jp") >= 0) {
//                return true;
            } else if (host.indexOf("nicovideo.jp") < 0
                    || host.equals("rd.nicovideo.jp")
                    || host.equals("ads.nicovideo.jp")) {
                if (DEBUG_LOGV) {
                    Log.v(LOG_TAG, Log.buf().append("Outside url=")
                            .append(url).toString());
                }
                return false;
            } else if (host.equals("seiga.nicovideo.jp")
                    && path.startsWith("/image/source")) {
                if (DEBUG_LOGV) {
                    Log.v(LOG_TAG, Log.buf().append("Outside url=")
                            .append(url).toString());
                }
                return false;
            } else {
                return true;
            }
        } catch (MalformedURLException e) {
            Log.e(LOG_TAG, e.toString(), e);
            // XXX とりあえずtrue扱い
            return true;
        }
    }

    private void updateWithoutFlash() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.FROYO) {
            boolean flag = !mWithoutFlash;
            if (mWebView != null) {
                APILevelUtil8.webSettingsSetPluginsEnabled(mWebView.getSettings(), flag);
            }
            for (WebView wv : mWebViewPool) {
                APILevelUtil8.webSettingsSetPluginsEnabled(wv.getSettings(), flag);
            }
        } else {
            boolean flag = !mWithoutFlash;
            if (mWebView != null) {
                APILevelUtil4.webSettingsSetPluginsEnabled(mWebView.getSettings(), flag);
            }
            for (WebView wv : mWebViewPool) {
                APILevelUtil4.webSettingsSetPluginsEnabled(wv.getSettings(), flag);
            }
        }
    }

    private void updateShowActionButton() {
        int visibility;
        if (mShowActionButton) {
            visibility = View.VISIBLE;
        } else {
            visibility = View.GONE;
        }
        mButtonAction.setVisibility(visibility);
    }

//  private final Runnable mActionPlay = new Runnable() {
//      @Override
//      public void run() {
//            if (mWithoutFlash) {
//                startPlay(false);
//            }
//      }
//  };
//  private final Runnable mActionPlayLow = new Runnable() {
//      @Override
//      public void run() {
//            if (mWithoutFlash) {
//                startPlay(true);
//            }
//      }
//  };
//  private final Runnable mActionCache = new Runnable() {
//      @Override
//      public void run() {
//            if (mWithoutFlash) {
//                startCache(false);
//            }
//      }
//  };
//  private final Runnable mActionCacheLow = new Runnable() {
//      @Override
//      public void run() {
//            if (mWithoutFlash) {
//                startCache(true);
//            }
//      }
//  };
//  private final Runnable mActionJikkyo = new Runnable() {
//      @Override
//      public void run() {
//          startJikkyo(mJikkyoNumber);
//      }
//  };
//    private final Runnable mActionLive = new Runnable() {
//        @Override
//        public void run() {
//            if (mWithoutFlash) {
//                startLive(mLiveNumber);
//            }
//        }
//    };
//  private final Runnable mActionLogin = new Runnable() {
//      @Override
//      public void run() {
//          loadLoginForm();
//      }
//  };
//  private final Runnable mActionAddBookmark = new Runnable() {
//      @Override
//      public void run() {
//          String title = null;
//          String url = null;
//          WebView webView = mWebView;
//          if (webView != null) {
//              title = webView.getTitle();
//              url = webView.getUrl();
//          }
//          if (title == null) {
//              title = "";
//          }
//          if (url == null) {
//              url = "";
//          }
//          Bookmarks.addBookmark(NicoroWebBrowser.this, title, url);
//      }
//  };
//  private final Runnable mActionHelp = new Runnable() {
//      @Override
//      public void run() {
//          startActivityIfNeeded(
//                  new Intent(getApplicationContext(), NicoroHelp.class),
//                  0);
//      }
//  };
//  private final Runnable mActionShowBookmark = new Runnable() {
//      @Override
//      public void run() {
//          showBookmark();
//      }
//  };
//  private final Runnable mActionRelatedVideo = new Runnable() {
//      @Override
//      public void run() {
//          relatedVideo();
//      }
//  };
//  private final Runnable mActionViewRss = new Runnable() {
//      @Override
//      public void run() {
//          viewRss();
//      }
//  };
//  private final Runnable mActionShareRss = new Runnable() {
//      @Override
//      public void run() {
//          shareRss();
//      }
//  };
    private URL getRssUrl() {
        WebView webView = mWebView;
        if (webView == null) {
            Log.e(LOG_TAG, "getRssUrl: webView is null");
            return null;
        }
        String url = webView.getUrl();
        if (url == null) {
            Log.e(LOG_TAG, "getRssUrl: mWebView.getUrl() return null");
            return null;
        }
        String urlRss = mJsObj.urlRss;
        if (urlRss == null) {
            Log.e(LOG_TAG, "getRssUrl: mJsObj.urlRss is null");
            assert false;
            return null;
        }
        try {
            URL forParse = new URL(url);
            return new URL(forParse.getProtocol(),
                    forParse.getHost(), urlRss);
        } catch (MalformedURLException e) {
            Log.e(LOG_TAG, e.toString(), e);
            return null;
        }
    }

//  private final Runnable mActionDeleteCache = new Runnable() {
//      @Override
//      public void run() {
//          deleteCache();
//      }
//  };
//
//    private final Runnable mActionAccessHistory = new Runnable() {
//        @Override
//        public void run() {
//            accessHistory();
//        }
//    };

//  private void startAction() {
//      final int listCapacity = 3;
//      final ArrayList<String> items = new ArrayList<String>(listCapacity);
//      final ArrayList<Runnable> runs = new ArrayList<Runnable>(listCapacity);
//
//      String newVideoNumber = null;
//        String newJikkyoNumber = null;
//        String newLiveNumber = null;
//
//      String url = null;
//      WebView webView = mWebView;
//      if (webView != null) {
//          url = webView.getUrl();
//      }
//
//      Resources res = getResources();
//      if (mCookieUserSession == null) {
//          // 非ログイン状態
//          // XXX nullでなくともログインしていない場合が
//          items.add(res.getString(R.string.action_item_login));
//          runs.add(mActionLogin);
//      } else if (url != null) {
//          newVideoNumber = getVideoNumberFromUrl(url);
//          if (newVideoNumber != null) {
//              if (mWithoutFlash) {
//                  // TODO この取り方だとタイミング的にちょっと甘い
//                  ThumbInfo thumbInfo = mThumbInfoCacher.getThumbInfo(newVideoNumber);
//                  final boolean hasLow = ((thumbInfo == null)
//                          ? true : thumbInfo.getSizeLow() > 0);
//
//                  // 動画
//                  final boolean isSwf = NicoroAPIManager.isVideoNumberSwf(newVideoNumber);
//                  if (isSwf) {
//                      // swf動画
//                      items.add(res.getString(R.string.action_item_play_swf));
//                      runs.add(mActionPlay);
//                  } else {
//                      // flvまたはmp4動画
//                      items.add(res.getString(R.string.action_item_play_normal));
//                      runs.add(mActionPlay);
//                      if (hasLow) {
//                          items.add(res.getString(R.string.action_item_play_normal_low));
//                          runs.add(mActionPlayLow);
//                      }
//                  }
//
//                  if (isCacheNeeded(newVideoNumber)) {
//                      items.add(res.getString(R.string.action_item_cache));
//                      runs.add(mActionCache);
//                  }
//                  if (!isSwf && hasLow) {
//                      if (isCacheNeededLow(newVideoNumber)) {
//                          items.add(res.getString(R.string.action_item_cache_low));
//                          runs.add(mActionCacheLow);
//                      }
//                  }
//              }
//
//              items.add(res.getString(R.string.action_item_related_video));
//              runs.add(mActionRelatedVideo);
//
//              if (VideoLoader.hasAnyCacheFile(newVideoNumber)) {
//                  items.add(res.getString(R.string.action_item_delete_cache_one));
//                  runs.add(mActionDeleteCache);
//              }
//          }
//
//          newJikkyoNumber = getJikkyoNumberFromUrl(url);
//          if (newJikkyoNumber != null) {
//              items.add(res.getString(R.string.action_item_jikkyo));
//              runs.add(mActionJikkyo);
//          }
//
//            if (mWithoutFlash) {
//              newLiveNumber = getLiveNumberFromUrl(url);
//              if (newLiveNumber != null) {
//                    items.add(res.getString(R.string.action_item_live));
//                    runs.add(mActionLive);
//              }
//            }
//      }

//      items.add(res.getString(R.string.action_item_add_bookmark));
//      runs.add(mActionAddBookmark);
//
//      items.add(res.getString(R.string.action_item_show_bookmark));
//      runs.add(mActionShowBookmark);
//
//      if (mJsObj.urlRss != null) {
//          items.add(res.getString(R.string.action_item_view_rss));
//          runs.add(mActionViewRss);
//          items.add(res.getString(R.string.action_item_share_rss));
//          runs.add(mActionShareRss);
//      }
//
//      items.add(res.getString(R.string.action_item_access_history));
//      runs.add(mActionAccessHistory);
//
//      items.add(res.getString(R.string.action_item_help));
//      runs.add(mActionHelp);
//
//      DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener() {
//          @Override
//          public void onClick(DialogInterface dialog, int which) {
//              runs.get(which).run();
//          }
//      };
//      Util.showListDialog(this, res.getString(R.string.dialog_title_action),
//              items.toArray(new String[items.size()]), listener);
//
//        mVideoNumber = newVideoNumber;
//        mJikkyoNumber = newJikkyoNumber;
//        mLiveNumber = newLiveNumber;
//  }

    private boolean isCacheNeeded(String videoNumber) {
        if (VideoLoader.isFinishedCache(videoNumber)) {
            return false;
        } else {
            if (mVideoCacheService == null) {
                // サービスが（まだ）見つからないなら、キャッシュ起動のアイテムは表示する
                return true;
            } else {
                try {
                    final int cacheState = mVideoCacheService.getCacheState(
                            videoNumber, false);
                    if (cacheState == VideoCacheService.CACHE_STATE_NOT_RUN) {
                        return true;
                    } else {
                        return false;
                    }
                } catch (RemoteException e) {
                    Log.e(LOG_TAG, e.toString(), e);
                    return true;
                }
            }
        }
    }

    private boolean isCacheNeededLow(String videoNumber) {
        if (VideoLoader.isFinishedCacheLow(videoNumber)) {
            return false;
        } else {
            if (mVideoCacheService == null) {
                // サービスが（まだ）見つからないなら、キャッシュ起動のアイテムは表示する
                return true;
            } else {
                try {
                    final int cacheState = mVideoCacheService.getCacheState(
                            videoNumber, true);
                    if (cacheState == VideoCacheService.CACHE_STATE_NOT_RUN) {
                        return true;
                    } else {
                        return false;
                    }
                } catch (RemoteException e) {
                    Log.e(LOG_TAG, e.toString(), e);
                    return true;
                }
            }
        }
    }

    public String getWebTitle() {
        WebView webView = mWebView;
        if (webView == null) {
            return null;
        } else {
            return mWebView.getTitle();
        }
    }
    public String getWebUrl() {
        WebView webView = mWebView;
        if (webView == null) {
            return null;
        } else {
            return mWebView.getUrl();
        }
    }

    public String getVideoNumber() {
        String url = getWebUrl();
        if (url == null) {
            return null;
        } else {
            String videoNumber = getVideoNumberFromUrl(url);
            return videoNumber;
        }
    }

    // メニュー関連

    private static class OptionsMenuItem {
        MenuItem flashSetPos;
        MenuItem flashMatchFull;
        MenuItem viewRss;
        MenuItem shareRss;
        MenuItem video;
        MenuItem playNormal;
        MenuItem playLow;
        MenuItem cacheNormal;
        MenuItem cacheLow;
        MenuItem deleteCache;
        MenuItem relatedVideo;
        MenuItem addMylist;
        MenuItem jikkyo;
        MenuItem live;
    }
    private OptionsMenuItem mOptionsMenuItem;

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        // TODO マルチペインなら他のFragmentのMenuと合わせて表示
        inflater.inflate(R.menu.nicoro_webbrowser_menu, menu);
        if (mOptionsMenuItem == null) {
            mOptionsMenuItem = new OptionsMenuItem();
        }
        mOptionsMenuItem.flashSetPos = menu.findItem(R.id.menu_flash_set_pos);
        mOptionsMenuItem.flashMatchFull = menu.findItem(R.id.menu_flash_match_full);
        mOptionsMenuItem.viewRss = menu.findItem(R.id.menu_view_rss);
        mOptionsMenuItem.shareRss = menu.findItem(R.id.menu_share_rss);
        mOptionsMenuItem.video = menu.findItem(R.id.menu_video);
        mOptionsMenuItem.playNormal = menu.findItem(R.id.menu_play_normal);
        mOptionsMenuItem.playLow = menu.findItem(R.id.menu_play_low);
        mOptionsMenuItem.cacheNormal = menu.findItem(R.id.menu_cache_normal);
        mOptionsMenuItem.cacheLow = menu.findItem(R.id.menu_cache_low);
        mOptionsMenuItem.deleteCache = menu.findItem(R.id.menu_delete_cache);
        mOptionsMenuItem.relatedVideo = menu.findItem(R.id.menu_related_video);
        mOptionsMenuItem.addMylist = menu.findItem(R.id.menu_add_mylist);
        mOptionsMenuItem.jikkyo = menu.findItem(R.id.menu_jikkyo);
        mOptionsMenuItem.live = menu.findItem(R.id.menu_live);
    }

    @Override
    public void onPrepareOptionsMenu(Menu menu) {
        updateOptionsMenu();
    }

    void updateOptionsMenu() {
        if (mOptionsMenuItem == null) {
            return;
        }
        // TODO マルチペインなら他のFragmentのMenuと合わせて表示
        boolean enableFlashMenu = !mWithoutFlash;
        mOptionsMenuItem.flashSetPos.setEnabled(enableFlashMenu);
        mOptionsMenuItem.flashMatchFull.setEnabled(enableFlashMenu);

        boolean enableRssMenu = (mJsObj.urlRss != null);
        mOptionsMenuItem.viewRss.setEnabled(enableRssMenu);
        mOptionsMenuItem.shareRss.setEnabled(enableRssMenu);

        boolean enablePlayNormal = false;
        boolean enablePlayLow = false;
        boolean enableCacheNormal = false;
        boolean enableCacheLow = false;
        boolean enableDeleteCache = false;
        boolean enableRelatedVideo = false;
        boolean enableAddMylist = false;
        boolean enableJikkyo = false;
        boolean enableLive = false;
        String newVideoNumber = null;
        String newJikkyoNumber = null;
        String newLiveNumber = null;

        String url = null;
        WebView webView = mWebView;
        if (webView != null) {
            url = webView.getUrl();
        }
        if (url != null) {
            newVideoNumber = getVideoNumberFromUrl(url);
            if (newVideoNumber != null) {
                if (mWithoutFlash) {
                    // XXX この取り方だとタイミング的にちょっと甘い
                    ThumbInfo thumbInfo = mThumbInfoCacher.getThumbInfo(newVideoNumber);
                    final boolean hasLow = ((thumbInfo == null)
                            ? true : thumbInfo.getSizeLow() > 0);
                    // 動画
                    final boolean isSwf = NicoroAPIManager.isVideoNumberSwf(newVideoNumber);
                    if (isSwf) {
                        // swf動画
                        enablePlayNormal = true;
                    } else {
                        // flvまたはmp4動画
                        enablePlayNormal = true;
                        if (hasLow) {
                            enablePlayLow = true;
                        }
                    }

                    if (isCacheNeeded(newVideoNumber)) {
                        enableCacheNormal = true;
                    }
                    if (!isSwf && hasLow && isCacheNeededLow(newVideoNumber)) {
                        enableCacheLow = true;
                    }
                }

                enableRelatedVideo = true;
                enableAddMylist = true;

                if (VideoLoader.hasAnyCacheFile(newVideoNumber)) {
                    enableDeleteCache = true;
                }
            }

            newJikkyoNumber = getJikkyoNumberFromUrl(url);
            if (newJikkyoNumber != null) {
                enableJikkyo = true;
            }

            if (mWithoutFlash) {
                newLiveNumber = getLiveNumberFromUrl(url);
                if (newLiveNumber != null) {
                    enableLive = true;
                }
            }
        }

        boolean enableVideoMenu = (enablePlayNormal || enablePlayLow
                || enableCacheNormal || enableCacheLow
                || enableDeleteCache || enableRelatedVideo || enableAddMylist
                || enableJikkyo || enableLive);
        mOptionsMenuItem.video.setEnabled(enableVideoMenu);

        boolean visibleNormalVideo = (enablePlayNormal || enablePlayLow
                || enableCacheNormal || enableCacheLow
                || enableDeleteCache || enableRelatedVideo || enableAddMylist);

        mOptionsMenuItem.playNormal.setEnabled(enablePlayNormal)
            .setVisible(visibleNormalVideo);
        mOptionsMenuItem.playLow.setEnabled(enablePlayLow)
            .setVisible(enablePlayLow);
        mOptionsMenuItem.cacheNormal.setEnabled(enableCacheNormal)
            .setVisible(visibleNormalVideo);
        mOptionsMenuItem.cacheLow.setEnabled(enableCacheLow)
            .setVisible(enableCacheLow);
        mOptionsMenuItem.deleteCache.setEnabled(enableDeleteCache)
            .setVisible(visibleNormalVideo);
        mOptionsMenuItem.relatedVideo.setEnabled(enableRelatedVideo)
            .setVisible(visibleNormalVideo);
        mOptionsMenuItem.addMylist.setEnabled(enableAddMylist)
            .setVisible(visibleNormalVideo);

        mOptionsMenuItem.jikkyo.setEnabled(enableJikkyo)
            .setVisible(enableJikkyo);
        mOptionsMenuItem.live.setEnabled(enableLive)
            .setVisible(enableLive);

        mVideoNumber = newVideoNumber;
        mJikkyoNumber = newJikkyoNumber;
        mLiveNumber = newLiveNumber;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        Intent intent;
        WebView webView = mWebView;
        switch (item.getItemId()) {
            case R.id.menu_top:
                if (webView != null) {
                    webView.loadUrl("http://www.nicovideo.jp/");
                }
                return true;
            case R.id.menu_reload:
                if (webView != null) {
                    webView.reload();
                }
                return true;
            case R.id.menu_config:
                intent = new Intent(mContext, NicoroConfig.class);
                startActivity(intent);
                return true;
            case R.id.menu_help:
                intent = new Intent(mContext, NicoroHelp.class);
                startActivity(intent);
                return true;
            case R.id.menu_exit:
                getActivity().finish();
                return true;
            case R.id.menu_view:
                // none
                return false;
            case R.id.menu_video:
                // none
                return false;
//          case R.id.menu_more:
//              // none
//              return false;
            case R.id.menu_clear_cache:
                new AlertDialog.Builder(getActivity())
                    .setTitle(R.string.menu_clear_cache)
                    .setMessage(R.string.confirm_clear_cache)
                    .setCancelable(true)
                    .setPositiveButton(android.R.string.yes,
                            new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            new AsyncTask<Void, Void, Void>() {
                                private ProgressDialog progressDialog;

                                @Override
                                protected void onPreExecute() {
                                    progressDialog = Util.createProgressDialogLoading(
                                            getActivity(),
                                            R.string.progress_clear_cache, null);
                                    progressDialog.show();
                                }
                                @Override
                                protected Void doInBackground(Void... params) {
                                    VideoLoader.deleteAllCacheFile();
                                    return null;
                                }
                                @Override
                                protected void onPostExecute(Void result) {
                                    progressDialog.dismiss();
                                }
                            }.execute();
                        }
                    })
                    .setNegativeButton(android.R.string.no, null)
                    .show();
                return true;
            case R.id.menu_bookmarks:
//                showBookmark();
                showListMenu(webView, R.id.radio_bookmarks);
                return true;
            case R.id.menu_zoom_in:
                if (webView != null) {
                    webView.zoomIn();
                }
                break;
            case R.id.menu_zoom_out:
                if (webView != null) {
                    webView.zoomOut();
                }
                break;
            case R.id.menu_flash_set_pos:
                if (webView != null) {
                    mJsObj.msgIdGetOffsetFlvplayerContainer = MSG_ID_FLASH_SET_POS;
                    webView.loadUrl(mResJsGetOffsetFlvplayerContainer);
                }
                return true;
            case R.id.menu_flash_match_full:
                if (webView != null) {
                    mJsObj.msgIdGetOffsetFlvplayerContainer = MSG_ID_FLASH_MATCH_FULL;
                    webView.loadUrl(mResJsGetOffsetFlvplayerContainer);
                }
                return true;
//            case R.id.menu_access_history:
//                accessHistory();
//                return true;
            case R.id.menu_play_normal:
                startPlay(false);
                return true;
            case R.id.menu_play_low:
                startPlay(true);
                return true;
            case R.id.menu_cache_normal:
                startCache(false);
                return true;
            case R.id.menu_cache_low:
                startCache(true);
                return true;
            case R.id.menu_delete_cache:
                deleteCache();
                return true;
            case R.id.menu_related_video:
//                relatedVideo();
                showListMenu(webView, R.id.radio_related_video);
                return true;
            case R.id.menu_add_mylist:
                addMylist();
                return true;
            case R.id.menu_live:
                startLive(mLiveNumber);
                return true;
            case R.id.menu_jikkyo:
                startJikkyo(mJikkyoNumber);
                return true;
            case R.id.menu_view_rss:
                viewRss();
                return true;
            case R.id.menu_share_rss:
                shareRss();
                return true;
            case R.id.menu_share_url:
                shareUrl();
                return true;
            case R.id.menu_go_back:
                if (webView != null) {
                    webView.goBack();
                }
                return true;
            case R.id.menu_go_forward:
                if (webView != null) {
                    webView.goForward();
                }
                return true;
            case R.id.menu_search:
                getActivity().onSearchRequested();
                return true;
            case R.id.menu_list_menu:
                showListMenu(webView, null);
                return true;
            case R.id.menu_page_info:
                if (webView != null) {
                    FragmentManager manager = getFragmentManager();
                    FragmentTransaction transaction = manager.beginTransaction();
                    Fragment prev = manager.findFragmentByTag("dialog");
                    if (prev != null) {
                        transaction.remove(prev);
                    }
                    transaction.addToBackStack(null);

                    String cacheInfo;
                    if (mWithoutFlash) {
                        String videoNumber = mVideoNumber;
                        if (videoNumber == null) {
                            cacheInfo = null;
                        } else {
                            StringBuilder builder = new StringBuilder();
                            // TODO メソッド名変更すべき
                            updateStatus1CacheState(builder, videoNumber);
                            cacheInfo = builder.toString();
                        }
                    } else {
                        cacheInfo = null;
                    }
                    PageInfoDialogFragment dialogFragment = PageInfoDialogFragment.newInstance(
                            webView.getTitle(), webView.getUrl(), cacheInfo);
                    dialogFragment.show(transaction, "dialog");
                }
                break;
            default:
                assert false : item.getItemId();
                break;
        }
        return false;
    }

    private class JsObj {
        private static final String DIV_STYLE = "text-align: left; "
            + "border: dotted medium #000000; "
            + "margin: 5px 8px; padding: 5px 7px;"
            + "color: #000000; background-color: #f0f8ff; "
            + "font-size: 14pt; ";

        public String urlRss;
        public String streamDescription;
        public int msgIdGetOffsetFlvplayerContainer = -1;

        @SuppressWarnings("unused")
        public void getRss(String rss) {
            urlRss = rss;
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, rss);
            }
            mHandler.sendEmptyMessage(MSG_ID_UPDATE_OPTIONS_MENU);
        }

        @SuppressWarnings("unused")
        public String getFlvplayerContainerHtml() {
            String newVideoNumber = null;
            String newLiveNumber = null;

            StringBuilder builder = new StringBuilder();
            Resources res = mContext.getResources();
            builder.append("<div style=\"").append(DIV_STYLE).append("\"><strong>")
                .append(res.getString(R.string.js_flvplayer_container_menu_title))
                .append("</strong><form action=\"javascript:void(0)\"><ul>");

            String url = null;
            WebView webView = mWebView;
            if (webView != null) {
                url = webView.getUrl();
            }
            if (mCookieUserSession != null && url != null) {
                newVideoNumber = getVideoNumberFromUrl(url);
                if (newVideoNumber != null) {
                    // XXX この取り方だとタイミング的にちょっと甘い
                    ThumbInfo thumbInfo = mThumbInfoCacher.getThumbInfo(newVideoNumber);
                    final boolean hasLow = ((thumbInfo == null)
                            ? true : thumbInfo.getSizeLow() > 0);

                    // 動画
                    final boolean isSwf = NicoroAPIManager.isVideoNumberSwf(newVideoNumber);
                    if (isSwf) {
                        // swf動画
                        appendLiButton(builder, "nicoro.startPlay()",
                                res.getString(R.string.action_item_play_swf));
                    } else {
                        // flvまたはmp4動画
                        appendLiButton(builder, "nicoro.startPlay()",
                                res.getString(R.string.action_item_play_normal));
                        if (hasLow) {
                            appendLiButton(builder, "nicoro.startPlayLow()",
                                    res.getString(R.string.action_item_play_normal_low));
                        }
                    }

                    if (isCacheNeeded(newVideoNumber)) {
                        appendLiButton(builder, "nicoro.startCache()",
                                res.getString(R.string.action_item_cache));
                    }
                    if (!isSwf && hasLow) {
                        if (isCacheNeededLow(newVideoNumber)) {
                            appendLiButton(builder, "nicoro.startCacheLow()",
                                    res.getString(R.string.action_item_cache_low));
                        }
                    }

                    appendLiButton(builder, "nicoro.relatedVideo()",
                            res.getString(R.string.action_item_related_video));

                    if (VideoLoader.hasAnyCacheFile(newVideoNumber)) {
                        appendLiButton(builder, "nicoro.deleteCache()",
                                res.getString(R.string.action_item_delete_cache_one));
                    }

                    appendLiButton(builder, "nicoro.addMylist()",
                            res.getString(R.string.action_item_add_mylist));
                }
                newLiveNumber = getLiveNumberFromUrl(url);
                if (newLiveNumber != null) {
                    appendLiButton(builder, "nicoro.startLive()",
                            res.getString(R.string.action_item_live));
                }
            }

            builder.append("</ul></form></div>");

            mVideoNumber = newVideoNumber;
            mLiveNumber = newLiveNumber;

            return builder.toString();
        }

        @SuppressWarnings("unused")
        public void startPlay() {
            mHandler.obtainMessage(MSG_ID_ACTION_START_PLAY, 0, 0)
                .sendToTarget();
        }
        @SuppressWarnings("unused")
        public void startPlayLow() {
            mHandler.obtainMessage(MSG_ID_ACTION_START_PLAY, 1, 0)
                .sendToTarget();
        }
        @SuppressWarnings("unused")
        public void startCache() {
            mHandler.obtainMessage(MSG_ID_ACTION_START_CACHE, 0, 0)
                .sendToTarget();
        }
        @SuppressWarnings("unused")
        public void startCacheLow() {
            mHandler.obtainMessage(MSG_ID_ACTION_START_CACHE, 1, 0)
                .sendToTarget();
        }
        @SuppressWarnings("unused")
        public void relatedVideo() {
            mHandler.obtainMessage(MSG_ID_ACTION_RELATED_VIDEO)
                .sendToTarget();
        }
        @SuppressWarnings("unused")
        public void deleteCache() {
            mHandler.obtainMessage(MSG_ID_ACTION_DELETE_CACHE)
                .sendToTarget();
        }
        @SuppressWarnings("unused")
        public void addMylist() {
            mHandler.obtainMessage(MSG_ID_ACTION_ADD_MYLIST)
                .sendToTarget();
        }

        @SuppressWarnings("unused")
        public String getPlayerboxHtml() {
            String newJikkyoNumber = null;

            StringBuilder builder = new StringBuilder();
            Resources res = mContext.getResources();
            builder.append("<div style=\"").append(DIV_STYLE).append("\"><strong>")
                .append(res.getString(R.string.js_flvplayer_container_menu_title))
                .append("</strong><form action=\"javascript:void(0)\"><ul>");

            String url = null;
            WebView webView = mWebView;
            if (webView != null) {
                url = webView.getUrl();
            }
            if (mCookieUserSession != null && url != null) {
                newJikkyoNumber = getJikkyoNumberFromUrl(url);
                if (newJikkyoNumber != null) {
                    appendLiButton(builder, "nicoro.startJikkyo()",
                            res.getString(R.string.action_item_jikkyo));
                }
            }

            builder.append("</ul></form></div>");

            mJikkyoNumber = newJikkyoNumber;

            return builder.toString();
        }

        @SuppressWarnings("unused")
        public void startJikkyo() {
            mHandler.sendEmptyMessage(MSG_ID_ACTION_START_JIKKYO);
        }

        @SuppressWarnings("unused")
        public void startLive() {
            mHandler.sendEmptyMessage(MSG_ID_ACTION_START_LIVE);
        }

        @SuppressWarnings("unused")
        public void goBack() {
            mHandler.sendEmptyMessage(MSG_ID_GO_BACK_WEBVIEW);
        }

        @SuppressWarnings("unused")
        public void getStreamDescription(String strDes) {
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, Log.buf().append("stream_description=")
                        .append(strDes).toString());
            }
            streamDescription = strDes;
        }

        @SuppressWarnings("unused")
        public void log(String text) {
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, text);
            }
        }

        @SuppressWarnings("unused")
        public void getOffsetFlvplayerContainer(int offsetLeft, int offsetTop,
                int offsetWidth, int offsetHeight) {
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, Log.buf().append("getOffsetFlvplayerContainer: ")
                        .append(offsetLeft).append(",").append(offsetTop).append(",")
                        .append(offsetWidth).append(",").append(offsetHeight)
                        .append(" msgIdGetOffsetFlvplayerContainer=").append(msgIdGetOffsetFlvplayerContainer)
                        .toString());
            }
//            mHandler.obtainMessage(MSG_ID_FLASH_SET_POS, offsetLeft, offsetTop).sendToTarget();
            mHandler.obtainMessage(msgIdGetOffsetFlvplayerContainer,
                    new Rect(offsetLeft, offsetTop,
                            offsetLeft + offsetWidth, offsetTop + offsetHeight))
                            .sendToTarget();
        }
    }

    static StringBuilder appendLiButton(StringBuilder builder,
            String function, String text) {
        return builder.append("<li><button onclick=\"")
            .append(function)
            .append("; return false;\">")
            .append(text)
            .append("</button>");
    }

//    /**
//     * TODO 別のclassに移動すべき
//     */
//    public static void startBrowserActivity(Activity activity, String url) {
//        Intent intent;
//        if (url == null) {
//            intent = new Intent(activity, NicoroWebBrowser.class);
//        } else {
//            intent = new Intent(
//                    Intent.ACTION_VIEW,
//                    Uri.parse(url),
//                    activity, NicoroWebBrowser.class)
//                .addCategory(Intent.CATEGORY_BROWSABLE);
//        }
//        intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
//        activity.startActivity(intent);
//    }

    @Override
    public void setListMenuStarterCallback(CallbackMessage<Bundle, Void> callback) {
        mListMenuStarter = callback;
    }
}
