package jp.sourceforge.nicoro;

import android.content.res.Configuration;
import android.content.res.Resources;
import android.test.AndroidTestCase;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class PlayerInfoViewsTest extends AndroidTestCase {
    private LayoutInflater mInflater;
    private View mRootView;
    private Resources mRes;
    private PlayerInfoViews mViews;

    @Override
    protected void setUp() {
        mInflater = LayoutInflater.from(getContext());
        assertNotNull(mInflater);
        mRootView = createRootView(mInflater);
        assertNotNull(mRootView);
        mRes = getContext().getResources();
        mViews = new PlayerInfoViews();
        mViews.initializeView(mRootView);
    }

    @Override
    protected void tearDown() {
        mInflater = null;
        mRootView = null;
        mRes = null;
        mViews = null;
    }

    public void testSetCountPlay() {
        VariableLabelView infoCountPlay = Util.findViewById(mRootView,
                R.id.info_count_play);
        assertNotNull(infoCountPlay);
        mViews.setCountPlay(12345);
        assertEquals(mRes.getString(R.string.info_count_play) + "12345",
                infoCountPlay.getText());
    }

    public void testSetLiveCountWatch() {
        VariableLabelView infoCountPlay = Util.findViewById(mRootView,
                R.id.info_count_play);
        assertNotNull(infoCountPlay);
        mViews.setLiveCountWatch("12345");
        assertEquals(mRes.getString(R.string.info_live_count_watch) + "12345",
                infoCountPlay.getText());
    }

    public void testSetCountComment() {
        VariableLabelView infoCountComment = Util.findViewById(mRootView,
                R.id.info_count_comment);
        assertNotNull(infoCountComment);
        mViews.setCountComment(2345);
        assertEquals(mRes.getString(R.string.info_count_comment) + "2345",
                infoCountComment.getText());
    }

    public void testSetLiveCountComment() {
        VariableLabelView infoCountComment = Util.findViewById(mRootView,
                R.id.info_count_comment);
        assertNotNull(infoCountComment);
        mViews.setLiveCountComment("2345");
        assertEquals(mRes.getString(R.string.info_live_count_comment) + "2345",
                infoCountComment.getText());
    }

    public void testSetCountMylist() {
        VariableLabelView infoCountMylist = Util.findViewById(mRootView,
                R.id.info_count_mylist);
        mViews.setCountMylist(345);
        if (infoCountMylist != null) {
            assertEquals(mRes.getString(R.string.info_count_mylist) + "345",
                    infoCountMylist.getText());
        }
    }

    public void testSetTitle() {
        VariableLabelView infoTitle = Util.findViewById(mRootView,
                R.id.info_title);
        assertNotNull(infoTitle);
        final String title = "TitleA";
        mViews.setTitle(title);
        assertEquals(title, infoTitle.getText());
    }

    public void testSetDescription() {
        VariableLabelView infoDescription = Util.findViewById(mRootView,
                R.id.info_description);
        assertNotNull(infoDescription);
        final String description = "descriptionA\ndescriptionB";
        mViews.setDescription(description);
        assertEquals(description, infoDescription.getText());
    }

    public void testSetPlayData() {
        VariableLabelView infoPlayData = Util.findViewById(mRootView,
                R.id.info_play_data);
        assertNotNull(infoPlayData);
        mViews.setPlayData(new PlayerInfoViews.PlayDataAppender() {
            @Override
            public StringBuilder appendVideoResolution(StringBuilder builder) {
                builder.append("640x320");
                return builder;
            }
            @Override
            public StringBuilder appendPlayerInfo(StringBuilder builder) {
                builder.append("player-info");
                return builder;
            }
            @Override
            public StringBuilder appendMovieType(StringBuilder builder) {
                builder.append("mpeg4");
                return builder;
            }
        });
        assertEquals(mRes.getString(R.string.info_play_data_pre) + "mpeg4 640x320 player-info",
                infoPlayData.getText());
    }

    public void testSetTime() {
        VariableLabelView infoTime = Util.findViewById(mRootView,
                R.id.info_time);
        assertNotNull(infoTime);
        StringBuilder builder = mViews.setTime(new PlayerInfoViews.TimeAppender() {
            @Override
            public StringBuilder appendTotalPlayTime(StringBuilder builder) {
                return builder.append("39:39");
            }
            @Override
            public StringBuilder appendCurrentPlayTime(StringBuilder builder) {
                return builder.append("00:39");
            }
            @Override
            public boolean hasTotalPlayTime() {
                return true;
            }
        });
        assertEquals("00:39/39:39", infoTime.getText());
        assertEquals(infoTime.getText(), builder.toString());

        builder = mViews.setTime(new PlayerInfoViews.TimeAppender() {
            @Override
            public StringBuilder appendTotalPlayTime(StringBuilder builder) {
                return builder.append("39:39");
            }
            @Override
            public StringBuilder appendCurrentPlayTime(StringBuilder builder) {
                return builder.append("00:40");
            }
            @Override
            public boolean hasTotalPlayTime() {
                return true;
            }
        });
        assertEquals("00:40/39:39", infoTime.getText());
        assertEquals(infoTime.getText(), builder.toString());

        builder = mViews.setTime(new PlayerInfoViews.TimeAppender() {
            @Override
            public StringBuilder appendTotalPlayTime(StringBuilder builder) {
                return builder.append("never show text");
            }
            @Override
            public StringBuilder appendCurrentPlayTime(StringBuilder builder) {
                return builder.append("00:41");
            }
            @Override
            public boolean hasTotalPlayTime() {
                return false;
            }
        });
        assertEquals("00:41", infoTime.getText());
        assertEquals(infoTime.getText(), builder.toString());
    }

    public void testCopyLayoutParamsFrom() {
        Configuration configOrg = mRes.getConfiguration();
        try {
            Configuration config = new Configuration(configOrg);
            if (config.orientation == Configuration.ORIENTATION_PORTRAIT) {
                config.orientation = Configuration.ORIENTATION_LANDSCAPE;
            } else if (config.orientation == Configuration.ORIENTATION_LANDSCAPE) {
                config.orientation = Configuration.ORIENTATION_PORTRAIT;
            }
            mRes.updateConfiguration(config, mRes.getDisplayMetrics());
            ViewGroup anotherRootView =
                (ViewGroup) createRootView(LayoutInflater.from(getContext()));
            assertNotNull(anotherRootView);

            mViews.copyLayoutParamsFrom(anotherRootView);

            TestUtil.checkLayoutParams(mRootView, anotherRootView);
        } finally {
            mRes.updateConfiguration(configOrg, mRes.getDisplayMetrics());
        }
    }

    public void testGetInfoView() {
        ViewGroup info = mViews.getInfoView();
        assertNotNull(info);
        assertEquals(R.id.player_info, info.getId());
    }

    public void testGetTimeView() {
        View time = mViews.getTimeView();
        assertNotNull(time);
        assertEquals(R.id.info_time, time.getId());
    }

    public void testSetSheet() {
        VariableLabelView infoSheet = Util.findViewById(mRootView,
                R.id.info_sheet);
        final String sheet = "SheetA";
        mViews.setSheet(sheet);
        if (infoSheet != null) {
            assertEquals(sheet, infoSheet.getText());
        }
    }

    protected View createRootView(LayoutInflater inflater) {
        FrameLayout temp = new FrameLayout(getContext());
        return inflater.inflate(R.layout.player_info, temp, false);
    }
}
