package jp.sourceforge.nicoro.nicoscript;

import junit.framework.TestCase;

public class NicoScriptTest extends TestCase {

    public void testCommandSplitter() {
        final String text0 = "@テスト abc ｢def ghi｣ jklm nopqrs";

        NicoScript.CommandSplitter cs = new NicoScript.CommandSplitter(text0);
        assertEquals("@テスト", cs.getNextCommand());
        assertEquals("abc", cs.getNextCommand());
        assertEquals("def ghi", cs.getNextCommandPhraze());
        assertEquals("jklm", cs.getNextCommand());
        assertEquals("nopqrs", cs.getNextCommand());

        final String text1 = "Z＠テスト　ABC　「DEFGHI　JKL」";
        cs.reset(text1, 1);
        assertEquals("＠テスト", cs.getNextCommand());
        assertEquals("ABC", cs.getNextCommandPhraze());
        assertEquals("DEFGHI　JKL", cs.getNextCommandPhraze());
    }
}
