package jp.sourceforge.nicoro;

import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

import android.os.AsyncTask;

import java.io.IOException;

import jp.sourceforge.nicoro.NicoroAPIManager.CookieNicoHistoryAndBody;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

/**
 * 動画ページのアクセス履歴のCookie nicohistory を取得する
 */
public abstract class GetCookieNicoHistoryTask extends AsyncTask<Void, Void, CookieNicoHistoryAndBody> {
    protected String mVideoNumber;
    protected String mCookieUserSession;
    protected String mUserAgent;
    protected int mForceEco;

    protected Exception mException;

    private HttpUriRequest mHttpRequestNicoHistory;

    private boolean mGetBody;

    private DefaultHttpClient mHttpClient;

    protected GetCookieNicoHistoryTask(String videoNumber, int forceEco,
            String cookieUserSession, String userAgent, boolean getBody) {
        this(videoNumber, forceEco, cookieUserSession, userAgent, getBody, null);
    }

    protected GetCookieNicoHistoryTask(String videoNumber, int forceEco,
            String cookieUserSession, String userAgent, boolean getBody,
            DefaultHttpClient httpClient) {
        mVideoNumber = videoNumber;
        mForceEco = forceEco;
        mCookieUserSession = cookieUserSession;
        mUserAgent = userAgent;
        mGetBody = getBody;

        mHttpClient = httpClient;
    }

    @Override
    protected void onPreExecute() {
        mHttpRequestNicoHistory = createHttpRequest(mForceEco);
    }

    @Override
    protected CookieNicoHistoryAndBody doInBackground(Void... params) {
        DefaultHttpClient httpClient;
        if (mHttpClient == null) {
            httpClient = Util.createHttpClient();
        } else {
            httpClient = mHttpClient;
        }
        try {
            CookieNicoHistoryAndBody result;
            if (mGetBody) {
                result = NicoroAPIManager.getCookieNicoHistoryAndBody(
                        httpClient, mHttpRequestNicoHistory, mForceEco);
            } else {
                String cookie = NicoroAPIManager.getCookieNicoHistory(
                        httpClient, mHttpRequestNicoHistory, mForceEco);
                result = new CookieNicoHistoryAndBody();
                result.cookie = cookie;
            }
            return result;
        } catch (IOException e) {
            Log.e(LOG_TAG, e.toString(), e);
            mException = e;
            return null;
        } finally {
            if (mHttpClient == null) {
                httpClient.getConnectionManager().shutdown();
            }
            mHttpClient = null;
        }
    }

    public void stop() {
        cancel(false);
        Util.abortHttpUriRequest(mHttpRequestNicoHistory);
    }

    private HttpUriRequest createHttpRequest(int ecoType) {
        if (mGetBody) {
            return NicoroAPIManager.createGetCookieNicoHistoryAndBody(
                    mVideoNumber, mCookieUserSession,
                    ecoType, mUserAgent);
        } else {
            return NicoroAPIManager.createGetCookieNicoHistory(
                    mVideoNumber, mCookieUserSession,
                    ecoType, mUserAgent);
        }
    }
}
