package jp.sourceforge.nicoro;

import android.view.View;
import android.widget.TextView;

import jp.gr.java_conf.shiseissi.commonlib.ViewUtil;

public class ListEmptyProgressManager {
    private View mViewProgress;
    private TextView mViewEmptyText;

    /**
     *
     * @param root 親となるView。
     * R.id.progressのViewおよびR.id.empty_textのTextViewを子に持つこと
     */
    public ListEmptyProgressManager(View root) {
        mViewProgress = ViewUtil.findViewById(root, R.id.progress);
        mViewEmptyText = ViewUtil.findViewById(root, R.id.empty_text);
    }

    public void showEmptyProgress() {
        mViewProgress.setVisibility(View.VISIBLE);
        mViewEmptyText.setVisibility(View.INVISIBLE);
    }

    public void showEmptyText() {
        mViewProgress.setVisibility(View.INVISIBLE);
        mViewEmptyText.setVisibility(View.VISIBLE);
    }

    public void setEmptyText(CharSequence text) {
        mViewEmptyText.setText(text);
    }
    public void setEmptyText(int resId) {
        mViewEmptyText.setText(resId);
    }
}
