package net.sf.amateras.nikocale.action;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;

public abstract class AbstractNikocaleAction implements IAction {

	@Request
	public Integer year;

	@Request
	public Integer month;

	protected void setDateAttributes(HttpServletRequest request){
		Calendar cal = Calendar.getInstance();

		// 今日の日付
		int currentYear  = cal.get(Calendar.YEAR);
		int currentMonth = cal.get(Calendar.MONTH) + 1;
		int currentDay   = cal.get(Calendar.DAY_OF_MONTH);

		if(year == null || month == null){
			year = cal.get(Calendar.YEAR);
			month = cal.get(Calendar.MONTH) + 1;
		}

		request.setAttribute("year", year);
		request.setAttribute("month", month);

		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, month - 1);

		int prevYear = year;
		int prevMonth = month - 1;

		if(prevMonth == 0){
			prevYear = prevYear - 1;
			prevMonth = 12;
		}

		request.setAttribute("prevYear", prevYear);
		request.setAttribute("prevMonth", prevMonth);

		int nextYear = year;
		int nextMonth = month + 1;

		if(nextMonth == 13){
			nextYear = nextYear + 1;
			nextMonth = 1;
		}

		request.setAttribute("nextYear", nextYear);
		request.setAttribute("nextMonth", nextMonth);

		cal.set(Calendar.DAY_OF_MONTH, 1);

		List<DateDto> dateList = new ArrayList<DateDto>();
		while(month == cal.get(Calendar.MONTH) + 1){
			DateDto dto = new DateDto();
			dto.setDay(cal.get(Calendar.DAY_OF_MONTH));

			if(year == currentYear && month == currentMonth && dto.getDay() == currentDay){
				dto.setToday(true);
			} else {
				int week = cal.get(Calendar.DAY_OF_WEEK);
				dto.setHoliday(week == Calendar.SUNDAY || week == Calendar.SATURDAY);
			}

			dateList.add(dto);

			cal.add(Calendar.DAY_OF_MONTH, 1);
		}

		request.setAttribute("dateList", dateList);
	}

	/**
	 * カレンダ表示用のデータを作成して HttpServletRequest に setAttribute() します。
	 */
	protected void setCalendarAttribute(HttpServletRequest request){
		@SuppressWarnings("unchecked")
		List<DateDto> dateList = (List<DateDto>) request.getAttribute("dateList");

		List<CalendarDto> calendarList = new ArrayList<CalendarDto>();

		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, month - 1);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		int dayOfWeek = cal.get(Calendar.DAY_OF_WEEK);
		for(int i = 1; i < dayOfWeek; i++){
			calendarList.add(new CalendarDto(0, i, null));
		}
		int month = cal.get(Calendar.MONTH);
		int count = 0;
		while(month == cal.get(Calendar.MONTH)){
			calendarList.add(new CalendarDto(
					cal.get(Calendar.DAY_OF_MONTH),
					cal.get(Calendar.DAY_OF_WEEK),
					dateList.get(count)));
			dayOfWeek = cal.get(Calendar.DAY_OF_WEEK);
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		for(int i = dayOfWeek + 1; i <= 7; i++){
			calendarList.add(new CalendarDto(0, i, null));
		}

		request.setAttribute("calendarList", calendarList);
	}

	public static class DateDto {

		private int day;
		private boolean holiday;
		private boolean today;

		public int getDay() {
			return day;
		}
		public void setDay(int day) {
			this.day = day;
		}
		public boolean isHoliday() {
			return holiday;
		}
		public void setHoliday(boolean holiday) {
			this.holiday = holiday;
		}
		public boolean isToday() {
			return today;
		}
		public void setToday(boolean today) {
			this.today = today;
		}
		public String getStyleClass(){
			if(isToday()){
				return "today";
			}
			if(isHoliday()){
				return "holiday";
			}
			return "normal";
		}
	}

	public static class CalendarDto {

		private int week;
		private int day;
		private DateDto dateDto;

		public CalendarDto(int day, int week, DateDto dateDto){
			this.day = day;
			this.week = week;
			this.dateDto = dateDto;
		}

		public int getDay() {
			return day;
		}

		public void setDay(int day) {
			this.day = day;
		}

		public int getWeek() {
			return week;
		}

		public void setWeek(int week) {
			this.week = week;
		}

		public String getStyleClass(){
			if(week == Calendar.SUNDAY){
				return "sunday";
			} else if(week == Calendar.SATURDAY){
				return "saturday";
			}
			return "";
		}

		public DateDto getDateDto(){
			return dateDto;
		}
	}
}
