package jp.sf.nikonikofw.authentication;

import jp.sf.nikonikofw.ServletUtil;

/**
 * <code>HttpSession</code>を使用した{@link IAuthenticationMananger}の実装です。
 * 
 * @author Naoki Takezoe
 */
public class HttpSessionAuthenticationManager implements IAuthenticationMananger {

	private static final String SESSION_KEY 
		= HttpSessionAuthenticationManager.class.getName() + ".UserInfo";
	
	@Override
	public Object getUserInfo() {
		return ServletUtil.getSession().getAttribute(SESSION_KEY);
	}

	@Override
	public boolean isLogin() {
		return ServletUtil.getSession().getAttribute(SESSION_KEY) != null;
	}

	@Override
	public void login(Object obj) {
		ServletUtil.getSession().setAttribute(SESSION_KEY, obj);
	}

	@Override
	public void logout() {
		ServletUtil.getSession().invalidate();
	}

	/**
	 * 常に<code>false</code>を返します。
	 * 必要に応じてサブクラスでオーバーライドしてください。
	 */
	@Override
	public boolean isAdmin() {
		return false;
	}

}
