package jp.sf.nikonikofw.util.converter;

import java.util.ArrayList;
import java.util.List;

public class DefaultConverter implements IConverter {
	
	private static List<Class<?>> SUPPORTED_TYPES = new ArrayList<Class<?>>();
	
	static {
		SUPPORTED_TYPES.add(Integer.class);
		SUPPORTED_TYPES.add(Integer.TYPE);
		SUPPORTED_TYPES.add(Long.class);
		SUPPORTED_TYPES.add(Long.TYPE);
		SUPPORTED_TYPES.add(Double.class);
		SUPPORTED_TYPES.add(Double.TYPE);
		SUPPORTED_TYPES.add(Boolean.class);
		SUPPORTED_TYPES.add(Boolean.TYPE);
		SUPPORTED_TYPES.add(String.class);
	}
	
	@Override
	public Object convert(String value, Class<?> targetType) {
		if(targetType == Integer.class || targetType == Integer.TYPE){
			return new Integer(value);
		} else if(targetType == Long.class || targetType == Long.TYPE){
			return new Long(value);
		} else if(targetType == Double.class || targetType == Double.TYPE){
			return new Double(value);
		} else if(targetType == Boolean.class || targetType == Boolean.TYPE){
			return new Boolean(value);
		} else if(targetType == String.class){
			return value;
		}
		throw new RuntimeException("サポートされていないデータ型です。");
	}

	@Override
	public boolean isSupport(Class<?> targetType) {
		return SUPPORTED_TYPES.contains(targetType);
	}

}
