package jp.sf.nikonikofw;

import jp.sf.nikonikofw.annotation.Request;

/**
 * ファイルフィールドでアップロードされたファイルの情報を格納するクラスです。
 * <p>
 * アクションにこのフィールドを宣言して{@link Request}アノテーションを付与しておくと
 * ファイルフィールドでアップロードされた情報を受け取ることができます。
 * 
 * @author Naoki Takezoe
 */
public class FileItem {
	
	private String fieldName;
	private String fileName;
	private byte[] fieldValue;
	private String contentType;
	
	public FileItem(String fieldName, String fileName, String contentType, byte[] fieldValue){
		this.fieldName = fieldName;
		this.fileName = fileName;
		this.fieldValue = fieldValue;
		this.contentType = contentType;
	}

	/**
	 * フィールド名を取得します。
	 * 
	 * @return フィールド名
	 */
	public String getFieldName() {
		return fieldName;
	}

	/**
	 * ファイル名を取得します。
	 * ファイルフィールドでない場合はnullを返します。
	 * 
	 * @return ファイル名
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * フィールドの値をバイト配列で取得します。
	 * 
	 * @return フィールドの値
	 */
	public byte[] getFieldValue() {
		return fieldValue;
	}
	
	public String getContentType(){
		return contentType;
	}
	
	/**
	 * このフィールドがフォームフィールドかどうかを調べます。
	 * 
	 * @return このフィールドがフォームフィールドの場合true、
	 *   ファイルフィールドの場合はfalseを返します
	 */
	public boolean isFormField(){
		return this.fileName == null;
	}
	
}
