package jp.sf.nikonikofw.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * アクションクラスのpublicフィールドに付与することで、
 * リクエストパラメータをセットするアノテーションです。
 * 
 * @author Naoki Takezoe
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Request {
	
	/**
	 * 項目名。エラーメッセージの表示に使用されます。
	 */
	String label() default "";
	
	/**
	 * パラメータ名。省略した場合はフィールド名のパラメータがセットされます。
	 */
	String name() default "";
	
//	/**
//	 * 必須の場合trueに設定するとフレームワークで入力チェックが行われます。
//	 */
//	boolean required() default false;
//	
//	/**
//	 * 最小文字数を指定します。
//	 */
//	int minLength() default 0;
//	
//	/**
//	 * 最大文字数を指定します。
//	 */
//	int maxLength() default 0;
//	
//	/**
//	 * 半角数字のみ許容する場合trueを設定します。
//	 */
//	boolean numeric() default false;
//	
//	/**
//	 * 許容するパターンを正規表現で指定します。
//	 */
//	String format() default "";
	
}
