package jp.sf.nikonikofw.util;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 日付関係のユーティリティメソッドを提供します。
 * 
 * @author Naoki Takezoe
 */
public class DateUtils {
	
	private static String datePattern = "yyyy/MM/dd";
	
	private static String datetimePattern = "yyyy/MM/dd HH:mm:ss";
	
	/**
	 * DateUtilを初期化します。
	 * 
	 * @param datePattern 日付のフォーマットパターン
	 * @param datetimePattern 日時のフォーマットパターン
	 */
	public static void init(String datePattern, String datetimePattern){
		if(StringUtils.isNotEmpty(datePattern)){
			DateUtils.datePattern = datePattern;
		}
		if(StringUtils.isNotEmpty(datetimePattern)){
			DateUtils.datetimePattern = datetimePattern;
		}
	}
	
	/**
	 * 日付を日時形式にフォーマットします。
	 * <p>
	 * このメソッドはデフォルトでは<code>yyyy/MM/dd</code>形式でフォーマットしますが、
	 * <tt>framework.properties</tt>の<code>datePattern</code>プロパティで
	 * 任意のフォーマットに変更することができます。
	 * 
	 * @param date 日付
	 * @return フォーマットされた文字列
	 */
	public static String formatDate(Date date){
		return new SimpleDateFormat(datePattern).format(date);
	}
	
	/**
	 * 日付をタイムスタンプ形式にフォーマットします。
	 * <p>
	 * このメソッドはデフォルトでは<code>yyyy/MM/dd HH:mm:ss</code>形式でフォーマットしますが、
	 * <tt>framework.properties</tt>の<code>datetimePattern</code>プロパティで
	 * 任意のフォーマットに変更することができます。
	 * 
	 * @param date 日付
	 * @return フォーマットされた文字列
	 */
	public static String formatDateTime(Date date){
		return new SimpleDateFormat(datetimePattern).format(date);
	}
	
}
