<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/header.jsp" %>

<style type="text/css">
div.comment {
	margin-top: 20px;
	padding: 10px;
	background-color: #EEEEEE;
}

div.comment_header {
	font-weight: bold;
	border-bottom: 2px dotted gray;
	margin-bottom: 10px;
}

div.sidebar {
  float: right;
  width: 248px;
  background-color: white;
}

div.main {
  margin-right: 250px;
  padding-right: 4px;
  border-right: 1px solid #cccccc;
}
</style>

<div class="sidebar">
  <table style="width: 248px;">
    <tr>
      <th colspan="2" style="background-color: #EEEEEE;">
        ${f:h(member.name)}さんの情報
        <a href="${context}/rss.do?memberId=?${member.id}"><img src="${context}/images/feed.png" border="0"></a>
      </th>
    </tr>
    <c:if test="${image}">
    <tr>
      <td colspan="2" style="text-align: center;"><img src="${context}/image.do?userId=${member.id}"></td>
    </tr>
    </c:if>
    <c:if test="${!empty member.profile}">
    <tr>
      <td colspan="2" style="border-bottom: 1px solid silver;">${f:link(f:br(f:h(member.profile)))}</td>
    </tr>
    </c:if>
    <tr>
      <td>ニコカレ日数</td>
      <td align="right">${count}日</td>
    </tr>
    <tr>
      <td>ニコニコポイント</td>
      <td align="right">
        <c:if test="${!empty point}">
          ${point}pts
        </c:if>
        <c:if test="${empty point}">
          ---
        </c:if>
      </td>
    </tr>
    <tr>
      <td>最初のニコカレ</td>
      <td align="right">
        <c:if test="${!empty firstDate}">
          <a href="entry.do?memberId=${member.id}&year=${fn:substring(firstDate, 0, 4)}&month=${fn:substring(firstDate, 5, 7)}&day=${fn:substring(firstDate, 8, 10)}">${firstDate}</a>
        </c:if>
        <c:if test="${empty firstDate}">
          ----/--/--
        </c:if>
      </td>
    </tr>
    <tr>
      <td>最後のニコカレ</td>
      <td align="right">
        <c:if test="${!empty latestDate}">
          <a href="entry.do?memberId=${member.id}&year=${fn:substring(latestDate, 0, 4)}&month=${fn:substring(latestDate, 5, 7)}&day=${fn:substring(latestDate, 8, 10)}">${latestDate}</a>
        </c:if>
        <c:if test="${empty latestDate}">
          ----/--/--
        </c:if>
      </td>
    </tr>
    <tr>
      <td>所属グループ</td>
      <td align="right">
        <c:forEach items="${memberGroups}" var="group">
          <a href="nikocale.do?groupId=${group.id}">${f:h(group.groupName)}</a><br>
        </c:forEach>
        <c:if test="${empty memberGroups}">
          なし
        </c:if>
      </td>
    </tr>
  </table>
  <div style="border-top: 1px dotted gray; padding: 2px; text-align: right;">
    <img src="${context}/images/wrench.png"><a href="edituser.do?memberId=${member.id}">ユーザ情報の編集</a>
  </div>
  <table style="width: 248px;">
    <tr>
      <th style="background-color: #EEEEEE;">${year}年${month}月</th>
    </tr>
    <tr>
      <td>
        <table class="calendar">
          <tr>
            <th class="sunday">日</th>
            <th>月</th>
            <th>火</th>
            <th>水</th>
            <th>木</th>
            <th>金</th>
            <th class="saturday">土</th>
          </tr>
          <c:forEach items="${calendarList}" var="cal">
            <c:if test="${cal.week == 1}">
              <tr>
            </c:if>
            <c:if test="${cal.day == 0}">
              <td class="${cal.styleClass}">&nbsp;</td>
            </c:if>
            <c:if test="${cal.day != 0}">
              <c:set var="date" value="${cal.dateDto}"/>
              <td class="${cal.styleClass}">
                ${cal.day}<br>
                <span id="${member.id}-${date.day}-cal"><%@include file="calendar.jsp" %></span>
              </td>
            </c:if>
            <c:if test="${cal.week == 7}">
              </tr>
            </c:if>
          </c:forEach>
        </table>
      </td>
    </tr>
  </table>
</div>

<div class="main">
  <h2>${f:h(title)}</h2>

  <table>
  <tr>
    <td>
      <c:if test="${empty entry}">
        <img src="images/page_edit.png" border="0" title="クリックして編集！">
      </c:if>
      <c:if test="${!empty entry}">
        <c:if test="${entry.status == 0}">
          <img src="images/good32.png" border="0" title="ニコニコ">
        </c:if>
        <c:if test="${entry.status == 1}">
          <img src="images/normal32.png" border="0" title="普通">
        </c:if>
        <c:if test="${entry.status == 2}">
          <img src="images/bad32.png" border="0" title="ダメダメ">
        </c:if>
      </c:if>
    </td>
    <td>
      <c:if test="${!empty entry.message}">
        『${f:br(f:link(f:h(entry.message)))}』
      </c:if>
      <c:if test="${empty entry.message}">
        メッセージはありません。
      </c:if>
    </td>
  </tr>
  </table>

  <div style="margin-top: 10px;">
    <a href="${context}/member.do?memberId=${entry.userId}&year=${entry.year}&month=${entry.month}">月別表示に戻る</a>
  </div>

  <div class="comment">
    <div class="comment_header">コメント</div>
    <form action="commentdelete.do" method="POST">
      <c:forEach items="${commentList}" var="comment">
        <c:if test="${deleteFlag}">
          <input type="checkbox" name="commentId" value="${comment.id}">
        </c:if>
        <strong>${f:h(comment.name)}</strong>
        『${f:h(comment.comment)}』
        <fmt:formatDate pattern="yyyy/MM/dd HH:mm:ss" value="${comment.commentDate}"/><br>
      </c:forEach>
      <c:if test="${deleteFlag}">
        <input type="submit" value="コメントを削除">
        <input type="hidden" name="userId" value="${entry.userId}">
        <input type="hidden" name="year" value="${entry.year}">
        <input type="hidden" name="month" value="${entry.month}">
        <input type="hidden" name="day" value="${entry.day}">
      </c:if>
    </form>
    <form action="comment.do" method="POST">
      お名前
      <input type="text" name="name" value="${f:h(name)}">
      コメント
      <input type="text" name="comment" size="60">
      <input type="submit" name="submit" value="送信">
      <input type="hidden" name="entryId" value="${entry.id}">
    </form>
  </div>

</div>

<br>

<%@include file="/footer.jsp"%>