<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" isELIgnored="false"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="http://nikonikofw.sf.net/f" prefix="f" %>
<%@ taglib uri="http://nikocale.amateras.sf.net/extension" prefix="ex" %>

<html>

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <link rel="alternate" type="application/rss+xml" title="RSS" href="${context}/rss.do">
  <link rel="shortcut icon" href="${context}/favicon.ico" >
  <link rel="stylesheet" type="text/css" href="${context}/style.css">
  <script type="text/javascript" src="${context}/js/nikocale.js"></script>

  <!-- greybox -->
  <script type="text/javascript">
    var GB_ROOT_DIR = "${context}/js/greybox/";
  </script>
  <script type="text/javascript" src="${context}/js/greybox/AJS.js"></script>
  <script type="text/javascript" src="${context}/js/greybox/AJS_fx.js"></script>
  <script type="text/javascript" src="${context}/js/greybox/gb_scripts.js"></script>
  <link href="${context}/js/greybox/gb_styles.css" rel="stylesheet" type="text/css" media="all" />

  <!-- Flotr -->
  <!--[if IE]>
    <script type="text/javascript" src="${context}/js/flotr/lib/excanvas.js"></script>
    <script type="text/javascript" src="${context}/js/flotr/lib/base64.js"></script>
  <![endif]-->
  <script type="text/javascript" src="${context}/js/prototype.js"></script>
  <script type="text/javascript" src="${context}/js/flotr/lib/canvas2image.js"></script>
  <script type="text/javascript" src="${context}/js/flotr/lib/canvastext.js"></script>
  <script type="text/javascript" src="${context}/js/flotr/flotr-0.2.0-alpha.js"></script>

  <!-- bubble-tooltip -->
  <link rel="stylesheet" href="${context}/js/bubble-tooltip/css/bubble-tooltip.css" media="screen">
  <script type="text/javascript" src="${context}/js/bubble-tooltip//js/bubble-tooltip.js"></script>

  <title>${f:h(title)}</title>
</head>
<body>

<h2>${f:h(title)}</h2>

<a href="${context}/nikocale.do?groupId=${group.id}&year=${prevYear}&month=${prevMonth}&mode=embed">＜前の月</a> |
<a href="${context}/nikocale.do?groupId=${group.id}&mode=embed">今月</a> |
<a href="${context}/nikocale.do?groupId=${group.id}&year=${nextYear}&month=${nextMonth}&mode=embed">次の月＞</a>

<a href="nikocale.do?groupId=${groupId}" target="_blank"><img src="${context}/images/page_edit.png" border="0"> 入力はこちらから</a>

<div id="bubble_tooltip">
  <div class="bubble_top"><span></span></div>
  <div class="bubble_middle"><span id="bubble_tooltip_content">Content is comming here as you probably can see.Content is comming here as you probably can see.</span></div>
  <div class="bubble_bottom"></div>
</div>

<table class="nikocale">

<tr>
  <th>&nbsp;</th>
  <c:forEach items="${dateList}" var="date">
    <th class="${date.styleClass}"><c:out value="${date.day}"/></th>
  </c:forEach>
</tr>

<tr style="border-bottom: 4px double gray" onmouseover="this.setAttribute('class', 'highlight');" onmouseout="this.setAttribute('class', '');">
  <th class="name">グループの予定</th>
  <c:forEach items="${dateList}" var="date">
    <td align="center" class="${date.styleClass}" id="${date.day}">
      <c:if test="${empty calendar[date.day]}">
        <img src="images/page_edit_gray.png" border="0">
      </c:if>
      <c:if test="${!empty calendar[date.day]}">
        <img src="images/tick.png" border="0"  onmouseover="showToolTip(event,'${f:br(f:h(calendar[date.day].description))}');return false" onmouseout="hideToolTip()">
      </c:if>
    </td>
  </c:forEach>
</tr>

<c:forEach items="${members}" var="member">
<tr onmouseover="this.setAttribute('class', 'highlight');" onmouseout="this.setAttribute('class', '');">
  <th class="name">
    <a href="member.do?memberId=${member.id}&year=${year}&month=${month}" target="_blank">${f:h(member.name)}</a>
  </th>
  <c:forEach items="${dateList}" var="date">
    <td align="center" class="${date.styleClass}" id="${member.id}-${date.day}">
      <c:set var="key" value="${member.id}-${date.day}" />
      <c:if test="${empty entries[key]}">
        <img src="images/page_edit_gray.png" border="0">
      </c:if>
      <c:if test="${!empty entries[key]}">
        <c:if test="${entries[key].status == 0}">
          <img src="images/good16.png" border="0" title="${f:h(entries[key].message)}">
        </c:if>
        <c:if test="${entries[key].status == 1}">
          <img src="images/normal16.png" border="0" title="${f:h(entries[key].message)}">
        </c:if>
        <c:if test="${entries[key].status == 2}">
          <img src="images/bad16.png" border="0" title="${f:h(entries[key].message)}">
        </c:if>
      </c:if>
    </td>
  </c:forEach>
</tr>
</c:forEach>

</table>

<%-- フレームサイズの自動調整？
<script type="text/javascript">
var currentHeight;

function frameCheck(){
	var height = document.body.scrollHeight;
	if(height && currentHeight != height){
		parent.document.getElementById('nikocale_frame').style.height = (height + 10) + 'px';
		currentHeight = height + 10;
	}
	setTimeout('frameCheck()', 100);
}

setTimeout('frameCheck()', 10);
</script>
--%>

</body>
</html>
