<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/header.jsp" %>

<style type="text/css">
div.calendar-day {
	border-top: 2px dotted gray;
	padding: 4px;
}

div.sidebar {
  float: right;
  width: 248px;
  background-color: white;
}

div.main {
  margin-right: 250px;
  padding-right: 4px;
  border-right: 1px solid #cccccc;
}
</style>

<div class="sidebar">
  <table style="width: 248px;">
    <tr>
      <th colspan="2" style="background-color: #EEEEEE;">
        ${f:h(member.name)}さんの情報
        <a href="${context}/rss.do?memberId=?${member.id}"><img src="${context}/images/feed.png" border="0"></a>
      </th>
    </tr>
    <c:if test="${image}">
    <tr>
      <td colspan="2" style="text-align: center;"><img src="${context}/image.do?userId=${member.id}"></td>
    </tr>
    </c:if>
    <c:if test="${!empty member.profile}">
    <tr>
      <td colspan="2" style="border-bottom: 1px solid silver;">${f:link(f:br(f:h(member.profile)))}</td>
    </tr>
    </c:if>
    <tr>
      <td>ニコカレ日数</td>
      <td align="right">${count}日</td>
    </tr>
    <tr>
      <td>ニコニコポイント</td>
      <td align="right">
        <c:if test="${!empty point}">
          ${point}pts
        </c:if>
        <c:if test="${empty point}">
          ---
        </c:if>
      </td>
    </tr>
    <tr>
      <td>最初のニコカレ</td>
      <td align="right">
        <c:if test="${!empty firstDate}">
          <a href="entry.do?memberId=${member.id}&year=${fn:substring(firstDate, 0, 4)}&month=${fn:substring(firstDate, 5, 7)}&day=${fn:substring(firstDate, 8, 10)}">${firstDate}</a>
        </c:if>
        <c:if test="${empty firstDate}">
          ----/--/--
        </c:if>
      </td>
    </tr>
    <tr>
      <td>最後のニコカレ</td>
      <td align="right">
        <c:if test="${!empty latestDate}">
          <a href="entry.do?memberId=${member.id}&year=${fn:substring(latestDate, 0, 4)}&month=${fn:substring(latestDate, 5, 7)}&day=${fn:substring(latestDate, 8, 10)}">${latestDate}</a>
        </c:if>
        <c:if test="${empty latestDate}">
          ----/--/--
        </c:if>
      </td>
    </tr>
    <tr>
      <td>所属グループ</td>
      <td align="right">
        <c:forEach items="${memberGroups}" var="group">
          <a href="nikocale.do?groupId=${group.id}">${f:h(group.groupName)}</a><br>
        </c:forEach>
        <c:if test="${empty memberGroups}">
          なし
        </c:if>
      </td>
    </tr>
  </table>
  <div style="border-top: 1px dotted silver; padding: 2px; text-align: right;">
    <img src="${context}/images/wrench.png"><a href="edituser.do?memberId=${member.id}">ユーザ情報の編集</a>
  </div>
  <table style="width: 248px;">
    <tr>
      <th style="background-color: #EEEEEE;">${year}年${month}月</th>
    </tr>
    <tr>
      <td>
        <table class="calendar">
          <tr>
            <th class="sunday">日</th>
            <th>月</th>
            <th>火</th>
            <th>水</th>
            <th>木</th>
            <th>金</th>
            <th class="saturday">土</th>
          </tr>
          <c:forEach items="${calendarList}" var="cal">
            <c:if test="${cal.week == 1}">
              <tr>
            </c:if>
            <c:if test="${cal.day == 0}">
              <td class="${cal.styleClass}">&nbsp;</td>
            </c:if>
            <c:if test="${cal.day != 0}">
              <c:set var="date" value="${cal.dateDto}"/>
              <td class="${cal.styleClass}">
                ${cal.day}<br>
                <span id="${member.id}-${date.day}-cal"><%@include file="calendar.jsp" %></span>
              </td>
            </c:if>
            <c:if test="${cal.week == 7}">
              </tr>
            </c:if>
          </c:forEach>
        </table>
      </td>
    </tr>
  </table>
</div>

<div class="main">
  <a href="member.do?memberId=${member.id}&year=${prevYear}&month=${prevMonth}">＜前の月</a> |
  <a href="member.do?memberId=${member.id}">今月</a> |
  <a href="member.do?memberId=${member.id}&&year=${nextYear}&month=${nextMonth}">次の月＞</a>

  <c:forEach items="${dateList}" var="date">
     <div class="calendar-day ${date.styleClass}">
      <span><c:if test="${date.day < 10}">0</c:if>${date.day}</span>
      <span id="${member.id}-${date.day}">
        <%@include file="/calendar.jsp" %>
      </span>
      <span id="${member.id}-${date.day}-message">
        ${f:link(f:br(f:h(entries[key].message)))}
        <c:if test="${!empty entries[key]}">
          <a href="entry.do?memberId=${entries[key].userId}&year=${entries[key].year}&month=${entries[key].month}&day=${entries[key].day}"><img src="${context}/images/comment.png" border="0"></a>
          <c:if test="${entries[key].commentCount != 0}">(${entries[key].commentCount})</c:if>
        </c:if>
      </span>
    </div>
  </c:forEach>
</div>

<%@include file="/footer.jsp" %>