package net.sf.amateras.nikocale.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.entity.GroupCalendar;
import net.sf.amateras.nikocale.service.GroupCalendarService;

public class EditcalAction implements IAction {
	
	@Request
	@Required
	public Long groupId;
	
	@Request
	@Required
	public Integer year;
	
	@Request
	@Required
	public Integer month;
	
	@Request
	@Required
	public Integer day;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		request.setAttribute("year", year);
		request.setAttribute("month", month);
		request.setAttribute("day", day);
		request.setAttribute("groupId", groupId);
		
		GroupCalendar calendar = GroupCalendarService.getGroupCalendar(groupId, year, month, day);
		if(calendar == null){
			calendar = new GroupCalendar();
			calendar.year = year;
			calendar.month = month;
			calendar.day = day;
			calendar.description = "";
		}
		
		request.setAttribute("calendar", calendar);
		
		return "editcal.jsp";
	}

}
