package net.sf.amateras.nikocale.util;

import java.io.File;

/**
 * スタンドアロン版のニコカレで使用する様々なユーティリティメソッドを提供します。
 * 
 * @author Naoki Takezoe
 */
public class Utils {
	
	/**
	 * データファイルの保存ディレクトリを取得します。
	 * 
	 * @return データファイルの保存ディレクトリ
	 */
	public static File getDataDir(){
		File home = new File(System.getProperty("user.home"));
		File data = new File(home, ".nikocale");
		return data;
	}
	
	/**
	 * 画像ファイルの保存ディレクトリを取得します。
	 * ディレクトリが存在しない場合は自動的に作成されます。
	 * 
	 * @return 画像ファイルの保存ディレクトリ
	 */
	public static File getImageDir(){
		File dir = new File(getDataDir(), "/images");
		if(!dir.exists()){
			dir.mkdir();
		}
		return dir;
	}
	
	/**
	 * ユーザの画像ファイルが存在するかどうかをテストします。
	 * 
	 * @param userId ユーザID
	 * @return 画像が存在する場合true、存在しない場合false
	 */
	public static boolean existImage(Long userId){
		File imageFile = new File(getImageDir(), userId + ".jpg");
		return imageFile.exists();
	}
	
//	/**
//	 * ファイルの拡張子を取得します。
//	 * 
//	 * @param fileName ファイル名
//	 * @return 拡張子（ドットは含まない）
//	 * @throw RuntimeException 拡張子の取得に失敗した場合
//	 */
//	public static String getExtension(String fileName){
//		int lastIndex = fileName.lastIndexOf('.');
//		if(lastIndex < 0){
//			throw new RuntimeException("拡張子が取得できません。");
//		}
//		return fileName.substring(lastIndex + 1, fileName.length()).toLowerCase();
//	}
	
}
