---
title: "Nim partners with Status.im"
author: Nim Team
excerpt: "We're incredibly excited to announce the new partnership between Status and Nim."
---

<a href="{{ site.baseurl }}/assets/news/images/status/Status-Nim-partnership.png">
  <img src="{{ site.baseurl }}/assets/news/images/status/Status-Nim-partnership.png" alt="Status + Nim" style="width:100%"/>
</a>

We're incredibly excited to announce the new partnership between
[Status](https://status.im/)
and Nim. Status is developing an open source mobile DApp
browser and messenger for Ethereum.

The Status team has chosen the Nim programming language as a base for the
implementation of a brand new research project: a sharding client for Ethereum.
The project is named Nimbus, it is open source and available on
[GitHub](https://github.com/status-im/nimbus). You can read more about this
project as well as the reasons why Status chose Nim in the corresponding
[Status announcement article](https://our.status.im/status-partners-with-the-team-behind-the-programming-language-nim/).

As the developers of Nim we are very proud to see it used for this
project. We hope that this partnership will encourage other developers to
adopt Nim for their project and that it will give software companies the
confidence to develop products using Nim.

## The Partnership

The partnership will see Status support the Nim team with funding and resources
needed to stay focused on the development of the Nim programming language.
The Nim team has so far received
[many generous donations](https://nim-lang.org/sponsors.html) from other software
teams as well as from independent developers who believe in the project.
These donations have given us the ability to do many things such as
pay for the hosting costs of our servers, organize a Nim stand at the FOSDEM
conference and spend our free time developing Nim and related projects.

Unfortunately the donations are not currently enough for any of us to commit
to working on Nim full-time. With Status' help this is no longer the case.
We will now be able to stay focused on the development of the
Nim programming language. In addition, we plan to hire at least 2 full-time
developers. These developers will be tasked with fixing bugs, responding to
issues, and of course developing the compiler, the standard library and the
tooling.

Despite this partnership, Nim remains an independent project, with plans
being discussed in the open on GitHub, our forum and on IRC. Decisions are
as usual left to our BDFL, Andreas Rumpf, and will remain that way for the
foreseeable future.

## Our Roadmap

Our primary goal is to release Nim version 1.0.0, which signals our long
overdue commitment to a stable language and standard library that will
preserve backwards compatibility for years to come.

We won't make any commitments to a release date. But a detailed milestone
tracking all the issues that need to be resolved for v1.0.0 is available
[here](https://github.com/nim-lang/Nim/milestone/2).

With Status' support our development towards version 1.0.0 will accelerate
rapidly. We will also have more man-power to handle the recently increased
activity on our issue tracker.

## Beyond the roadmap

Beyond our current roadmap we would like to encourage our community to
get more involved in the development of Nim. We're currently considering a
grants program for Nim, similar to Google Summer of Code, where we will
hire developers to work on specific Nim-related projects.

Some examples for these grants:

* Improve the ``nimsuggest`` tool to support the common "language server
  protocol" that every text editor and IDE is starting to speak.
* Improve Nim's package manager, Nimble, to support reproducible builds.
* Improve Nim's tooling so that the result of macro expansions becomes easier to
  understand and follow.

We are extremely excited to continue developing Nim with renewed vigour and
are very thankful for the generous support from the Status team.

For more information and questions, join us on this forum thread:
[https://forum.nim-lang.org/t/4113](https://forum.nim-lang.org/t/4113).