/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import org.w3c.dom.*;

/**
 * `&lt;argument&gt;vf^f[^B<p>
 * T[rX`t@C&lt;argument&gt;vfɋLqꂽei[郁^f[^ReiłB<p>
 *
 * @author M.Takata
 * @see <a href="nimbus-service_2_0.xsd">T[rX`t@CXL[}`</a>
 */
public class ArgumentMetaData extends MetaData
 implements Serializable{
    
    private static final long serialVersionUID = 8109261601541836493L;
    
    /**
     * &lt;argument&gt;vf̗vfB<p>
     */
    public static final String ARGUMENT_TAG_NAME = "argument";
    
    protected static final String TYPE_ATTRIBUTE_NAME = "type";
    
    protected static final String VALUE_TYPE_ATTRIBUTE_NAME = "valueType";
    
    protected static final String TYPE_ATTRIBUTE_NULL_VALUE = "nullValue";
    
    protected ObjectMetaData parentObjData;
    
    protected String type;
    
    protected String valueType;
    
    protected Object value;
    
    protected boolean isNullValue;
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     * @param objData T[rXo^{@link ServiceManager}̖O
     */
    public ArgumentMetaData(MetaData parent, ObjectMetaData objData){
        super(parent);
        parentObjData = objData;
    }
    
    public ObjectMetaData getParentObjectMetaData(){
        return parentObjData;
    }
    
    /**
     * &lt;argument&gt;vftype̒l擾B<p>
     * 
     * @return type̒l
     */
    public String getType(){
        return type;
    }
    
    /**
     * &lt;argument&gt;vftype̒lݒ肷B<p>
     * 
     * @param type type̒l
     */
    public void setType(String type){
        this.type = type;
    }
    
    /**
     * &lt;argument&gt;vfvalueType̒l擾B<p>
     * 
     * @return valueType̒l
     */
    public String getValueType(){
        return valueType;
    }
    
    /**
     * &lt;argument&gt;vfvalueType̒lݒ肷B<p>
     * 
     * @param type valueType̒l
     */
    public void setValueType(String type){
        this.valueType = type;
    }
    
    /**
     * &lt;argument&gt;vfnullValue̒l擾B<p>
     * 
     * @return nullValue̒l
     */
    public boolean isNullValue(){
        return isNullValue;
    }
    
    /**
     * &lt;argument&gt;vfnullValue̒lݒ肷B<p>
     * 
     * @param flg nullValue̒l
     */
    public void setNullValue(boolean flg){
        isNullValue = flg;
    }
    
    /**
     * &lt;argument&gt;vf̓e̒l擾B<p>
     * 
     * @return &lt;argument&gt;vf̓e
     */
    public Object getValue(){
        return value;
    }
    
    /**
     * &lt;argument&gt;vf̓e̒lݒ肷B<p>
     * 
     * @param value &lt;argument&gt;vf̓e
     */
    public void setValue(Object value){
        this.value = value;
    }
    
    /**
     * &lt;argument&gt;vfElementp[XāAg̏Ayюqvf̃^f[^̐sB<p>
     *
     * @param element &lt;argument&gt;vfElement
     * @exception DeploymentException &lt;argument&gt;vf̉́Ǎʂɂ郁^f[^̐Ɏsꍇ
     */
    @Override
    public void importXML(Element element) throws DeploymentException{
        super.importXML(element);
        
        if(!element.getTagName().equals(ARGUMENT_TAG_NAME)){
            throw new DeploymentException(
                "Tag must be " + ARGUMENT_TAG_NAME + " : "
                 + element.getTagName()
            );
        }
        
        type = getOptionalAttribute(element, TYPE_ATTRIBUTE_NAME);
        if(type != null && type.length() == 0){
            throw new DeploymentException(
                "Element of " + ARGUMENT_TAG_NAME + " must have valid " + TYPE_ATTRIBUTE_NAME + " attribute."
            );
        }
        valueType = getOptionalAttribute(element, VALUE_TYPE_ATTRIBUTE_NAME);
        if(valueType != null && valueType.length() == 0){
            throw new DeploymentException(
                "Element of " + ARGUMENT_TAG_NAME + " must have valid " + VALUE_TYPE_ATTRIBUTE_NAME + " attribute."
            );
        }
        
        final String isNullValueStr = getOptionalAttribute(
            element,
            TYPE_ATTRIBUTE_NULL_VALUE
        );
        if(isNullValueStr != null){
            isNullValue = Boolean.valueOf(isNullValueStr).booleanValue();
            if(isNullValue){
                return;
            }
        }
        
        if(Element.class.getName().equals(type)){
            Element valueElement = getOptionalChild(element);
            if(valueElement != null){
                value = valueElement.cloneNode(true);
            }
            return;
        }
        
        final Element serviceRefElement = getOptionalChild(
            element,
            ServiceRefMetaData.SERIVCE_REF_TAG_NAME
        );
        if(serviceRefElement != null){
            final ServiceRefMetaData serviceRefData
                 = new ServiceRefMetaData(this, parentObjData == null ? null : parentObjData.getManagerName());
            serviceRefData.importXML(serviceRefElement);
            value = serviceRefData;
            return;
        }
        
        final Element objectElement = getOptionalChild(
            element,
            ObjectMetaData.OBJECT_TAG_NAME
        );
        if(objectElement != null){
            final ObjectMetaData objectData = new ObjectMetaData(
                parentObjData == null ? null : parentObjData.getServiceLoader(),
                this,
                parentObjData == null ? null : parentObjData.getManagerName()
            );
            objectData.importXML(objectElement);
            value = objectData;
            return;
        }
        
        final Element staticInvokeElement = getOptionalChild(
            element,
            StaticInvokeMetaData.STATIC_INVOKE_TAG_NAME
        );
        if(staticInvokeElement != null){
            final StaticInvokeMetaData staticInvokeData
                 = new StaticInvokeMetaData(this);
            staticInvokeData.importXML(staticInvokeElement);
            value = staticInvokeData;
            return;
        }
        
        final Element staticFieldElement = getOptionalChild(
            element,
            StaticFieldRefMetaData.STATIC_FIELD_REF_TAG_NAME
        );
        if(staticFieldElement != null){
            final StaticFieldRefMetaData staticFieldData
                 = new StaticFieldRefMetaData(this);
            staticFieldData.importXML(staticFieldElement);
            value = staticFieldData;
            return;
        }
        
        value = getElementContent(element);
        if(value == null){
            value = "";
        }
    }
    
    /**
     * ̃CX^X̕\擾B<p>
     *
     * @return \
     */
    @Override
    public String toString(){
        final StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append('{');
        if(getType() != null){
            buf.append(TYPE_ATTRIBUTE_NAME);
            buf.append('=');
            buf.append(getType());
            buf.append(',');
        }
        buf.append(value);
        buf.append('}');
        return buf.toString();
    }
    
    @Override
    public StringBuilder toXML(StringBuilder buf){
        appendComment(buf);
        buf.append('<').append(ARGUMENT_TAG_NAME);
        if(type != null){
            buf.append(' ').append(TYPE_ATTRIBUTE_NAME)
                .append("=\"").append(type).append("\"");
        }
        if(isNullValue){
            buf.append(' ').append(TYPE_ATTRIBUTE_NULL_VALUE)
                .append("=\"true\"");
            buf.append("/>");
        }else{
            if(valueType != null){
                buf.append(' ').append(VALUE_TYPE_ATTRIBUTE_NAME)
                    .append("=\"").append(valueType).append("\"");
            }
            buf.append('>');
            if(value != null){
                if(value instanceof MetaData){
                    buf.append(LINE_SEPARATOR);
                    buf.append(
                        addIndent(((MetaData)value).toXML(new StringBuilder()))
                    );
                    buf.append(LINE_SEPARATOR);
                }else{
                    final String str = value.toString();
                    if(str.indexOf('\r') != -1
                        || str.indexOf('\n') != -1){
                        buf.append(LINE_SEPARATOR);
                        buf.append(addIndent(str));
                        buf.append(LINE_SEPARATOR);
                    }else{
                        buf.append(str);
                    }
                }
            }
            buf.append("</").append(ARGUMENT_TAG_NAME).append('>');
        }
        return buf;
    }
}
