/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

public interface Service{
    
    /**
     * T[rX̏Ԃ\񋓌^萔łB<p>
     */
    public static enum State{
        /**  */
        CREATING,
        /**  */
        CREATED,
        /** Jn */
        STARTING,
        /** Jn */
        STARTED,
        /** ~ */
        STOPPING,
        /** ~ */
        STOPPED,
        /** j */
        DESTROYING,
        /** j */
        DESTROYED,
        /** s */
        FAILED,
        /** s */
        UNKNOWN;
        
        public String toString(){
            switch(this){
            case CREATING:
                return "Creating";
            case CREATED:
                return "Created";
            case STARTING:
                return "Starting";
            case STARTED:
                return "Started";
            case STOPPING:
                return "Stopping";
            case STOPPED:
                return "Stopped";
            case DESTROYING:
                return "Destroying";
            case DESTROYED:
                return "Destroyed";
            case FAILED:
                return "Failed";
            case UNKNOWN:
            default:
                return "Unknown";
            }
        }
        
        public static State toState(String value){
            
            if(State.CREATING.toString().equals(value)){
                return State.CREATING;
            }else if(State.CREATED.toString().equals(value)){
                return State.CREATED;
            }else if(State.STARTING.toString().equals(value)){
                return State.STARTING;
            }else if(State.STARTED.toString().equals(value)){
                return State.STARTED;
            }else if(State.STOPPING.toString().equals(value)){
                return State.STOPPING;
            }else if(State.STOPPED.toString().equals(value)){
                return State.STOPPED;
            }else if(State.DESTROYING.toString().equals(value)){
                return State.DESTROYING;
            }else if(State.DESTROYED.toString().equals(value)){
                return State.DESTROYED;
            }else if(State.FAILED.toString().equals(value)){
                return State.FAILED;
            }else{
                return State.UNKNOWN;
            }
        }
    };
    
    /**
     * ̃T[rX̓o^ƂȂ{@link ServiceManager}̃T[rX擾܂B<p>
     *
     * @return ServiceManager̃T[rX
     * @see #setServiceManagerName(String)
     */
    public String getServiceManagerName();
    
    /**
     * ̃T[rX̓o^ƂȂ{@link ServiceManager}̃T[rXݒ肵܂B<p>
     *
     * @param name ServiceManager̃T[rX
     * @see #getServiceManagerName()
     */
    public void setServiceManagerName(String name);
    
    /**
     * T[rXݒ肵܂B<p>
     *
     * @param name T[rX
     * @see #getServiceName()
     */
    public void setServiceName(String name);
    
    /**
     * T[rX擾܂B<p>
     *
     * @return T[rX
     * @see #setServiceName(String)
     */
    public String getServiceName();
    
    /**
     * ̃T[rX̓o^ƂȂ{@link ServiceManager}̃T[rXƂ̃T[rX̃T[rX܂{@link ServiceName}擾܂B<p>
     *
     * @return T[rX
     */
    public ServiceName getServiceNameObject();
    
    /**
     * ݂̃T[rXԂ擾܂B<p>
     *
     * @return Ԃl
     */
    public State getState();
    
    /**
     * T[rX𐶐܂B<p>
     * ̃T[rXɕKvȃIuWFNg̐Ȃǂ̏s܂B<br>
     *
     * @exception Exception T[rX̐Ɏsꍇ
     */
    public void create() throws Exception;
    
    /**
     * T[rXJn܂B<p>
     * ̃T[rX𗘗p\ȏԂɂ܂B̃\bȟĂяóÃT[rX̋@\𗘗pł鎖ۏ؂܂B<br>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void start() throws Exception;
    
    /**
     * T[rX~܂B<p>
     * ̃T[rX𗘗ps\ȏԂɂ܂B̃\bȟĂяóÃT[rX̋@\𗘗pł鎖͕ۏ؂܂B<br>
     */
    public void stop();
    
    /**
     * T[rXj܂B<p>
     * ̃T[rXŎgp郊\[XJ܂B̃\bȟĂяóÃT[rX̋@\𗘗pł鎖͕ۏ؂܂B<br>
     */
    public void destroy();
}